/*
 * @(#)NonserializableTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.io.*;

class NonSerializable {
    int t1;
    int t2;

    protected NonSerializable() {
	t1 = 1;
	t2 = 2;
    }

    public boolean equals(Object o) {
	NonSerializable other = (NonSerializable)o;
	if (other.t1 != this.t1 ||
	    other.t2 != this.t2)
	    return false;
	return true;
    }

    public String toString() {
	return "t1: " + t1 + " t2: " + t2;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
	throw new IOException("Should not be in NonSerializable::writeObject");
    }
    private void readObject(ObjectInputStream s) throws IOException {
	throw new IOException("Should not be in NonSerializable::readObject");
    }
}

class NonserializableTest
		extends NonSerializable
		implements java.io.Serializable {
    int a1;

    NonserializableTest() {
	a1 = 2;
    }

    public boolean equals(Object o) {
	NonserializableTest other = (NonserializableTest)o;
	if (other.a1 != this.a1 || !super.equals(o))
	    return false;
	return true;
    }

    public String toString() {
	return "a1: " + a1 + " " + super.toString();
    }


    // Write out the field t1 of the non-serializable class
    private void writeObject(ObjectOutputStream s) throws IOException {
	s.writeInt(t1);
	s.writeInt(a1);
    }
    // Read in and restore the field t1 of the non-serializable class
    private void readObject(ObjectInputStream s) throws IOException {
	t1 = s.readInt();
	a1 = s.readInt();
    }

    /**
     * Test that only the fields (t2 and a1) that are explicitly handled
     * by NonserializableTest write and read methods are saved and restore.
     */
    public static void main (String argv[]) {
	NonserializableTest a = new NonserializableTest();
	a.t1 = 5;
	a.t2 = 7;

	FileInputStream istream = null;
	try {
	    FileOutputStream ostream =
		new FileOutputStream("nonserializabletest.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);
	    p.writeObject(a);
	    p.flush();

	    istream = new FileInputStream("nonserializabletest.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    NonserializableTest a_result = (NonserializableTest)q.readObject();

	    if (a.a1 != a_result.a1 ||
		a.t1 != a_result.t1 ||
		a_result.t2 != 2) {
		System.out.println("Able test failed");
		System.out.println("a = " + a);
		System.out.println("a_result = " + a_result);
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	    System.out.println("Input remaining");
	    int ch;
	    try {
		while ((ch = istream.read()) != -1)
		    System.out.print(Integer.toString(ch, 16)+ " ");
		System.out.println();
		
	    } catch (Exception f) {
	    }
	    
	}
    }
}

