/*
 * @(#)URLTest.java	1.2 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.io.*;
import java.net.URL;

class URLTest implements java.io.Serializable {

    /**
     * Test that instances of the File class are written and read correctly
     */
    public static void main (String argv[]) {
	FileInputStream istream = null;
	try {
	    FileOutputStream ostream = new FileOutputStream("_URLTest.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    URL a = new URL("http://java.sun.com/index.html#foo");
	    p.writeObject(a);
	    p.flush();

	    istream = new FileInputStream("_URLTest.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    URL a_result = (URL)q.readObject();

	    if (!a.equals(a_result)) {
		System.err.println("URL test failed");
		System.err.println("a = " + a);
		System.err.println("a_result = " + a_result);
	    }
	}
	catch (Exception e) {
	    e.printStackTrace();
	    System.err.println("Input remaining");
	    int ch;
	    try {
		while ((ch = istream.read()) != -1)
		    System.err.print(Integer.toString(ch, 16)+ " ");
		System.err.println();
		
	    } catch (Exception f) {
	    }
	    
	}
    }
}

