/*
 * @(#)piotest.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */
import java.io.*;

import BinaryTreeTest;
import CircularListTest;
import ArrayOpsTest;
import ArrayTest;
import PrimitivesTest;


class piotest {
    public static void main (String argv[]) {
      if (argv.length > 0) {
	  for (int i = 0; i < argv.length; i++) {
	      if (argv[i].equals("test1"))
		  test1();
	      if (argv[i].equals( "test2"))
		  test2();
	      if (argv[i].equals( "test3"))
		  test3();
	      if (argv[i].equals( "test4"))
		  test4();
	      if (argv[i].equals( "test5"))
		  test5();
	      if (argv[i].equals( "test6"))
		  test6();
	      if (argv[i].equals( "test7"))
		  test7();
	  }
      } else {
	  test1();
	  test2();
	  test3();
	  test4();
	  test5();
	  test6();
	  test7();
      }
    }

    /** 
     * Test that all the primitive write* methods work.
     */
    public static void test1() {
	FileInputStream istream = null;
	try {
	    System.out.println("Test1: Object with primitive types");System.out.flush();
	    
	    int i = 123456;
	    byte b = 12;
	    short s = 45;
	    char c = 'A';
	    long l = 1234567890000L;
	    float f = 3.14159f;
	    double d = f*2;
	    boolean z = true;
	    String string = "The String";
	    PrimitivesTest prim = new PrimitivesTest();
	    {
		
		FileOutputStream ostream = new FileOutputStream("piotest1.tmp");
		ObjectOutputStream p = new ObjectOutputStream(ostream);


		p.writeInt(i);
		p.writeByte(b);
		p.writeShort(s);
		p.writeChar(c);
		p.writeLong(l);
		p.writeFloat(f);
		p.writeDouble(d);
		p.writeBoolean(z);
		p.writeUTF(string);
		p.writeObject(string);
		
		p.writeObject(prim);
		p.flush();
	    }
	    
	    {
		istream = new FileInputStream("piotest1.tmp");
		ObjectInputStream q = new ObjectInputStream(istream);

		int i_u = q.readInt();
		byte b_u = q.readByte();
		short s_u = q.readShort();
		char c_u = q.readChar();
		long l_u = q.readLong();
		float f_u = q.readFloat();
		double d_u = q.readDouble();
		boolean z_u = q.readBoolean();
		String string_utf = q.readUTF();
		String string_u = (String)q.readObject();

		if (i != i_u)
		    System.out.println("int:  expected " + i + " actual " +i_u); 

		if (b != b_u)
		    System.out.println("byte:  expected " + b + " actual " +b_u); 

		if (s != s_u)
		    System.out.println("short:  expected " + s + " actual " +s_u); 
		if (c != c_u)
		    System.out.println("char:  expected " + c + " actual " +c_u); 
		if (l != l_u)
		    System.out.println("long:  expected " + l + " actual " +l_u); 
		if (f != f_u)
		    System.out.println("float:  expected " + f + " actual " +f_u); 
		if (d != d_u)
		    System.out.println("double:  expected " + d + " actual " + d_u);
		if (z != z_u)
 		    System.out.println("boolean:  expected " + z + " actual " + z_u);
		if (!string.equals(string_utf))
		    System.out.println("String:  expected " + string + " actual " + string_utf); 
		if (!string.equals(string_u))
		    System.out.println("String:  expected " + string + " actual " + string_u); 
		
		PrimitivesTest prim_u = (PrimitivesTest)q.readObject();
		if (!prim.equals(prim_u)) {
		    System.out.println("Read primitive object correctly = " +
				   false);
		    System.out.println(prim);
		    System.out.println(prim_u);
		}
	    }
	    
	}
	catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	    System.out.println("Input remaining");
	    int ch;
	    try {
		
		while ((ch = istream.read()) != -1)
		    System.out.print(Integer.toString(ch, 16)+ " ");
		System.out.println();
		
	    } catch (Exception f) {
	    }
	    
	}
    }

    public static void test2() {
	FileInputStream istream = null;
	try {
	    System.out.println("Test2: Simple Arrays");System.out.flush();

	    FileOutputStream ostream = new FileOutputStream("piotest2.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    byte b[] = { 0, 1};
	    p.writeObject((Object)b);

	    short s[] = { 0, 1, 2};
	    p.writeObject((Object)s);

	    char c[] = { 'A', 'B', 'C', 'D'};
	    p.writeObject((Object)c);

	    int i[] = { 0, 1, 2, 3, 4};
	    p.writeObject((Object)i);

	    long l[] = { 0, 1, 2, 3, 4, 5};
	    p.writeObject((Object)l);

	    boolean z[] = new boolean[4];
	    z[0] = true;
	    z[1] = false;
	    z[2] = true;
	    z[3] = false;
	    p.writeObject(z);

	    float f[] = { 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f};
	    p.writeObject((Object)f);

	    double d[] = { 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0d};
	    p.writeObject((Object)d);

	    String string[] = { "A", "B", "C", "D"};
	    p.writeObject((Object) string);

	    PrimitivesTest prim[] = new PrimitivesTest[5];
	    prim[0] = new PrimitivesTest();
	    prim[1] = prim[0];
	    prim[2] = new PrimitivesTest();
	    prim[3] = prim[2];
	    prim[4] = null;
	    p.writeObject((Object)prim);
		    
	    p.flush();

	    /* now read them back */

	    istream = new FileInputStream("piotest2.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    Object obj;
	    
	    byte b_u[] = (byte[])q.readObject();
	    short s_u[] = (short[])q.readObject();
	    char c_u[] = (char[])q.readObject();
	    int i_u[] = (int[])q.readObject();
	    long l_u[] = (long[])q.readObject();
	    
	    /* This should be boolean, but they were serialized as bytes
	     */
	    boolean z_u[] = null;
	    Object z_obj = null;
	    try {
		z_obj = q.readObject();
		z_u = (boolean[])z_obj;
	    }
	    catch (ClassCastException e) {
		System.out.println("ClassCastException " + e.getMessage());
		System.out.println("Boolean array read as " +
				   z_obj.getClass().getName());		
		e.printStackTrace();
		z_u = z;
	    }

	    float f_u[] = (float[])q.readObject();
	    double d_u[] = (double[])q.readObject();
	    String string_u[] = (String[])q.readObject();
	    
	    PrimitivesTest prim_u[] = (PrimitivesTest[])q.readObject();
	    
	    
	    if (!ArrayOpsTest.verify(i, i_u))
		System.out.println("Unpickling of int array failed");
	    if (!ArrayOpsTest.verify(b, b_u))
		System.out.println("Unpickling of byte array failed");
	    if ( !ArrayOpsTest.verify(s, s_u))
		System.out.println("Unpickling of short array failed");
	    if ( !ArrayOpsTest.verify(c, c_u))
		System.out.println("Unpickling of char array failed");
	    if ( !ArrayOpsTest.verify(l, l_u))
		System.out.println("Unpickling of long array failed");
	    if ( !ArrayOpsTest.verify(f, f_u))
		System.out.println("Unpickling of float array failed");
	    if ( !ArrayOpsTest.verify(d, d_u))
		System.out.println("Unpickling of double array failed");
	    if ( !ArrayOpsTest.verify(z, z_u))
		System.out.println("Unpickling of boolean array failed");
	    if ( !ArrayOpsTest.verify(string, string_u))
		System.out.println("Unpickling of String array failed");
	    if (!ArrayOpsTest.verify(prim, prim_u)){
		System.out.println("Unpickling of PrimitivesTest array failed");
	    }

	} catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	    System.out.println("Input remaining");
	    int ch;
	    try {
		
		while ((ch = istream.read()) != -1)
		    System.out.print(Integer.toString(ch, 16)+ " ");
		System.out.println();
		
	    } catch (Exception f) {
	    }
	    
	}
    }


    public static void test3() {
	try {
	    System.out.println("Test3: BinaryTree");System.out.flush();

	    FileOutputStream ostream = new FileOutputStream("piotest3.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    BinaryTreeTest base = new BinaryTreeTest(2);
	    p.writeObject(null);
	    p.writeObject(base);
	    p.flush();
	    ostream.close();

	    FileInputStream istream = new FileInputStream("piotest3.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    Object n = q.readObject();
	    if (n != null) {
		System.out.println("null read as " + n);
	    }
	    BinaryTreeTest nbase = (BinaryTreeTest)q.readObject();
	    if (!base.equals(nbase)) {
		System.out.println("BinaryTree read incorrectly.");
	    }
	}
	catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	}
    }

    public static void test4() {
	try {
	    System.out.println("Test4: Arrays in object fields");System.out.flush();

	    FileOutputStream ostream = new FileOutputStream("piotest4.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    ArrayTest array = new ArrayTest();
	    p.writeObject(array);
	    p.flush();

	    FileInputStream istream = new FileInputStream("piotest4.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    Object obj = null;
	    try {
		obj = q.readObject();
	    } catch (ClassCastException ee) {
		System.out.println(ee.getMessage());
		System.out.println("Boolean array read as byte array" +
				   " could not be assigned to field z");	
		ee.printStackTrace();
	    }
	     
	    ArrayTest array_u = (ArrayTest)obj;
	    if (!array.equals(array_u))
		System.out.println("Unpickling of objects with ArrayTest failed");
	}
	catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	}
    }

    public static void test5() {
	System.out.println("Test5: Arrays of Arrays");System.out.flush();

	FileInputStream istream = null;
	try {
	    FileOutputStream ostream = new FileOutputStream("piotest5.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    byte b[][] = {{ 0, 1}, {2,3}};
	    p.writeObject((Object)b);

	    short s[][] = {{ 0, 1, 2}, {3,4,5}};
	    p.writeObject((Object)s);

	    char c[][] = {{ 0, 1, 2, 3}, {4, 5, 6, 7}};
	    p.writeObject((Object)c);

	    int i[][] = {{ 0, 1, 2, 3, 4}, {5, 6, 7, 8, 9}};
	    p.writeObject((Object)i);

	    long l[][] = {{ 0, 1, 2, 3, 4, 5}, {6,7,8,9,10,11}};
	    p.writeObject((Object)l);

	    boolean z[][] = new boolean[2][2];
	    
	    z[0][0] = true;
	    z[0][1] = false;
	    z[1] = z[0];	// Use first row same as second
	    
	    p.writeObject((Object)z);

	    float f[][] = {{ 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f},
		       { 1.1f, 2.1f, 3.1f, 4.1f, 5.1f, 6.1f}};
	    p.writeObject((Object)f);

	    double d[][] = {{ 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0d},
			{ 1.1f, 2.1f, 3.1f, 4.1f, 5.1f, 6.1f, 7.1d}};
	    p.writeObject((Object)d);

	    Integer Int[][] = {{ new Integer(3), new Integer(2)},
			       { new Integer(1), new Integer(0)}};
	    p.writeObject((Object)Int);

	    p.flush();
	    
	    /* Now read them back and verify
	     */
	    istream = new FileInputStream("piotest5.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    byte b_u[][] = (byte [][]) (q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("Byte array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}
	   

	    short s_u[][] = (short [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("short array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}

	    char c_u[][] = (char [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("char array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}

	    int i_u[][] = (int [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("int array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}

	    long l_u[][] = (long [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("long array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}

	    boolean z_u[][] = (boolean [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("boolean array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}

	    float f_u[][] = (float [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("float array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}

	    double d_u[][] = (double [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("double array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}

	    Integer Int_u[][] = (Integer [][])(q.readObject());
	    for (int ix = 0; ix < b_u.length; ix++)
		for(int iy = 0; iy < b_u[ix].length; iy++) {
		    if (b[ix][iy] != b_u[ix][iy])
			System.out.println("Integer array mismatch [" + ix + "][" +
					   iy + " expected " + b[ix][iy] +
					   " actual = " + b_u[ix][iy]);
		}


	}
	catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	    System.out.println("Input remaining");
	    int ch;
	    try {
		
		while ((ch = istream.read()) != -1)
		    System.out.print(Integer.toString(ch, 16)+ " ");
		System.out.println();
		
	    } catch (Exception f) {
	    }
	    
	}
    }


    public static void test6() {
	try {
	    System.out.println("Test6: Serialize with exceptions on the I/O stream");
	    System.out.flush();

	    int i = 123456;
	    byte b = 12;
	    short s = 45;
	    char c = 'A';
	    long l = 1234567890000L;
	    float f = 3.14159f;
	    double d = f*2;
	    boolean z = true;
	    String string = "The String";
	    PrimitivesTest prim = new PrimitivesTest();
	    
	    /* For each of the byte offsets from 0 to 100,
	       do the pickling but expect an exception */
	    for (int offset = 0; offset < 200; offset++) {
		ExceptionOutputStream ostream;
		boolean expect_exception = false;
		IOException exception = null;
		
		try {
		    expect_exception = true;
		    exception = null;

		    ostream = new ExceptionOutputStream();
		    ostream.setExceptionOffset(offset);
		    ObjectOutputStream p = new ObjectOutputStream(ostream);
		    

		    p.writeInt(i);
		    p.writeByte(b);
		    p.writeShort(s);
		    p.writeChar(c);
		    p.writeLong(l);
		    p.writeFloat(f);
		    p.writeDouble(d);
		    p.writeBoolean(z);
		    p.writeUTF(string);
		    p.writeObject(string);
		
		    p.writeObject(prim);
		    p.flush();
		    expect_exception = false;
		} catch (IOException ee) {
		    exception = ee;
		}

		if (expect_exception && exception == null) {
		    System.out.println("IOException did not occur at offset " +
				       offset);
		}
		if (!expect_exception && exception != null) {
		    System.out.println(exception.toString() +
				       " not expected at offset " +
				       offset);
		}
		
		  
	    }
	    
	}
	catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	}
    }

    public static void test7() {
	try {
	    System.out.println("Test7: Circular List");System.out.flush();

	    FileOutputStream ostream = new FileOutputStream("piotest7.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    CircularListTest.setup();
	    p.writeObject(CircularListTest.list);
	    p.flush();

	    FileInputStream istream = new FileInputStream("piotest7.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    CircularListTest cv = (CircularListTest)q.readObject();
	    if (cv != cv.next) {
		System.out.println("Circular List Test failed, next != self");
	    }
	}
	catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	}
    }

}

