/*
 * @(#)psiotest.java	1.3 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.io.*;


class psiotest { 
  
    public static void main (String argv[]) {
	if (argv.length > 0) {
	    for (int i = 0; i < argv.length; i++) {
		if (argv[i].equals("test1"))
		    test1();
		if (argv[i].equals( "test2"))
		    test2();
		if (argv[i].equals( "test3"))
		    test3();
		if (argv[i].equals( "test4"))
		    test4();
	    }
	} else {
	    test1();
	    test2();
	    test3();
	    test4();
	}
    }
   
    /** Test pickling and unpickling a object with derived classes
     * and using a read special to serialize the "middle" class.
     */
    public static void test1() {
	
	System.out.println("Test1: Serialize classes with specials");

	FileInputStream istream = null;
	try {
	   
	    thirdpsio objout = new thirdpsio();
	    objout.init();

	    FileOutputStream ostream = new FileOutputStream("psiotest1.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    p.writeObject(objout);

	    p.flush();
	    ostream.close();
	    
	    istream = new FileInputStream("psiotest1.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    thirdpsio objin = (thirdpsio)q.readObject();

	    if (!objout.equals(objin)) {
		System.out.println("Original and read objects not equal.");
	    }
	    istream.close();
	} catch (Exception e) {
	    e.printStackTrace();
	    System.out.println("Input remaining");
	    int ch;
	    try {
		while ((ch = istream.read()) != -1)
		    System.out.print(Integer.toString(ch, 16)+ " ");
		System.out.println();
	    } catch (Exception f) {
	    }
	}
    }

    /** Test that raising an exception in a special will terminate the pickling
     * This allows a Class to prevent itself from being serialized.
     */
    public static void test2() {

	System.out.println("Test2: Test for missing writeObject or readObject");
	
	FileInputStream istream = null;
	try {
	    FileOutputStream ostream = new FileOutputStream("psiotest2.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    /* Catch the expected exception and
	     * complain if it does not occur.
	     */
	    MissingWriterClass w = new MissingWriterClass();

	    MethodMissingException we = null;
	    try {
		p.writeObject(w);
	    } catch (MethodMissingException e) {
		we = e;
	    }
	    if (we == null) {
		System.out.println("Read of MissingWriterClass should have raised an exception");
	    }
	    
	    
	    /* Catch the expected exception and
	     * complain if it does not occur.
	     */
	    MissingReaderClass r = new MissingReaderClass();
	    try {
		we = null;
		
		p.writeObject(r);
	    } catch (MethodMissingException e) {
		we = e;
	    }
	    if (we == null) {
		System.out.println("Read of MissingReaderClass should have raised an exception");
	    }

	    p.flush();
	    ostream.close();
	} catch (Exception e) {
	    System.out.println(e.getClass().getName());
	    
	    e.printStackTrace();
	}
    }

    public static void test3() {
	
	System.out.println("Test3: ObjectOutputStream raising an exception");
	
	FileInputStream istream = null;
	try {
	   
	    FileOutputStream ostream = new FileOutputStream("psiotest3.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    /* Catch the expected exception and
	     * complain if it does not occur.
	     */
	    TryPickleClass npc = new TryPickleClass();

	    NotSerializableException we = null;
	    try {
		// Two objects of the same class that are used in cleanup test below
		p.writeObject("test");
		p.writeObject("test2");
		p.writeObject(npc);
	    } catch (NotSerializableException e) {
		we = e;
	    }
	    if (we == null) {
		System.out.println("Write of NoPickleClass should have raised an exception");
	    }
	    
	    
	    p.flush();
	    ostream.close();


	    istream = new FileInputStream("psiotest3.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    /* Catch the expected exception and
	     * complain if it does not occur.
	     */
	    TryPickleClass npc_u;

	    NotSerializableException re = null;
	    try {
		// Read the two objects, neither has a cleanup method
		q.readObject();
		q.readObject();
		npc_u = (TryPickleClass)q.readObject();
	    } catch (NotSerializableException e) {
		re = e;
	    }
	    if (re == null) {
		System.out.println("Read of NoPickleClass should have raised an exception");
	    }

	    istream.close();
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public static void test4() {
	
	System.out.println("Test4: Test validation callbacks");
	
	FileInputStream istream = null;
	try {
	   
	    FileOutputStream ostream = new FileOutputStream("psiotest4.tmp");
	    ObjectOutputStream p = new ObjectOutputStream(ostream);

	    /* Catch the expected exception and
	     * complain if it does not occur.
	     */

	    // Serialize a bunch of objects that will be validated when read
	    // Make a list of classes with intermingled priorities
	    ValidateClass vc = new ValidateClass(0, null);
	    vc = new ValidateClass(2, vc);
	    vc = new ValidateClass(0, vc);
	    vc = new ValidateClass(3, vc);
	    vc = new ValidateClass(Integer.MIN_VALUE, vc);
	    vc = new ValidateClass(1, vc);
	    vc = new ValidateClass(1, vc);
	    vc = new ValidateClass(0, vc);

	    p.writeObject(vc);
	    p.flush();
	    ostream.close();

	    istream = new FileInputStream("psiotest4.tmp");
	    ObjectInputStream q = new ObjectInputStream(istream);

	    ValidateClass vc_u;

	    vc_u = (ValidateClass)q.readObject();
	    if (vc_u.validated != Integer.MIN_VALUE) {
		System.out.println("Validation callbacks did not complete.");
	    }
	    istream.close();
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }
}

class firstpsio implements java.io.Serializable { /* No specials defined */

    String one;
    int two;
    float three[];
   
    void init() { /* called only before writing */
	one = "one"; two = 2; 
	three = new float[5];
	float f = 3.0f;
	for ( int i=0; i<5 ;  i++) { f+=0.11; three[i] = f; }
    }
    /* Compare two first objects */
    boolean equals(firstpsio other) 
    {
	boolean ret = true;
	
	if (!one.equals(other.one)) {
	    System.out.println("firstpsio: expected " + one +
			       " actual " + other.one);
	    ret = false;
	}
	if (two != other.two) {
	    System.out.println("firstpsio: expected " + two +
			       " actual " + other.two);
	    ret = false;
	}

	for (int i = 0; i < three.length; i++ ) {
	    if (three[i] != other.three[i]) {
		
		System.out.println("firstpsio: three[" + i + "] expected " + three[i] +
				   " actual " + other.three[i]);
		ret = false;
	    }
	    
	}
	return ret;
    }
    
}

class secondpsio extends firstpsio  {

    String quatre;
    int cinq;

    private void writeObject(ObjectOutputStream pw)
	throws IOException
    {
	pw.writeObject(quatre);
	pw.writeInt(cinq);
    }

    private void readObject(ObjectInputStream pr)
	throws StreamCorruptedException, IOException, ClassNotFoundException
    {
	if (one == null)
	    throw new StreamCorruptedException("Superclass not serialized when it should have been");
    
	quatre = (String)pr.readObject();
	cinq = pr.readInt();
    }

    boolean equals(secondpsio other) {
	boolean ret = super.equals(other);
	
	if (!quatre.equals(other.quatre)) {
	    System.out.println("secondpsio: quatre expected " + quatre +
			       " actual " + other.quatre);
	    ret = false;
	}
	if (cinq != other.cinq) {
	    System.out.println("secondpsio: cinq expected " + cinq +
			       " actual " + other.cinq);
	    ret = false;
	}
	return ret;
    }
    
    void init() { /* called only before writing */
	quatre = "4444";
	cinq = 5;
	super.init();
    }
}

class thirdpsio extends secondpsio {

    static String ign = "ignored"; 
    transient Object oh;

    int six; 
 
    private static int seven[];
    protected byte eight = (byte)9;
    final static byte dcare = (byte) 128;
    private short nine = 8888;
    long ten; 
    java.util.Enumeration zero;
 

    boolean equals(thirdpsio other) {
	boolean ret = super.equals(other);
	
	if (six != other.six) {
	    System.out.println("thirdpsio six " + six +
			       " actual " + other.six);
	    ret = false;
	}
	if (eight != other.eight) {
	    System.out.println("thirdpsio eight - expected " + eight +
			       " actual " + other.eight);
	    ret = false;
	}
	if (nine != other.nine) {
	    System.out.println("thirdpsio nine - expected " + nine +
			       " actual " + other.nine);
	    ret = false;
	}
	if (ten != other.ten) {
	    System.out.println("thirdpsio ten - expected " + ten +
			       " actual " + other.ten);
	    ret = false;
	}
	if (zero != other.zero) {
	    System.out.println("thirdpsio zero - expected " + zero +
			       " actual " + other.zero);
	    ret = false;
	}
	return ret;
    }

    void init() { /* called only before writing */
	six = 666;

	int s7[] = { 7, 7, 7 };
	seven = s7;
	eight = (byte)8;
	nine = (short)9;
	ten = (long)100000;
	java.util.Enumeration em = null; /* default */

        super.init();
    }

}






class PickleClass implements java.io.Serializable {
    int ii = 17;
    transient int tmp[];
    
    private void writeObject(ObjectOutputStream pw)
	throws IOException
    {
	pw.writeUTF("PickleClass");
	pw.writeInt(ii);
    }

    private void readObject(ObjectInputStream pr)
	throws IOException
    { 
	tmp = new int[32];

	pr.readUTF();
	ii = pr.readInt();
    }

    private void readObjectCleanup(ObjectInputStream pr) 
    {
	System.out.println("	PickleClass cleanup correctly called on abort.");
	if (tmp != null)
	    tmp = null;
    }
    
}

class NoPickleClass extends PickleClass {
    private void writeObject(ObjectOutputStream pw)
	throws NotSerializableException
    {
	throw new NotSerializableException("NoPickleClass");
    }

    private void readObject(ObjectInputStream pr)
	throws NotSerializableException
    { 
	throw new NotSerializableException("NoPickleClass");
    }
}

class TryPickleClass  extends NoPickleClass {
    int i = 7;
    transient int tmp[];
    
    private void writeObject(ObjectOutputStream pw)
	throws IOException
    {
	pw.writeInt(i);
    }

    private void readObject(ObjectInputStream pr)
	throws IOException
    { 
	tmp = new int[32];
	
	i = pr.readInt();
    }

    private void readObjectCleanup(ObjectInputStream pr) 
    {
	System.out.println("Cleanup called on abort");
	if (tmp != null)
	    tmp = null;
    }
    
}

class MissingWriterClass implements java.io.Serializable 
{
    int i = 77;
   
    private void writeObject(ObjectOutputStream pw)
	throws IOException
    { 
	pw.writeInt(i);
    }
}

class MissingReaderClass implements java.io.Serializable 
{
    int i = 77;
   
    private void readObject(ObjectInputStream pr)
	throws IOException
    { 
	i = pr.readInt();
    }
}

    
class ValidateClass implements ObjectInputValidation, java.io.Serializable  {
    public ValidateClass(int prio, ValidateClass n) {
	priority = prio;
	next = n;
    }

    static int validated = Integer.MAX_VALUE; // Last value validated
    int priority;
    ValidateClass next = null;

    // Handle serialization/deserialization 
    private void writeObject(ObjectOutputStream pw)
	throws IOException
    {
	pw.writeInt(priority);
	pw.writeObject(next);
    }

    private void readObject(ObjectInputStream pr)
	throws IOException, ClassNotFoundException
    { 
	priority = pr.readInt();
	next = (ValidateClass)pr.readObject();

	pr.registerValidation(this, priority);
    }

    public void validateObject() throws ObjectInvalidException {
	if (validated < priority) {
	    throw new ObjectInvalidException("Validations called out of order: " +
					     "Previous priority: " +
					     validated + " < " +
					     "new priority: " +
					     priority);
	}
	validated = priority;					     
    }
}
