/*
 * @(#)subtest.java	1.4 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

import java.io.*;

class subtest {
    public static void main (String argv[]) {
	System.out.println("Test1: Test of annotateClass/replaceObject");
	System.out.flush();
	try {

	    FileOutputStream ostream = new FileOutputStream("subtest1.tmp");
	    TestOutputStream p = new TestOutputStream(ostream);

	    p.writeObject(System.out);
	    p.writeObject(System.err);
	    p.writeObject(new PrintStream(ostream));
	    p.flush();
	    ostream.close();

	    FileInputStream istream = new FileInputStream("subtest1.tmp");
	    TestInputStream q = new TestInputStream(istream);

	    PrintStream out = (PrintStream)q.readObject();
	    PrintStream err = (PrintStream)q.readObject();
	    Object other = q.readObject();
	    if (out != System.out) {
		System.out.println("System.out not read correctly");
	    }
	    if (err != System.err) {
		System.out.println("System.err not read correctly");
	    }
	    if (other != null) {
		System.out.println("Non-system PrintStream should have been written/read as null");
	    }
	}
	catch (Exception e) {
	    System.out.println("An Exception occurred: " +
			   e.getMessage());
	    e.printStackTrace();
	}
    }
}


/** ObjectOutputStream is extended to test the annotateClass()
 * and replaceObject() subclassable methods.
 * In annotateClass a magic string is written to the stream
 * so that it can be verified in ObjectInputStream.
 * replaceObject is used to subsititute a handle object for
 * one of the standard PrintStreams (stdout or stderr).
 */
class TestOutputStream extends ObjectOutputStream { 
    /* Construct a new test stream */
    TestOutputStream(OutputStream out)  throws IOException {
	super(out);
    }

    /* When any class is written, add a "magic" string
     * that must be verified by the TestInputStream.
     */
    protected void annotateClass(Class cl)
	throws IOException
    {
	this.writeUTF("magic");
    }

    /* For each object of type PrintStream, substitute
     * a StdStream handle object that encodes which
     * of the standard print streams is being written.
     * Other objects are written as themselves.
     */
    protected Object replaceObject(Object obj)
	throws IOException
    {
	/* For PrintStreams, like stdout and stderr, encode */
	if (obj instanceof PrintStream) {
	    return new StdStream((PrintStream)obj);
	}
	return obj;
    }
}

/** Reverse the effects of TestOutputStream.
 */
class TestInputStream extends ObjectInputStream { 

    TestInputStream(InputStream in)  throws IOException  {
	super(in);
    }

    /** Verify that the magic string was written to the stream
     * Also use the default classname->class resolution.
     */
    protected Class resolveClass(ObjectStreamClass classdesc)
	throws ClassNotFoundException, IOException
    {
	try {
	    String s = readUTF();
	    if (!(s.equals("magic")))
		throw new RuntimeException("Bad magic number");
	} catch (IOException ee) {
	    throw new RuntimeException("I/O Exception");
	}
	return super.resolveClass(classdesc);
    }

    /** If the object in the stream is a StdStream,
     * get the mapping of it to the local System printstream and
     * return it.
     * Other objects are returned as themselves.
     */
    protected Object resolveObject(Object obj)
    {
	if (obj instanceof StdStream) {
	    return ((StdStream)obj).getStream();
	}
	return obj;
    }
}

/* A holder class to map between standard print streams (stdout, stderr)
 * and a small integer.
 */
class StdStream implements java.io.Serializable {
    private int stream = 0;

    public StdStream(PrintStream s) {
	if (s == System.out)
	    stream = 1;
	else if (s == System.err)
	    stream = 2;
    }

    public PrintStream getStream() {
	if (stream == 1)
	    return System.out;
	else if (stream == 2)
	    return System.err;
	else
	    return null;
    }
}
