/*
 * @(#)queue.h	1.7 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

/*
 * A set of queue handling macros for processes.  Generic to Green
 * threads package.
 */

#ifndef _GREEN_QUEUE_H_
#define _GREEN_QUEUE_H_

#include "monitor_md.h"
#include "threads_md.h"

typedef sys_thread_t * queue_t;	/* linked through "waitq" field */

extern queue_t runnable_queue;

void queueInsert(queue_t *, sys_thread_t *);
int queueRemove(queue_t *, sys_thread_t *);
int queueSignal(sys_mon_t *, queue_t *);
void queueWait(sys_mon_t *, queue_t *);
void queueBroadcast(sys_mon_t *);
#define queueRemoveHead(q, t) (t=*(q), (t ? *(q)=(t)->waitq : 0), t)

#endif /* !_GREEN_QUEUE_H_ */
