/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.text.TextBoundaryData;

final class SimpleTextBoundary
extends BreakIterator {
    private int pos;
    private CharacterIterator text;
    private TextBoundaryData data;
    private static final char END_OF_STRING = '\uffff';

    protected SimpleTextBoundary(TextBoundaryData textBoundaryData) {
        this.data = textBoundaryData;
        this.text = new StringCharacterIterator("");
        this.pos = this.text.getBeginIndex();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleTextBoundary)) {
            return false;
        }
        SimpleTextBoundary simpleTextBoundary = (SimpleTextBoundary)object;
        if (this.data.getClass() != simpleTextBoundary.data.getClass()) {
            return false;
        }
        if (this.hashCode() != simpleTextBoundary.hashCode()) {
            return false;
        }
        if (this.pos != simpleTextBoundary.pos) {
            return false;
        }
        return this.text.equals(simpleTextBoundary.text);
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.text.hashCode();
    }

    public Object clone() {
        try {
            SimpleTextBoundary simpleTextBoundary = (SimpleTextBoundary)super.clone();
            simpleTextBoundary.text = (CharacterIterator)this.text.clone();
            return simpleTextBoundary;
        }
        catch (InternalError internalError) {
            throw new InternalError();
        }
    }

    public CharacterIterator getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = new StringCharacterIterator(string);
        this.pos = this.text.getBeginIndex();
    }

    public void setText(CharacterIterator characterIterator) {
        this.text = characterIterator;
        this.pos = this.text.getBeginIndex();
    }

    public int first() {
        this.pos = this.text.getBeginIndex();
        return this.pos;
    }

    public int last() {
        this.pos = this.text.getEndIndex();
        return this.pos;
    }

    public int next(int n) {
        int n2 = this.current();
        if (n < 0) {
            int n3 = n;
            while (n3 < 0 && n2 != -1) {
                n2 = this.previous();
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 > 0 && n2 != -1) {
                n2 = this.next();
                --n4;
            }
        }
        return n2;
    }

    public int previous() {
        if (this.pos > this.text.getBeginIndex()) {
            int n = this.pos;
            int n2 = this.pos = this.previousSafePosition(this.pos - 1);
            int n3 = this.next();
            while (n3 < n && n3 != -1) {
                n2 = n3;
                n3 = this.next();
            }
            this.pos = n2;
            return this.pos;
        }
        return -1;
    }

    public int next() {
        int n = this.pos;
        n = this.pos < this.text.getEndIndex() ? (this.pos = this.nextPosition(this.pos)) : -1;
        return n;
    }

    public int following(int n) {
        int n2;
        if (n < this.text.getBeginIndex() || n >= this.text.getEndIndex()) {
            throw new IllegalArgumentException("nextBoundaryAt offset out of bounds");
        }
        this.pos = this.previousSafePosition(n);
        while ((n2 = this.next()) <= n && n2 != -1) {
        }
        return n2;
    }

    public int current() {
        return this.pos;
    }

    private int previousSafePosition(int n) {
        int n2 = this.text.getBeginIndex();
        int n3 = this.data.backward().initialState();
        char c = this.text.setIndex(n);
        while (c != '\uffff' && !this.data.backward().isEndState(n3)) {
            n3 = this.data.backward().get(n3, this.mappedChar(c));
            if (this.data.backward().isMarkState(n3)) {
                n2 = this.text.getIndex();
            }
            c = this.text.previous();
        }
        return n2;
    }

    private int nextPosition(int n) {
        int n2 = this.text.getEndIndex();
        int n3 = this.data.forward().initialState();
        char c = this.text.setIndex(n);
        while (c != '\uffff' && !this.data.forward().isEndState(n3)) {
            n3 = this.data.forward().get(n3, this.mappedChar(c));
            if (this.data.forward().isMarkState(n3)) {
                n2 = this.text.getIndex();
            }
            c = this.text.next();
        }
        if (this.data.forward().isEndState(n3)) {
            return n2;
        }
        n3 = this.data.forward().get(n3, this.mappedChar('\uffff'));
        if (this.data.forward().isMarkState(n3)) {
            return this.text.getEndIndex();
        }
        return n2;
    }

    protected int mappedChar(char c) {
        return this.data.map().mappedChar(c);
    }
}

