/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.systemresource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import sun.applet.AppletAudioClip;
import sun.awt.image.ByteArrayImageSource;
import sun.awt.image.FileImageSource;
import sun.net.www.protocol.systemresource.ParseSystemURL;

public class SystemResourceManager {
    private static boolean debug;
    private URL url;
    private String base;
    private String member;
    private boolean isZip;
    private String compoundName;

    SystemResourceManager(URL uRL) throws MalformedURLException {
        this.url = uRL;
        ParseSystemURL parseSystemURL = new ParseSystemURL(uRL);
        String string = parseSystemURL.getBase();
        try {
            this.base = SystemResourceManager.getEntryFromKey(Integer.parseInt(string));
        }
        catch (Exception exception) {
            this.base = null;
        }
        this.member = parseSystemURL.getMember();
        this.isZip = parseSystemURL.isZip();
        if (this.base == null) {
            throw new MalformedURLException(String.valueOf(uRL) + " is not a valid system resource URL");
        }
        this.compoundName = String.valueOf(this.base) + File.separator + this.member;
        if (!parseSystemURL.isValid()) {
            throw new MalformedURLException(String.valueOf(uRL) + " is not a valid system resource URL");
        }
        if (!SystemResourceManager.validateSystemResource(this.isZip, this.base, this.member)) {
            throw new SecurityException(String.valueOf(uRL) + " refers to a non system resource");
        }
    }

    synchronized Object getLocalResource() {
        if (this.isZip) {
            return this.getFromZip();
        }
        return this.getFromFile();
    }

    InputStream getLocalResourceStream() {
        SystemResourceManager.debug("SystemResourceManager.getLocalResourceStream::");
        if (this.isZip) {
            SystemResourceManager.debug("  isZip; base: " + this.base + " member: " + this.member);
            byte[] byArray = SystemResourceManager.getZipResourceByteArray(this.base, this.member);
            return new ByteArrayInputStream(byArray);
        }
        try {
            return new BufferedInputStream(new FileInputStream(this.compoundName));
        }
        catch (Exception exception) {
            SystemResourceManager.debug("Could not locate a resource base: " + this.base + " member: " + this.member);
            return null;
        }
    }

    private Object getFromZip() {
        String string;
        byte[] byArray = SystemResourceManager.getZipResourceByteArray(this.base, this.member);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            string = URLConnection.guessContentTypeFromStream(byteArrayInputStream);
        }
        catch (IOException iOException) {
            string = null;
        }
        if (string != null) {
            if (string.startsWith("image")) {
                return new ByteArrayImageSource(byArray);
            }
            if (string.startsWith("audio")) {
                return new AppletAudioClip(byArray);
            }
        }
        return byteArrayInputStream;
    }

    private Object getFromFile() {
        String string;
        BufferedInputStream bufferedInputStream;
        if (this.compoundName.regionMatches(true, this.compoundName.length() - 6, ".class", 0, 6)) {
            throw new SecurityException("Can't read classfile as system resource");
        }
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(this.compoundName));
        }
        catch (Exception exception) {
            SystemResourceManager.debug("Could not locate a resource base: " + this.base + " member: " + this.member);
            return null;
        }
        try {
            string = URLConnection.guessContentTypeFromStream(bufferedInputStream);
        }
        catch (IOException iOException) {
            SystemResourceManager.debug("Exception while guessing Content Type; e: " + iOException);
            string = null;
        }
        if (string != null) {
            if (string.startsWith("image")) {
                SystemResourceManager.debug("getFromFile:: base: " + this.base + " member: " + this.member);
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {}
                return new FileImageSource(this.compoundName);
            }
            if (string.startsWith("audio")) {
                byte[] byArray = SystemResourceManager.byteArrayFromStream(bufferedInputStream);
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException) {}
                return new AppletAudioClip(byArray);
            }
        }
        return bufferedInputStream;
    }

    private static byte[] byteArrayFromStream(InputStream inputStream) {
        try {
            int n = inputStream.available();
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = inputStream.read(byArray, n2, n - n2);
                if (n3 < 0) {
                    return null;
                }
                n2 += n3;
            }
            return byArray;
        }
        catch (Exception exception) {
            SystemResourceManager.debug("Unexpected internal exception... " + exception);
            throw new Error("Unexpected internal exception");
        }
    }

    static void debug(String string) {
        if (debug) {
            System.out.println("SystemResourceManager:: " + string);
        }
    }

    private static native String getEntryFromKey(int var0);

    private static native byte[] getZipResourceByteArray(String var0, String var1);

    private static native boolean validateSystemResource(boolean var0, String var1, String var2);

    static {
        System.loadLibrary("sysresource");
    }
}

