## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::EqPhoX
## Author: Bryan Jurish <moocow@cpan.org>
## Description: phonetic-equivalence class expansion: intensional via gfsmxl cascade

##==============================================================================
## Package: Analyzer::Morph
##==============================================================================
package DTA::CAB::Analyzer::EqPhoX;
use DTA::CAB::Analyzer::EqPho::Cascade;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::EqPho::Cascade);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Automaton::Gfsm::XL
sub new {
  my $that = shift;
  my $aut = $that->SUPER::new(
			      ##-- defaults

			      ##-- analysis selection
			      label => 'eqphox',
			      analyzeGet => '$_->{msafe} || $_->{exlex} || !$_->{lts} ? qw() : (map {$_->{hi}} @{$_->{lts}})',
			      attInput   => 1,
			      allowTextRegex => DTA::CAB::Analyzer::_am_wordlike_regex(),
			      tolower=>0,
			      tolowerNI=>0,
			      toupperI=>0,

			      ##-- analysis parameters (obsolete: prefer use of 'analyzePre' key)
			      max_weight => [1.2,10],
			      max_paths  => 8,
			      max_ops    => -1,

			      ##-- verbosity
			      check_symbols => 0,

			      ##-- user args
			      @_
			     );
  return $aut;
}

1; ##-- be happy

__END__

##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl, edited

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::EqPhoX - phonetic equivalence class expansion: intensional, via gfsmxl cascade

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 ##========================================================================
 ## PRELIMINARIES
 
 use DTA::CAB::Analyzer::EqPhoX;
 

=cutx

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

This module is just a wrapper for
L<DTA::CAB::Analyzer::EqPho::Cascade|DTA::CAB::Analyzer::EqPho::Cascade>
which sets the following analyzer defaults:

 label => 'eqphox',
 analyzeGet => '$_->{lts} ? (map {$_->{hi}} @{$_->{lts}}) : qw()',
 attInput   => 1,
 allowTextRegex => DTA::CAB::Analyzer::_am_wordlike_regex(),
 tolower=>0,
 tolowerNI=>0,
 toupperI=>0,
 ##
 ##-- analysis parameters
 max_weight => [1.2,10],
 max_paths  => 8,
 max_ops    => -1,
 

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================
=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2011-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=head1 SEE ALSO

L<dta-cab-analyze.perl(1)|dta-cab-analyze.perl>,
L<DTA::CAB::Analyzer::EqPho::Cascade(3pm)|DTA::CAB::Analyzer::EqPho::Cascade>,
L<DTA::CAB::Analyzer(3pm)|DTA::CAB::Analyzer>,
L<DTA::CAB::Chain(3pm)|DTA::CAB::Chain>,
L<DTA::CAB(3pm)|DTA::CAB>,
L<perl(1)|perl>,
...



=cut
