use ExtUtils::MakeMaker;

WriteMakefile(
    NAME              => 'Runops::Recorder',
    VERSION_FROM      => 'lib/Runops/Recorder.pm', # finds $VERSION
    PREREQ_PM         => {
        Term::Screen    => 0,
    }, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Runops/Recorder.pm', # retrieve abstract from module
       AUTHOR         => 'Claes Jakobsson <claesjac@cpan.org>') : ()),
    EXE_FILES               => [qw(bin/rr-viewer)],
);

if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw());
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'Runops::Recorder',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
