# Generated by default/object.tt
package Paws::SageMaker::Image;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has Description => (is => 'ro', isa => 'Str');
  has DisplayName => (is => 'ro', isa => 'Str');
  has FailureReason => (is => 'ro', isa => 'Str');
  has ImageArn => (is => 'ro', isa => 'Str', required => 1);
  has ImageName => (is => 'ro', isa => 'Str', required => 1);
  has ImageStatus => (is => 'ro', isa => 'Str', required => 1);
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::Image

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::Image object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., LastModifiedTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::Image object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

A SageMaker image. A SageMaker image represents a set of container
images that are derived from a common base container image. Each of
these container images is represented by a SageMaker C<ImageVersion>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationTime => Str

When the image was created.


=head2 Description => Str

The description of the image.


=head2 DisplayName => Str

The name of the image as displayed.


=head2 FailureReason => Str

When a create, update, or delete operation fails, the reason for the
failure.


=head2 B<REQUIRED> ImageArn => Str

The Amazon Resource Name (ARN) of the image.


=head2 B<REQUIRED> ImageName => Str

The name of the image.


=head2 B<REQUIRED> ImageStatus => Str

The status of the image.


=head2 B<REQUIRED> LastModifiedTime => Str

When the image was last modified.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

