/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UPolygon;

public class Diamond {
    public static final double diamondHalfSize = 12.0;

    public static UPolygon asPolygon(boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(12.0, 0.0);
        uPolygon.addPoint(24.0, 12.0);
        uPolygon.addPoint(12.0, 24.0);
        uPolygon.addPoint(0.0, 12.0);
        uPolygon.addPoint(12.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        return uPolygon;
    }

    public static UPolygon asPolygon(boolean bl, double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(12.0, 0.0);
        uPolygon.addPoint(d - 12.0, 0.0);
        uPolygon.addPoint(d, d2 / 2.0);
        uPolygon.addPoint(d - 12.0, d2);
        uPolygon.addPoint(12.0, d2);
        uPolygon.addPoint(0.0, d2 / 2.0);
        uPolygon.addPoint(12.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        return uPolygon;
    }

    public static Stencil asStencil(final TextBlock textBlock) {
        return new Stencil(){

            private final double getDeltaX(double d, double d2) {
                double d3 = d2 / d * 2.0;
                if (d3 <= 1.0) {
                    return 12.0 * d3;
                }
                return 12.0 * (2.0 - d3);
            }

            public double getStartingX(StringBounder stringBounder, double d) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                return -this.getDeltaX(dimension2D.getHeight(), d);
            }

            public double getEndingX(StringBounder stringBounder, double d) {
                Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
                return dimension2D.getWidth() + this.getDeltaX(dimension2D.getHeight(), d);
            }
        };
    }

    public static UPolygon asPolygonFoo1(boolean bl, double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(d / 2.0, 0.0);
        uPolygon.addPoint(d, d2 / 2.0);
        uPolygon.addPoint(d / 2.0, d2);
        uPolygon.addPoint(0.0, d2 / 2.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        return uPolygon;
    }
}

