/*
Copyright 2015 Alexander Borisov

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Author: lex.borisov@gmail.com (Alexander Borisov)
*/

#include "myhtml/tag.h"

void myhtml_tag_init_tags(myhtml_tag_t* tags)
{
	myhtml_tag_add(tags, "-text", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "!--", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "!doctype", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "a", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "abbr", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "acronym", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "address", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "annotation-xml", 14, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "applet", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "area", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "article", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "aside", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "audio", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "b", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "base", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "basefont", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "bdi", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "bdo", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "bgsound", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "big", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "blink", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "blockquote", 10, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "body", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "br", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "button", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "canvas", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "caption", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "center", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "cite", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "code", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "col", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "colgroup", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "command", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "comment", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "datalist", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "dd", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "del", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "details", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "dfn", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "dialog", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "dir", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "div", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "dl", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "dt", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "em", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "embed", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "fieldset", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "figcaption", 10, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "figure", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "font", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "footer", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "form", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "frame", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "frameset", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "h1", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "h2", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "h3", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "h4", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "h5", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "h6", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "head", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "header", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "hgroup", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "hr", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "html", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "i", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "iframe", 6, MyHTML_TOKENIZER_STATE_RAWTEXT, myfalse);
	myhtml_tag_add(tags, "image", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "img", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "input", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "ins", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "isindex", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "kbd", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "keygen", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "label", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "legend", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "li", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "link", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "listing", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "main", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "map", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mark", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "marquee", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "menu", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "menuitem", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "meta", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "meter", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mtext", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "nav", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "nobr", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "noembed", 7, MyHTML_TOKENIZER_STATE_RAWTEXT, myfalse);
	myhtml_tag_add(tags, "noframes", 8, MyHTML_TOKENIZER_STATE_RAWTEXT, myfalse);
	myhtml_tag_add(tags, "noscript", 8, MyHTML_TOKENIZER_STATE_RAWTEXT, myfalse);
	myhtml_tag_add(tags, "object", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "ol", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "optgroup", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "option", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "output", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "p", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "param", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "plaintext", 9, MyHTML_TOKENIZER_STATE_PLAINTEXT, myfalse);
	myhtml_tag_add(tags, "pre", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "progress", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "q", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "rb", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "rp", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "rt", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "rtc", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "ruby", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "s", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "samp", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "script", 6, MyHTML_TOKENIZER_STATE_SCRIPT_DATA, myfalse);
	myhtml_tag_add(tags, "section", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "select", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "small", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "source", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "span", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "strike", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "strong", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "style", 5, MyHTML_TOKENIZER_STATE_RAWTEXT, myfalse);
	myhtml_tag_add(tags, "sub", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "summary", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "sup", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "svg", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "table", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "tbody", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "td", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "template", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "textarea", 8, MyHTML_TOKENIZER_STATE_RCDATA, myfalse);
	myhtml_tag_add(tags, "tfoot", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "th", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "thead", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "time", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "title", 5, MyHTML_TOKENIZER_STATE_RCDATA, myfalse);
	myhtml_tag_add(tags, "tr", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "track", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "tt", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "u", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "ul", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "var", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "video", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "wbr", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "xmp", 3, MyHTML_TOKENIZER_STATE_RAWTEXT, myfalse);
	myhtml_tag_add(tags, "altGlyph", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "altGlyphDef", 11, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "altGlyphItem", 12, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "animate", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "animateColor", 12, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "animateMotion", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "animateTransform", 16, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "circle", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "clipPath", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "color-profile", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "cursor", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "defs", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "desc", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "ellipse", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feBlend", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feColorMatrix", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feComponentTransfer", 19, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feComposite", 11, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feConvolveMatrix", 16, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feDiffuseLighting", 17, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feDisplacementMap", 17, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feDistantLight", 14, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feDropShadow", 12, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feFlood", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feFuncA", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feFuncB", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feFuncG", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feFuncR", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feGaussianBlur", 14, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feImage", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feMerge", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feMergeNode", 11, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feMorphology", 12, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feOffset", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "fePointLight", 12, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feSpecularLighting", 18, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feSpotLight", 11, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feTile", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "feTurbulence", 12, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "filter", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "font-face", 9, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "font-face-format", 16, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "font-face-name", 14, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "font-face-src", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "font-face-uri", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "foreignObject", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "g", 1, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "glyph", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "glyphRef", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "hkern", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "line", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "linearGradient", 14, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "marker", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mask", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "metadata", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "missing-glyph", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mpath", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "path", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "pattern", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "polygon", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "polyline", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "radialGradient", 14, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "rect", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "set", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "stop", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "switch", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "symbol", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "text", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "textPath", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "tref", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "tspan", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "use", 3, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "view", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "vkern", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "math", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "maction", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "maligngroup", 11, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "malignmark", 10, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "menclose", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "merror", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mfenced", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mfrac", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mglyph", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mi", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mlabeledtr", 10, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mlongdiv", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mmultiscripts", 13, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mn", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mo", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mover", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mpadded", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mphantom", 8, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mroot", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mrow", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "ms", 2, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mscarries", 9, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mscarry", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "msgroup", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "msline", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mspace", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "msqrt", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "msrow", 5, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mstack", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "mstyle", 6, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "msub", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "msup", 4, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "msubsup", 7, MyHTML_TOKENIZER_STATE_DATA, myfalse);
	myhtml_tag_add(tags, "-end-of-file", 12, MyHTML_TOKENIZER_STATE_DATA, myfalse);
}

void myhtml_tag_init_tags_categories(myhtml_tag_t* tags)
{
	myhtml_tag_set_category(tags, MyHTML_TAG__TEXT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG__COMMENT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG__DOCTYPE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_A, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_A, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ABBR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ACRONYM, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ADDRESS, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_ANNOTATION_XML, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_APPLET, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_AREA, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_ARTICLE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_ASIDE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_AUDIO, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_B, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_BASE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_BASEFONT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_BDI, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_BDO, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_BGSOUND, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_BIG, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_BLINK, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_BLOCKQUOTE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_BODY, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_BR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_BUTTON, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_CANVAS, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_CAPTION, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_CENTER, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_CITE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_CODE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_COL, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_COLGROUP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_COMMAND, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_COMMENT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_DATALIST, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_DD, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_DEL, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_DETAILS, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_DFN, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_DIALOG, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_DIR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_DIV, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_DL, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_DT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_EM, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_EMBED, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_FIELDSET, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_FIGCAPTION, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_FIGURE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_FONT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_FONT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FOOTER, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_FORM, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_FRAME, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_FRAMESET, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_H1, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_H2, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_H3, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_H4, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_H5, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_H6, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_HEAD, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_HEADER, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_HGROUP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_HR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_HTML, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON|MyHTML_TAG_CATEGORIES_SCOPE_TABLE);
	myhtml_tag_set_category(tags, MyHTML_TAG_I, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_IFRAME, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_IMAGE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_IMAGE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_IMG, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_INPUT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_INS, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ISINDEX, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_KBD, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_KEYGEN, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_LABEL, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_LEGEND, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_LI, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_LINK, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_LISTING, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_MAIN, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_MAP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MARK, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MARQUEE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_MENU, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_MENUITEM, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_META, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_METER, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MTEXT, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_NAV, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_NOBR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_NOEMBED, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_NOFRAMES, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_NOSCRIPT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_OBJECT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_OL, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM);
	myhtml_tag_set_category(tags, MyHTML_TAG_OPTGROUP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY|MyHTML_TAG_CATEGORIES_SCOPE_SELECT);
	myhtml_tag_set_category(tags, MyHTML_TAG_OPTION, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY|MyHTML_TAG_CATEGORIES_SCOPE_SELECT);
	myhtml_tag_set_category(tags, MyHTML_TAG_OUTPUT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_P, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_PARAM, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_PLAINTEXT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_PRE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_PROGRESS, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_Q, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_RB, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_RP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_RT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_RTC, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_RUBY, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_S, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_SAMP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SCRIPT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_SCRIPT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SECTION, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_SELECT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_SMALL, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_SOURCE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_SPAN, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_STRIKE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_STRONG, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_STYLE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_STYLE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SUB, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SUMMARY, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_SUP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SVG, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SVG, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_TABLE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON|MyHTML_TAG_CATEGORIES_SCOPE_TABLE);
	myhtml_tag_set_category(tags, MyHTML_TAG_TBODY, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_TD, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_TEMPLATE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON|MyHTML_TAG_CATEGORIES_SCOPE_TABLE);
	myhtml_tag_set_category(tags, MyHTML_TAG_TEXTAREA, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_TFOOT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_TH, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_THEAD, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_TIME, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_TITLE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_TITLE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_TR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_TRACK, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_TT, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_U, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_FORMATTING);
	myhtml_tag_set_category(tags, MyHTML_TAG_UL, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM);
	myhtml_tag_set_category(tags, MyHTML_TAG_VAR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_VIDEO, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_WBR, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_XMP, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_SPECIAL);
	myhtml_tag_set_category(tags, MyHTML_TAG_ALTGLYPH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ALTGLYPHDEF, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ALTGLYPHITEM, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ANIMATE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ANIMATECOLOR, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ANIMATEMOTION, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_ANIMATETRANSFORM, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_CIRCLE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_CLIPPATH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_COLOR_PROFILE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_CURSOR, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_DEFS, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_DESC, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_ELLIPSE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEBLEND, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FECOLORMATRIX, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FECOMPONENTTRANSFER, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FECOMPOSITE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FECONVOLVEMATRIX, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEDIFFUSELIGHTING, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEDISPLACEMENTMAP, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEDISTANTLIGHT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEDROPSHADOW, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEFLOOD, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEFUNCA, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEFUNCB, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEFUNCG, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEFUNCR, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEGAUSSIANBLUR, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEIMAGE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEMERGE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEMERGENODE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEMORPHOLOGY, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEOFFSET, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FEPOINTLIGHT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FESPECULARLIGHTING, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FESPOTLIGHT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FETILE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FETURBULENCE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FILTER, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FONT_FACE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FONT_FACE_FORMAT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FONT_FACE_NAME, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FONT_FACE_SRC, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FONT_FACE_URI, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_FOREIGNOBJECT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_G, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_GLYPH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_GLYPHREF, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_HKERN, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_LINE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_LINEARGRADIENT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MARKER, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MASK, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_METADATA, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MISSING_GLYPH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MPATH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_PATH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_PATTERN, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_POLYGON, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_POLYLINE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_RADIALGRADIENT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_RECT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SET, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_STOP, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SWITCH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_SYMBOL, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_TEXT, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_TEXTPATH, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_TREF, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_TSPAN, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_USE, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_VIEW, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_VKERN, MyHTML_NAMESPACE_SVG, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MATH, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MACTION, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MALIGNGROUP, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MALIGNMARK, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MENCLOSE, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MERROR, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MFENCED, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MFRAC, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MGLYPH, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MI, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_MLABELEDTR, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MLONGDIV, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MMULTISCRIPTS, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MN, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_MO, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_MOVER, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MPADDED, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MPHANTOM, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MROOT, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MROW, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MS, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_SPECIAL|MyHTML_TAG_CATEGORIES_SCOPE|MyHTML_TAG_CATEGORIES_SCOPE_LIST_ITEM|MyHTML_TAG_CATEGORIES_SCOPE_BUTTON);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSCARRIES, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSCARRY, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSGROUP, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSLINE, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSPACE, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSQRT, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSROW, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSTACK, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSTYLE, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSUB, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSUP, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG_MSUBSUP, MyHTML_NAMESPACE_MATHML, MyHTML_TAG_CATEGORIES_ORDINARY);
	myhtml_tag_set_category(tags, MyHTML_TAG__END_OF_FILE, MyHTML_NAMESPACE_HTML, MyHTML_TAG_CATEGORIES_ORDINARY);
}

