/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.text.Normalizer;

public class ICU4JImpl {
    Bidi bidi = new Bidi();

    public ICU4JImpl() {
        this.bidi.setReorderingMode(5);
    }

    public String makeLineLogicalOrder(String str, boolean isRtlDominant) {
        this.bidi.setPara(str, isRtlDominant ? (byte)1 : 0, null);
        return this.bidi.writeReordered(2);
    }

    public String normalizePres(String str) {
        int q;
        StringBuilder builder = null;
        int p = 0;
        for (q = 0; q < str.length(); ++q) {
            char c = str.charAt(q);
            if (('\ufb00' > c || c > '\ufdff') && ('\ufe70' > c || c > '\ufeff')) continue;
            if (builder == null) {
                builder = new StringBuilder(str.length() * 2);
            }
            builder.append(str.substring(p, q));
            if (c == '\ufdf2' && q > 0 && (str.charAt(q - 1) == '\u0627' || str.charAt(q - 1) == '\ufe8d')) {
                builder.append("\u0644\u0644\u0647");
            } else {
                builder.append(Normalizer.normalize((int)c, (Normalizer.Mode)Normalizer.NFKC).trim());
            }
            p = q + 1;
        }
        if (builder == null) {
            return str;
        }
        builder.append(str.substring(p, q));
        return builder.toString();
    }

    public String normalizeDiac(String str) {
        String retStr = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            retStr = Character.getType(c) == 6 || Character.getType(c) == 27 || Character.getType(c) == 4 ? retStr + Normalizer.normalize((int)c, (Normalizer.Mode)Normalizer.NFKC).trim() : retStr + str.charAt(i);
        }
        return retStr;
    }
}

