import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects

Rectangle {
    id: backgroundBlurDemo
    width: 1925
    height: 1080
    color: "transparent"
    clip: true

    Image {
        id: backgroundBlurDemo_merged
        anchors.fill: parent
        source: "assets/backgroundBlurDemo_merged.png"
    }

    MenuPanel {
        id: draggablePanel
        x: 603
        y: 62
        width: 397
        height: 675
        DragHandler {}

        DesignEffect {
            backgroundBlurRadius: 120
            backgroundLayer: backgroundBlurDemo_merged
            effects: [
                DesignDropShadow {}
            ]
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"0752f7c4-687f-58ea-8ecb-d175fb0c3e61"}D{i:1;uuid:"1eda7987-02bc-5b64-8042-288bf2cfa5c1"}
D{i:2;uuid:"9c73215c-cb68-5048-ba3e-519da1ccb47a"}
}
##^##*/

