import QtQuick
import QtQuick.Controls
import QtQuick.Studio.DesignEffects 1.0

Rectangle {
    id: content
    width: 93
    height: 96
    color: "transparent"
    property alias labelText: label.text
    clip: true
    state: "state_idle"

    Text {
        id: label
        color: "#bababa"
        text: qsTr("A")
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.rightMargin: -1
        font.pixelSize: 31
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.Wrap
        font.weight: Font.Bold
        font.family: "DIN Alternate"
        DesignEffect {
            id: label_DesignEffect
            visible: true
            layerBlurVisible: true
            layerBlurRadius: 1
        }
    }
    states: [
        State {
            name: "state_blocked"

            PropertyChanges {
                target: label
                color: "#606060"
            }
        },
        State {
            name: "state_checked"

            PropertyChanges {
                target: label
                color: "#bababa"
            }
        },
        State {
            name: "state_checkedHovered"

            PropertyChanges {
                target: label
                color: "#989898"
            }
        },
        State {
            name: "state_pressed"

            PropertyChanges {
                target: label
                color: "#7a7878"
            }
        },
        State {
            name: "state_checkedPressed"

            PropertyChanges {
                target: label
                color: "#7a7878"
            }
        },
        State {
            name: "state_hovered"

            PropertyChanges {
                target: label
                color: "#989898"
            }
        },
        State {
            name: "state_idle"

            PropertyChanges {
                target: label
                color: "#bababa"
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;uuid:"59bf7de1-8ab6-5bac-9c81-286621dba29c"}D{i:1;uuid:"9978f636-f18a-51a7-86b9-c9ba62d426b8"}
D{i:2;uuid:"9978f636-f18a-51a7-86b9-c9ba62d426b8_DesignEffect"}
}
##^##*/

