import QtQuick 2.8
import backend.Data 1.0 as Data

Item {
    id: gears
    width: 215
    height: 80

    property alias rText: r.text
    property alias pText: p.text
    property alias nText: n.text
    property alias dText: d.text

    Text {
        id: p
        anchors.left: gears.left
        y: (Data.Values.prndlGear === "P" ? 0 : 25) * eosADAS.scaleFactor
        width: 18
        height: 80
        color: (Data.Values.prndlGear === "P" ? "#ffffff" : "#595f66")
        text: "P"
        font.pixelSize: (Data.Values.prndlGear === "P" ? 80 : 30) * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Slate For FCA " + (Data.Values.prndlGear === "P" ? "Regular" : "Book")

        Behavior on font.pixelSize { PropertyAnimation{}}
        Behavior on y { PropertyAnimation{}}
    }

    Text {
        id: r
        anchors.left: p.right
        anchors.margins: 40 * eosADAS.scaleFactor
        y: (Data.Values.prndlGear === "R" ? 0 : 25) * eosADAS.scaleFactor
        width: 18
        height: 80
        color: (Data.Values.prndlGear === "R" ? "#ffffff" : "#595f66")
        text: "R"
        font.pixelSize: (Data.Values.prndlGear === "R" ? 80 : 30) * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Slate For FCA " + (Data.Values.prndlGear === "R" ? "Regular" : "Book")

        Behavior on font.pixelSize { PropertyAnimation{}}
        Behavior on y { PropertyAnimation{}}
    }

    Text {
        id: n
        anchors.left: r.right
        anchors.margins: 40 * eosADAS.scaleFactor
        y: (Data.Values.prndlGear === "N" ? 0 : 25) * (gears.height / 80)
        width: 18
        height: 80
        color: (Data.Values.prndlGear === "N" ? "#ffffff" : "#595f66")
        text: "N"
        font.pixelSize: (Data.Values.prndlGear === "N" ? 80 : 30) * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Slate For FCA " + (Data.Values.prndlGear === "N" ? "Regular" : "Book")

        Behavior on font.pixelSize { PropertyAnimation{}}
        Behavior on y { PropertyAnimation{}}
    }

    Text {
        id: d
        anchors.left: n.right
        anchors.margins: 40 * eosADAS.scaleFactor
        y: (Data.Values.prndlGear === "D" ? 0 : 25) * (gears.height / 80)
        width: 18
        height: 80
        color: (Data.Values.prndlGear === "D" ? "#ffffff" : "#595f66")
        text: "D"
        font.pixelSize: (Data.Values.prndlGear === "D" ? 80 : 30) * eosADAS.scaleFactor
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignTop
        wrapMode: Text.Wrap
        font.weight: Font.Normal
        font.family: "Slate For FCA " + (Data.Values.prndlGear === "D" ? "Regular" : "Book")

        Behavior on font.pixelSize { PropertyAnimation{}}
        Behavior on y { PropertyAnimation{}}
    }
}
/*##^##
Designer {
    D{i:0;formeditorZoom:10}
}
##^##*/
