import QtQuick
import QtQuick3D
Node {
    id: rootNode
    Model {
        id: car_bg
        source: "meshes/car_bg.mesh"
        receivesShadows: false
        castsShadows: false

        DefaultMaterial {
            id: car_bg_1_material
            opacity: 1
            depthDrawMode: Material.AlwaysDepthDraw
            emissiveFactor.z: 0
            emissiveFactor.y: 0
            emissiveFactor.x: 0
            specularRoughness: 1
            indexOfRefraction: 2.8
            opacityMap: car_bgSurface_opacity
            opacityChannel: Material.A
            diffuseMap: car_bgSurface_Color2
            diffuseColor: "#ffffff"
            lighting: DefaultMaterial.FragmentLighting

            Texture {
                id: car_bgSurface_Color2
                source: "../../../images/car_bgSurface_Color2.png"
                positionU: 0
            }

            Texture {
                id: car_bgSurface_opacity
                source: "../../../images/car_bgSurface_opacity.png"
            }
        }
        materials: [
            car_bg_1_material
        ]
    }
}
