import QtQuick
import QtQuick3D

Node {
    id: rootNode
    property bool night: false
    property real stateTo: 0
    property alias fakeReflections: baseroad.fakeReflections
    property bool lkas: false

    onStateToChanged: state = stateTo.toString()

    Baseroad {
        id: baseroad

        night: rootNode.night
    }

    RoadLine {
        id: roadLine
        x: 292
        y: 0.099
        highlight: false
        z: -12784.30273
        night: rootNode.night
        lkasmode: lkas
    }

    RoadLine {
        id: roadLine1
        x: 100
        y: 0.099
        highlight: false
        z: -12784.30273
        night: rootNode.night
        lkasmode: lkas
    }

    RoadLine {
        id: roadLine2
        x: -100
        y: 0.099
        highlight: false
        night: rootNode.night
        z: -12784.30273
        lkasmode: lkas
    }

    RoadLine {
        id: roadLine3
        x: -292
        y: 0.099
        highlight: false
        night: rootNode.night
        z: -12784.30273
        lkasmode: lkas
    }
    states: [
        State {
            name: "0"



            PropertyChanges {
                target: roadLine
                highlight: true
            }

            PropertyChanges {
                target: roadLine1
                highlight: true
            }

            PropertyChanges {
                target: roadLine2
                highlight: false
            }

            PropertyChanges {
                target: roadLine3
                highlight: false
            }
        },
        State {
            name: "1"


            PropertyChanges {
                target: roadLine2
                highlight: true
            }

            PropertyChanges {
                target: roadLine1
                highlight: true
            }

            PropertyChanges {
                target: roadLine
                highlight: false
            }

            PropertyChanges {
                target: roadLine3
                highlight: false
            }


        },
        State {
            name: "2"


            PropertyChanges {
                target: roadLine3
                highlight: true
            }

            PropertyChanges {
                target: roadLine2
                highlight: true
            }

            PropertyChanges {
                target: roadLine1
                highlight: false
            }

            PropertyChanges {
                target: roadLine
                highlight: false
            }
        }
    ]


}


