import QtQuick
import QtQuick3D
import QtQuick.Timeline 1.0
Node {
    id: sUVRoot
    rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
    scale.x: 100
    scale.y: 100
    scale.z: 100
    Model {
        id: sUV_BackDoorLeft_low
        x: 2.67774e-05
        y: -0.500615
        opacity: 1
        z: 0.608681
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.01
        scale.y: 0.01
        scale.z: 0.01
        source: "meshes/sUV_BackDoorLeft_low.mesh"

        PrincipledMaterial {
            id: sUV_Outside1_material
            baseColor: "#4f4f4f"
            roughness: 0
            specularReflectionMap: piecenb41
            specularTint: 0
            specularAmount: 1
            metalness: 0.8
            lightProbe: car_day_hdr1
            alphaMode: PrincipledMaterial.Opaque

            Texture {
                id: car_day_hdr1
                source: "../../../images/hdri/car_day_hdr.hdr"
                mappingMode: Texture.LightProbe
                positionU: 0
                generateMipmaps: true
                rotationUV: 0
            }

        }
        materials: [
            sUV_Outside1_material
        ]
    }
    Model {
        id: glow_1
        x: -0.655
        y: 2.16749
        visible: true
        z: 1.13639
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.01
        scale.y: 0.01133
        scale.z: 0.01
        source: "meshes/glow_1.mesh"

        PrincipledMaterial {
            id: principledMaterial
            opacity: 0.8
            specularAmount: 0.6
            lighting: PrincipledMaterial.NoLighting
            blendMode: PrincipledMaterial.Screen
            emissiveFactor.z: 0
            emissiveFactor.y: 0
            emissiveFactor.x: 2
            opacityMap: backlight_glow
            baseColorMap: backlight_glow
            baseColor: "#a44545"

            Texture {
                id: backlight_glow
                source: "../../../images/backlight_glow.png"
                generateMipmaps: true
            }
        }
        materials: principledMaterial
    }
    Model {
        id: sUV_WhiteLightGlass_low_1
        y: -3.33067e-16
        visible: true
        z: -3.33067e-16
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.01
        scale.y: 0.01
        scale.z: 0.01
        source: "meshes/sUV_WhiteLightGlass_low_1.mesh"

        PrincipledMaterial {
            id: sUV_LightOuter_material
            opacity: 1
            emissiveFactor.x: 0.7
            emissiveMap: backlight
            baseColorMap: backlight
            specularTint: 1
            lightProbe: car_day_hdr
            cullMode: Material.NoCulling
            lighting: PrincipledMaterial.FragmentLighting
            metalness: 0.1
            roughness: 0
            specularAmount: 1
            baseColor: "#f9f9f9"
            alphaMode: PrincipledMaterial.Default

            Texture {
                id: car_day_hdr
                source: "../../../images/hdri/car_day_hdr.hdr"
                generateMipmaps: true
                scaleV: 1
                positionV: 1.1
                positionU: 0
                mappingMode: Texture.LightProbe
            }

            Texture {
                id: backlight
                source: "../../../images/backlight.png"
                generateMipmaps: true
            }
        }
        materials: [
            sUV_LightOuter_material
        ]
    }
    Model {
        id: sideMirror
        x: -2.98023e-08
        y: 1.40561e-07
        visible: true
        z: -1.27704e-07
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.01
        scale.y: 0.01
        scale.z: 0.01
        source: "meshes/sideMirror.mesh"

        PrincipledMaterial {
            id: sUV_SmallParts_2_material
            metalness: 0.5
            specularReflectionMap: piecenb41
            lightProbe: car_day_hdr
            baseColor: "#161616"
            roughness: 0.2
            alphaMode: PrincipledMaterial.Opaque
        }
        materials: sUV_Windows_material
    }
    Node {
        id: backLeftDoorRoot
        x: 0.90024
        y: 0.261408
        z: -5.80443e-17
        Model {
            id: sUV_BackLeftDoorFrames_low
            x: -0.90024
            y: -0.261408
            z: -1.27704e-07
            rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
            scale.x: 0.01
            scale.y: 0.01
            scale.z: 0.01
            source: "meshes/sUV_BackLeftDoorFrames_low.mesh"
            materials: [
                sUV_SmallParts_2_material
            ]
        }
        Model {
            id: sUV_BackLeftInnerDoor_low
            x: -0.90024
            y: -0.261408
            z: 5.80443e-17
            source: "meshes/sUV_BackLeftInnerDoor_low.mesh"

            PrincipledMaterial {
                id: interior_material
                baseColor: "#010101"
                roughness: 0.535614
                alphaMode: PrincipledMaterial.Opaque
            }
            materials: [
                interior_material
            ]
        }
        Model {
            id: glass
            x: -0.90024
            y: -0.261408
            visible: true
            z: -2.75023e-16
            rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
            scale.x: 0.01
            scale.y: 0.01
            scale.z: 0.01
            source: "meshes/glass.mesh"

            PrincipledMaterial {
                id: sUV_Windows_material
                lightProbe: car_day_hdr1
                specularTint: 0
                depthDrawMode: Material.AlwaysDepthDraw
                cullMode: Material.NoCulling
                specularAmount: 0.9
                specularReflectionMap: piecenb41
                baseColor: "#ea000000"
                metalness: 0.2
                roughness: 0.1
                alphaMode: PrincipledMaterial.Blend

                Texture {
                    id: piecenb41
                    source: "../../../images/piece-nb-41.hdr"
                    rotationUV: 28
                    generateMipmaps: true
                    mappingMode: Texture.LightProbe
                }
            }
            materials: [
                sUV_Windows_material
            ]
        }
    }
    Node {
        id: backRightDoorRoot
        x: -0.90024
        y: 0.261408
        z: -5.80443e-17
        Model {
            id: sUV_BackRightInnerDoor_low
            x: 0.90024
            y: -0.261408
            z: 5.80443e-17
            source: "meshes/sUV_BackRightInnerDoor_low.mesh"
            materials: [
                interior_material
            ]
        }
    }
    Node {
        id: frontLeftDoorRoot
        x: 0.90024
        y: -0.943066
        z: 2.09403e-16
        Model {
            id: sUV_FrontLeftInnerDoor_low
            x: -0.90024
            y: 0.943066
            z: -2.09403e-16
            source: "meshes/sUV_FrontLeftInnerDoor_low.mesh"
            materials: [
                interior_material
            ]
        }
        Model {
            id: sUV_LeftTurnSignalLight_low
            x: -0.90024
            y: 0.943066
            z: -2.09403e-16
            rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
            scale.x: 0.01
            scale.y: 0.01
            scale.z: 0.01
            source: "meshes/sUV_LeftTurnSignalLight_low.mesh"

            PrincipledMaterial {
                id: sUV_SideMirrorTurnSignal_material
                baseColor: "#ffffff"
                roughness: 0.535614
                emissiveFactor: Qt.vector3d(1, 1, 1)
                alphaMode: PrincipledMaterial.Opaque
            }
            materials: [
                sUV_SideMirrorTurnSignal_material
            ]
        }
    }
    Node {
        id: frontRightDoorRoot
        x: -0.90024
        y: -0.943066
        z: 2.09403e-16
        Model {
            id: sUV_FrontRightInnerDoor_low
            x: 0.90024
            y: 0.943066
            z: -2.09403e-16
            source: "meshes/sUV_FrontRightInnerDoor_low.mesh"
            materials: [
                interior_material
            ]
        }
        Model {
            id: sUV_SidemirrorGlass_low
            x: 0.90024
            y: 0.943066
            visible: true
            z: -2.09403e-16
            source: "meshes/sUV_SidemirrorGlass_low.mesh"

            PrincipledMaterial {
                id: sUV_SideMirrorTurnsignalGlass_material
                baseColor: "#cccccc"
                roughness: 0.535614
                alphaMode: PrincipledMaterial.Blend
            }
            materials: [
                sUV_SideMirrorTurnsignalGlass_material
            ]
        }
    }
    Model {
        id: seat_back_BackLeft
        x: 0.426365
        y: 1.07098
        z: 0.774603
        rotation: Qt.quaternion(0.798201, 0.602391, 0, 0)
        source: "meshes/seat_back_BackLeft.mesh"

        PrincipledMaterial {
            id: newSeat_material
            baseColor: "#191919"
            roughness: 0.535614
            alphaMode: PrincipledMaterial.Opaque
        }
        materials: [
            newSeat_material
        ]
    }
    Model {
        id: seat_back_BackRight
        x: -0.421256
        y: 1.07098
        z: 0.774639
        rotation: Qt.quaternion(0.798201, 0.602391, 0, 0)
        scale.y: 1
        scale.z: 1
        source: "meshes/seat_back_BackRight.mesh"
        materials: [
            newSeat_material
        ]
    }
    Model {
        id: seat_back_FrontLeft
        x: 0.421146
        y: 0.163233
        z: 0.75964
        rotation: Qt.quaternion(0.798201, 0.602391, 0, 0)
        scale.y: 1
        scale.z: 1
        source: "meshes/seat_back_FrontLeft.mesh"
        materials: [
            newSeat_material
        ]
    }
    Model {
        id: seat_back_FrontRight
        x: -0.43136
        y: 0.163233
        z: 0.75964
        rotation: Qt.quaternion(0.798201, 0.602391, 0, 0)
        scale.y: 1
        scale.z: 1
        source: "meshes/seat_back_FrontRight.mesh"
        materials: [
            newSeat_material
        ]
    }
    Model {
        id: sUV_BackLight_low
        y: -3.33067e-16
        visible: true
        z: -3.33067e-16
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.01
        scale.y: 0.01
        scale.z: 0.01
        source: "meshes/sUV_BackLight_low.mesh"

        PrincipledMaterial {
            id: sUV_WhiteLights_material
            lightProbe: car_day_hdr
            depthDrawMode: Material.AlwaysDepthDraw
            cullMode: Material.NoCulling
            alphaMode: PrincipledMaterial.Blend
            baseColor: "#9a4300"
            emissiveFactor: Qt.vector3d(1, 1, 1)
        }
        materials: [
            sUV_WhiteLights_material
        ]
    }
    Model {
        id: sUV_BackLightContainers_low
        source: "meshes/sUV_BackLightContainers_low.mesh"

        PrincipledMaterial {
            id: sUV_SmallParts_material
            depthDrawMode: Material.AlwaysDepthDraw
            cullMode: Material.NoCulling
            specularAmount: 0
            baseColor: "#040404"
            roughness: 0
        }
        materials: [
            sUV_SmallParts_material
        ]
    }
    Model {
        id: sUV_BackLowerOrangeLights_low
        source: "meshes/sUV_BackLowerOrangeLights_low.mesh"

        PrincipledMaterial {
            id: sUV_RedLight_material
            baseColor: "#945a59"
            roughness: 0.535614
            emissiveFactor: Qt.vector3d(1, 0.224967, 0)
            alphaMode: PrincipledMaterial.Opaque
        }
        materials: [
            sUV_RedLight_material
        ]
    }
    Model {
        id: sUV_CarBottom_low
        source: "meshes/sUV_CarBottom_low.mesh"
        materials: [
            sUV_SmallParts_material
        ]
    }
    Model {
        id: sUV_Cluster_low
        x: -0.0176065
        y: -0.417734
        z: 0.599982
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.01
        scale.y: 0.01
        scale.z: 0.01
        source: "meshes/sUV_Cluster_low.mesh"

        PrincipledMaterial {
            id: interior_2_material
            lightProbe: car_day_hdr
            baseColor: "#101010"
            roughness: 0.535614
            alphaMode: PrincipledMaterial.Opaque
        }
        materials: [
            interior_2_material
        ]
    }
    Model {
        id: sUV_Dashboard_low
        x: 0.449326
        y: -0.835468
        z: 1.19996
        source: "meshes/sUV_Dashboard_low.mesh"

        PrincipledMaterial {
            id: interior_2_001_material
            metalness: 0.9
            baseColor: "#ffcccccc"
            roughness: 0
            alphaMode: PrincipledMaterial.Opaque
        }
        materials: [
            interior_2_001_material
        ]
    }
    Model {
        id: sUV_FrontGrill_low
        source: "meshes/sUV_FrontGrill_low.mesh"
        materials: [
            sUV_SmallParts_material
        ]
    }
    Model {
        id: sUV_FrontLightContainers_low
        source: "meshes/sUV_FrontLightContainers_low.mesh"
        materials: [
            sUV_SmallParts_material
        ]
    }
    Model {
        id: sUV_FrontLowerGrillContainer_low
        source: "meshes/sUV_FrontLowerGrillContainer_low.mesh"
        materials: [
            sUV_SmallParts_material
        ]
    }
    Model {
        id: sUV_FrunkContainer_low
        source: "meshes/sUV_FrunkContainer_low.mesh"
        materials: [
            interior_material
        ]
    }
    Model {
        id: sUV_Headlights_low
        y: -1.66533e-16
        visible: true
        z: -1.66533e-16
        rotation: Qt.quaternion(0.707107, 0.707107, 0, 0)
        scale.x: 0.01
        scale.y: 0.01
        scale.z: 0.01
        source: "meshes/sUV_Headlights_low.mesh"

        PrincipledMaterial {
            id: principledMaterial1
            emissiveFactor.x: 0
            metalness: 0.6
            specularReflectionMap: piecenb41
            lightProbe: car_day_hdr
            baseColor: "#ff4900"
        }
        materials: principledMaterial1
    }
    Model {
        id: sUV_InteriorLining_low
        source: "meshes/sUV_InteriorLining_low.mesh"
        materials: [
            interior_material
        ]
    }
    Model {
        id: sUV_OrangeLightGlass_low
        source: "meshes/sUV_OrangeLightGlass_low.mesh"

        PrincipledMaterial {
            id: sUV_RedLightCover_material
            emissiveFactor.x: 15
            baseColor: "#78cc0100"
            roughness: 0.535614
            alphaMode: PrincipledMaterial.Blend
        }
        materials: [
            sUV_RedLightCover_material
        ]
    }

    Node {
        id: trunkRoot
        y: 1.62095
        z: 1.69401
        Model {
            id: outRun_LicensePlateBack
            y: 0.736549
            z: -0.747878
            rotation: Qt.quaternion(0.982476, 0.186389, 0, 0)
            source: "meshes/outRun_LicensePlateBack.mesh"

            PrincipledMaterial {
                id: numberplate_material
                metalness: 0.4
                specularTint: 1
                specularAmount: 0.3
                specularReflectionMap: piecenb41
                lightProbe: car_day_hdr
                baseColor: "#ffffff"
                baseColorMap: Texture {
                    source: "maps/3.png"
                    minFilter: Texture.Nearest
                    generateMipmaps: true
                    mipFilter: Texture.Linear
                }
                opacityChannel: Material.A
                roughness: 0.4
                alphaMode: PrincipledMaterial.Opaque
            }
            materials: [
                numberplate_material
            ]
        }
        Model {
            id: qWtEmblemBack
            x: 0.00029
            y: -1.3325
            z: -1.66312
            rotation: Qt.quaternion(-5.55056e-08, -5.55056e-08, -0.707107, 0.707107)
            scale.x: 1
            scale.y: 1
            scale.z: 1
            source: "meshes/qWtEmblemBack.mesh"

            PrincipledMaterial {
                id: qtEmblem_material
                roughness: 0.3
                specularTint: 1
                specularAmount: 1
                lightProbe: piecenb41
                baseColor: "#7B7B7B"
                metalness: 0.8
                alphaMode: PrincipledMaterial.Opaque
            }
            materials: [
                qtEmblem_material
            ]
        }
        Model {
            id: sUV_BackBreakLightr_low
            y: -1.62095
            z: -1.69401
            source: "meshes/sUV_BackBreakLightr_low.mesh"

            PrincipledMaterial {
                id: sUV_BrakeRearLight_material
                emissiveFactor.z: 0
                emissiveFactor.x: 0
                emissiveFactor.y: 0
                baseColor: "#dd5d5d"
                roughness: 0.535614

                alphaMode: PrincipledMaterial.Opaque
            }
            materials: [
                sUV_BrakeRearLight_material
            ]
        }


    }

    Timeline {
        id: timelineMainCar
        animations: [
            TimelineAnimation {
                id: timelineAnimationMainCar
                loops: 1
                duration: 1000
                running: false
                to: 1000
                from: 0
            }
        ]
        startFrame: 0
        enabled: true
        endFrame: 1000

        KeyframeGroup {
            target: piecenb41
            property: "rotationUV"
            Keyframe {
                value: 2
                frame: 1000
            }

            Keyframe {
                value: 28
                frame: 0
            }
        }
    }
    states: [
        State {
            name: "day"
            when: !globalNightMode

            PropertyChanges {
                target: timelineMainCar
                enabled: true
            }

            PropertyChanges {
                target: sUV_Outside1_material
                roughness: 0
                metalness: 0.8
                specularAmount: 0.7
                baseColor: "#6a6a6a"
            }



            PropertyChanges {
                target: sUV_Windows_material
                metalness: 0.6
                baseColor: "#ea1f1f1f"
            }

            PropertyChanges {
                target: car_day_hdr1
                rotationUV: 0
                positionU: 0
            }

            PropertyChanges {
                target: timelineAnimationMainCar
                running: true
            }

        },
        State {
            name: "night"
            when: globalNightMode

            PropertyChanges {
                target: timelineMainCar
                enabled: true
            }

            PropertyChanges {
                target: sUV_Outside1_material
                metalness: 1
                specularAmount: 0.1
                baseColor: "#16121d"
            }

            PropertyChanges {
                target: sUV_Windows_material
                metalness: 0.7
                baseColor: "#ea000000"
            }

            PropertyChanges {
                target: car_day_hdr1
                pivotU: 0
                rotationUV: 0
                positionU: 0
            }

            PropertyChanges {
                target: timelineAnimationMainCar
                running: true
            }


        }


    ]
    transitions: [
        Transition {
            id: transition1
            ParallelAnimation {
                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: sUV_Outside1_material
                        property: "metalness"
                        duration: 2000
                    }
                }

                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: sUV_Outside1_material
                        property: "baseColor"
                        duration: 2000
                    }
                }

                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: sUV_Outside1_material
                        property: "specularAmount"
                        duration: 2000
                    }
                }
            }

            ParallelAnimation {
                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: sUV_Windows_material
                        property: "baseColor"
                        duration: 2000
                    }
                }
            }
            to: "*"
            from: "*"
        }
    ]
}

/*##^##
Designer {
    D{i:0}D{i:3}D{i:2}D{i:1}D{i:19}D{i:18}D{i:54;invisible:true}D{i:63}
}
##^##*/
