/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick

Item {
    id:carpositioner
    property real lane1position: -20
    property real lane2position: 0
    property real lane3position: 20
    property real prevDesiredposition: 1
    property real desiredposition: 1
    property real newcarposition: 0
    property var positions: [lane1position,lane2position,lane3position]
    property bool turningleft: false
    property bool turning: false
    property real carRotation: 0
    property real targetedPos: 0

    onDesiredpositionChanged: {
        turningleft = prevDesiredposition > desiredposition
        prevDesiredposition = desiredposition
        laneSequence.running = true
        turning = true
        targetedPos = positions[prevDesiredposition]
    }

    SequentialAnimation{
        id: laneSequence
        running: false
        onStarted: turning = true
        onStopped: turning = false
        PauseAnimation {
            duration: 3000
        }
        ParallelAnimation {
            onStopped: turning = false
            NumberAnimation {
                target: carpositioner
                property: "newcarposition"
                to: positions[prevDesiredposition]
                duration: 2000
                easing.type: Easing.InOutQuad
            }
            SequentialAnimation {
                NumberAnimation {
                    target: carpositioner
                    property: "carRotation"
                    to: turningleft ? 1 : -1
                    duration: 1000
                    easing.type: Easing.InOutQuad
                }
                NumberAnimation {
                    target: carpositioner
                    property: "carRotation"
                    to: 0
                    duration: 1000
                    easing.type: Easing.InOutQuad
                }
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;autoSize:true;formeditorZoom:0.75;height:480;width:640}
}
##^##*/
