VARYING vec2 vTexCoord;
VARYING vec4 vColor;
VARYING vec3 vNormal;
VARYING vec3 vAbsNormal;
VARYING vec3 normalCoord;

float fresnel = 1.0;
VARYING vec2 screenC;
VARYING float vdepth;

void MAIN(){
	BASE_COLOR = baseColor;
	SPECULAR_AMOUNT = 1.0;
	ROUGHNESS = 0.50;
	METALNESS = 0.0;
	
	fresnel = smoothstep(0.0,1.0,abs(dot(VIEW_VECTOR,VAR_WORLD_NORMAL)));
}



void POST_PROCESS()
{	
	float depthSample = texture(DEPTH_TEXTURE, screenC).x;
	
	vec3 df = vec3(0.0);
	df.x = texture(dfMask, normalCoord.yz).x;	
	df.y = texture(dfMask, normalCoord.xz).y;	
	df.z = texture(dfMask, normalCoord.yx).z;	
	
	float dfDot = dot(vAbsNormal, df);
	float a = vColor.a*dfDot;
	a *= mix(smoothstep(0.50,1.0,dfDot*fresnel),1.0,pow(fresnel,3.0));
	
	float depthFade = smoothstep(0.0,0.01,abs(depthSample-gl_FragCoord.z));
	depthFade *= smoothstep(0.50,1.0,gl_FragCoord.z);
	a *= depthFade;
	a *= opacity;
	COLOR_SUM = vec4((DIFFUSE.rgb + SPECULAR.rgb)*mix(0.50,1.0,a),a);
}