import QtQuick 2.10
import QtQuick.Templates 2.1 as T
import highendivisystem 1.0

T.Switch {
    id: toggleswitch

    implicitWidth: graphic.width
    implicitHeight: graphic.height

    property alias graphicMirror: graphic.mirror
    property alias graphicpressedMirror: graphicpressed.mirror
    property alias graphicpressedSource: graphicpressed.source
    property alias graphicSource: graphic.source

    background: buttonBackground
    Rectangle {
        id: buttonBackground
        color: "transparent"
        implicitWidth: graphic.width
        implicitHeight: graphic.height
        opacity: enabled ? 1 : 0.3
        Image {
            visible: true
            mirror: false
            id: graphic
            source: "img/plus.png"
        }
        Image {
            visible: false
            mirror: false
            id: graphicpressed
            source: "img/plus.png"
        }
    }

    states: [
        State {
            name: "off"
            when: !toggleswitch.checked && !toggleswitch.down
        },
        State {
            name: "on"
            when: toggleswitch.checked && !toggleswitch.down

            PropertyChanges {
                target: graphic
                visible: false
            }

            PropertyChanges {
                target: graphicpressed
                visible: true
            }
        },
        State {
            name: "off_down"
            when: !toggleswitch.checked && toggleswitch.down

            PropertyChanges {
                target: graphic
                visible: true
            }

            PropertyChanges {
                target: graphicpressed
                visible: false
            }
        },
        State {
            name: "on_down"
            when: toggleswitch.checked && toggleswitch.down

            PropertyChanges {
                target: graphic
                visible: false
            }

            PropertyChanges {
                target: graphicpressed
                visible: true
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;autoSize:true;height:480;width:640}
}
##^##*/

