/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app;

import java.io.Closeable;
import java.io.IOException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.log.Logger;

public abstract class ImgFile
implements Closeable {
    private static final Logger log = Logger.getLogger(ImgFile.class);
    private CommonHeader header;
    private ImgFileWriter writer;
    private ImgFileReader reader;
    private boolean readable;
    private boolean writable;

    @Override
    public void close() {
        try {
            this.sync();
        }
        catch (IOException e) {
            log.debug((Object)"could not sync file");
        }
        Utils.closeFile(this.writer);
        Utils.closeFile(this.reader);
    }

    public int position() {
        if (this.readable) {
            return (int)this.reader.position();
        }
        return this.writer.position();
    }

    protected CommonHeader getHeader() {
        return this.header;
    }

    public long getSize() {
        if (this.writable) {
            return this.writer.getSize();
        }
        throw new UnsupportedOperationException("getSize not implemented for read");
    }

    protected void position(long pos) {
        this.writer.position(pos);
    }

    protected final void sync() throws IOException {
        if (!this.writable) {
            return;
        }
        this.getWriter().sync();
    }

    protected ImgFileWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(ImgFileWriter writer) {
        this.writable = true;
        this.writer = writer;
    }

    protected ImgFileReader getReader() {
        return this.reader;
    }

    protected void setReader(ImgFileReader reader) {
        this.readable = true;
        this.reader = reader;
    }

    protected final void setHeader(CommonHeader header) {
        this.header = header;
    }

    protected boolean isWritable() {
        return this.writable;
    }
}

