/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.util.HashMap;
import java.util.Map;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.Exit;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.labelenc.BaseEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.ExitFacility;
import uk.me.parabola.imgfmt.app.lbl.Highway;
import uk.me.parabola.imgfmt.app.lbl.LBLHeader;
import uk.me.parabola.imgfmt.app.lbl.POIIndex;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.lbl.PlacesFile;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class LBLFile
extends ImgFile {
    private static final Logger log = Logger.getLogger(LBLFile.class);
    private CharacterEncoder textEncoder = CodeFunctions.getDefaultEncoder();
    private final Map<EncodedText, Label> labelCache = new HashMap<EncodedText, Label>();
    private final LBLHeader lblHeader = new LBLHeader();
    private final PlacesFile places = new PlacesFile();
    private Sort sort;
    private final int offsetMultiplier = 1;

    public LBLFile(ImgChannel chan, Sort sort) {
        this.sort = sort;
        this.lblHeader.setSort(sort);
        this.lblHeader.setOffsetMultiplier(1);
        this.setHeader(this.lblHeader);
        this.setWriter(new BufferedImgFileWriter(chan));
        this.position(196 + this.lblHeader.getSortDescriptionLength());
        this.getWriter().put((byte)0);
        this.alignForNext();
        this.places.init(this, this.lblHeader.getPlaceHeader());
        this.places.setSort(sort);
        this.labelCache.put(BaseEncoder.NO_TEXT, Label.NULL_OUT_LABEL);
    }

    public void write() {
        this.writeBody();
    }

    public void writePost() {
        ImgFileWriter writer = this.getWriter();
        this.getHeader().writeHeader(writer);
        writer.put(Utils.toBytes(this.sort.getDescription()));
        writer.put((byte)0);
        assert (writer.position() == 196 + this.lblHeader.getSortDescriptionLength());
    }

    private void writeBody() {
        this.lblHeader.setLabelSize(this.getWriter().position() - (196 + this.lblHeader.getSortDescriptionLength()));
        this.places.write(this.getWriter());
    }

    public void setCharacterType(String cs, boolean forceUpper) {
        log.info((Object)("encoding type " + cs));
        CodeFunctions cfuncs = CodeFunctions.createEncoderForLBL(cs);
        this.lblHeader.setEncodingType(cfuncs.getEncodingType());
        this.textEncoder = cfuncs.getEncoder();
        if (forceUpper && this.textEncoder instanceof BaseEncoder) {
            BaseEncoder baseEncoder = (BaseEncoder)((Object)this.textEncoder);
            baseEncoder.setUpperCase(true);
        }
    }

    public void setEncoder(int encodingType, int codepage) {
        CodeFunctions cfuncs = CodeFunctions.createEncoderForLBL(encodingType, codepage);
        this.lblHeader.setEncodingType(cfuncs.getEncodingType());
        this.textEncoder = cfuncs.getEncoder();
    }

    public Label newLabel(String text) {
        EncodedText encodedText = this.textEncoder.encodeText(text);
        Label l = this.labelCache.get(encodedText);
        if (l == null) {
            l = new Label(encodedText.getChars());
            this.labelCache.put(encodedText, l);
            l.setOffset(this.getNextLabelOffset());
            l.write(this.getWriter(), encodedText);
            this.alignForNext();
            if (l.getOffset() > 0x3FFFFF) {
                throw new MapFailedException("Overflow of LBL section");
            }
        }
        return l;
    }

    private void alignForNext() {
        while ((this.getCurrentLabelOffset() & 1) != 0) {
            this.getWriter().put((byte)0);
        }
    }

    private int getNextLabelOffset() {
        return this.getCurrentLabelOffset() >> 1;
    }

    private int getCurrentLabelOffset() {
        return this.position() - (196 + this.lblHeader.getSortDescriptionLength());
    }

    public POIRecord createPOI(String name) {
        return this.places.createPOI(name);
    }

    public POIRecord createExitPOI(String name, Exit exit) {
        return this.places.createExitPOI(name, exit);
    }

    public POIIndex createPOIIndex(String name, int poiIndex, Subdivision group, int type) {
        return this.places.createPOIIndex(name, poiIndex, group, type);
    }

    public Country createCountry(String name, String abbr) {
        return this.places.createCountry(name, abbr);
    }

    public Region createRegion(Country country, String region, String abbr) {
        return this.places.createRegion(country, region, abbr);
    }

    public City createCity(Region region, String city, boolean unique) {
        return this.places.createCity(region, city, unique);
    }

    public City createCity(Country country, String city, boolean unique) {
        return this.places.createCity(country, city, unique);
    }

    public Zip createZip(String code) {
        return this.places.createZip(code);
    }

    public Highway createHighway(Region region, String name) {
        return this.places.createHighway(region, name);
    }

    public ExitFacility createExitFacility(int type, char direction, int facilities, String description, boolean last) {
        return this.places.createExitFacility(type, direction, facilities, description, last);
    }

    public void allPOIsDone() {
        this.places.allPOIsDone();
    }

    public void setSort(Sort sort) {
        this.sort = sort;
        this.lblHeader.setSort(sort);
        this.places.setSort(sort);
    }

    public int numCities() {
        return this.places.numCities();
    }

    public int numZips() {
        return this.places.numZips();
    }
}

