/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr11Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr18Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;

public class Mdr19
extends MdrSection
implements HasHeaderFlags {
    private List<Mdr11Record> pois;
    private final List<Mdr18Record> poiTypes = new ArrayList<Mdr18Record>();

    public Mdr19(MdrConfig config) {
        this.setConfig(config);
    }

    @Override
    public void preWriteImpl() {
        Collections.sort(this.pois, new Comparator<Mdr11Record>(){

            @Override
            public int compare(Mdr11Record o1, Mdr11Record o2) {
                int t2;
                int t1 = MdrUtils.fullTypeToNaturalType(o1.getType());
                if (t1 == (t2 = MdrUtils.fullTypeToNaturalType(o2.getType()))) {
                    return 0;
                }
                if (t1 < t2) {
                    return -1;
                }
                return 1;
            }
        });
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int n = this.getSizes().getPoiSizeFlagged();
        int flag = this.getSizes().getPoiFlag();
        String lastName = null;
        int lastType = -1;
        int record = 1;
        for (Mdr11Record p : this.pois) {
            int index = p.getRecordNumber();
            String name = p.getName();
            if (!name.equals(lastName)) {
                index |= flag;
                lastName = name;
            }
            this.putN(writer, n, index);
            int type = MdrUtils.fullTypeToNaturalType(p.getType());
            if (type != lastType) {
                Mdr18Record mdr18 = new Mdr18Record();
                mdr18.setType(type);
                mdr18.setRecord(record);
                this.poiTypes.add(mdr18);
                lastType = type;
            }
            ++record;
        }
        Mdr18Record m18 = new Mdr18Record();
        m18.setRecord(record);
        m18.setType(-1);
        this.poiTypes.add(m18);
    }

    @Override
    protected void releaseMemory() {
        this.pois = null;
    }

    @Override
    public int getItemSize() {
        return this.getSizes().getPoiSizeFlagged();
    }

    @Override
    protected int numberOfItems() {
        return this.pois.size();
    }

    @Override
    public int getExtraValue() {
        return this.getSizes().getSize(19) - 1;
    }

    public void setPois(List<Mdr11Record> pois) {
        this.pois = pois;
    }

    public List<Mdr18Record> getPoiTypes() {
        return this.poiTypes;
    }
}

