/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.srt;

import java.util.Arrays;
import uk.me.parabola.imgfmt.app.srt.SortKey;

class SrtSortKey<T>
implements SortKey<T> {
    private final T orig;
    private final byte[] key;
    private int second;

    public SrtSortKey(T orig, byte[] key) {
        this.orig = orig;
        this.key = key;
    }

    public SrtSortKey(T orig, byte[] key, int second) {
        this.orig = orig;
        this.key = key;
        this.second = second;
    }

    @Override
    public int compareTo(SortKey<T> o) {
        SrtSortKey other = (SrtSortKey)o;
        int length = Math.min(this.key.length, other.key.length);
        for (int i = 0; i < length; ++i) {
            int k1 = this.key[i] & 0xFF;
            int k2 = other.key[i] & 0xFF;
            if (k1 < k2) {
                return -1;
            }
            if (k1 <= k2) continue;
            return 1;
        }
        if (this.second == other.second) {
            return 0;
        }
        if (this.second < other.second) {
            return -1;
        }
        return 1;
    }

    @Override
    public T getObject() {
        return this.orig;
    }

    public String toString() {
        return String.format("%s,%d", Arrays.toString(this.key), this.second);
    }
}

