/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.io.IOException;
import java.io.OutputStream;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;

public class Point
extends MapObject {
    private POIRecord poi;

    public Point(Subdivision div) {
        this.setSubdiv(div);
    }

    @Override
    public void write(ImgFileWriter file) {
        boolean hasSubtype = false;
        int type = this.getType();
        byte subtype = 0;
        if (type > 255) {
            if ((type & 0xFF) != 0) {
                hasSubtype = true;
                subtype = (byte)type;
            }
            type >>= 8;
        }
        file.put((byte)type);
        int off = this.getLabel().getOffset();
        if (this.poi != null) {
            off = this.poi.getOffset();
            off |= 0x400000;
        }
        if (hasSubtype) {
            off |= 0x800000;
        }
        file.put3(off);
        file.putChar((char)this.getDeltaLong());
        file.putChar((char)this.getDeltaLat());
        if (hasSubtype) {
            file.put(subtype);
        }
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        assert (this.hasExtendedType());
        int type = this.getType();
        int labelOff = this.getLabel().getOffset();
        byte[] extraBytes = this.getExtTypeExtraBytes();
        if (this.poi != null) {
            labelOff = this.poi.getOffset();
            labelOff |= 0x400000;
        }
        if (labelOff != 0) {
            type |= 0x20;
        }
        if (extraBytes != null) {
            type |= 0x80;
        }
        stream.write(type >> 8);
        stream.write(type);
        int deltaLong = this.getDeltaLong();
        int deltaLat = this.getDeltaLat();
        stream.write(deltaLong);
        stream.write(deltaLong >> 8);
        stream.write(deltaLat);
        stream.write(deltaLat >> 8);
        if (labelOff != 0) {
            stream.write(labelOff);
            stream.write(labelOff >> 8);
            stream.write(labelOff >> 16);
        }
        if (extraBytes != null) {
            stream.write(extraBytes);
        }
    }

    public void setPOIRecord(POIRecord poirecord) {
        this.poi = poirecord;
    }

    public POIRecord getPOIRecord() {
        if (this.poi == null) {
            return new POIRecord();
        }
        return this.poi;
    }

    public Coord getLocation() {
        int shift = this.getSubdiv().getShift();
        Coord co = new Coord(this.getSubdiv().getLatitude() + (this.getDeltaLat() << shift), this.getSubdiv().getLongitude() + (this.getDeltaLong() << shift));
        return co;
    }
}

