/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.ArgumentProcessor;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.Option;
import uk.me.parabola.mkgmap.OptionProcessor;
import uk.me.parabola.mkgmap.Options;
import uk.me.parabola.util.EnhancedProperties;

public class CommandArgsReader {
    private static final Logger log = Logger.getLogger(CommandArgsReader.class);
    private final ArgumentProcessor proc;
    private boolean mapnameWasSet;
    private final ArgList arglist = new ArgList();
    private final EnhancedProperties args = new EnhancedProperties();
    private Set<String> validOptions;

    public CommandArgsReader(ArgumentProcessor proc) {
        this.add(new CommandOption("mapname", "63240001"));
        this.add(new CommandOption("description", "OSM street map"));
        this.add(new CommandOption("overview-mapname", "osmmap"));
        this.add(new CommandOption("overview-mapnumber", "63240000"));
        this.add(new CommandOption("poi-address", ""));
        this.add(new CommandOption("merge-lines", ""));
        this.proc = proc;
    }

    public void readArgs(String[] args) {
        this.proc.startOptions();
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).startsWith("--")) {
                this.addOption(arg.substring(2));
                continue;
            }
            if (arg.equals("-c")) {
                this.readConfigFile(args[i++]);
                continue;
            }
            if (arg.equals("-n")) {
                this.addOption("mapname", args[i++]);
                continue;
            }
            if (arg.equals("-v")) {
                this.addOption("verbose");
                continue;
            }
            if (arg.startsWith("-")) {
                System.err.println("unrecognised option " + arg);
                continue;
            }
            log.debug("adding filename:", arg);
            this.add(new Filename(arg));
        }
        this.proc.processOption("number-of-files", String.valueOf(this.arglist.getFilenameCount()));
        for (ArgType a : this.arglist) {
            a.processArg();
        }
        this.proc.endOptions(new CommandArgs(this.args));
    }

    private void addOption(String option, String value) {
        CommandOption opt = new CommandOption(option, value);
        this.addOption(opt);
    }

    private void addOption(String optval) {
        CommandOption opt = new CommandOption(new Option(optval));
        boolean legacyOptionDetected = false;
        String option = opt.getOption();
        if ("drive-on-left".equals(option)) {
            opt = new CommandOption(new Option("drive-on=left"));
            legacyOptionDetected = true;
        }
        if ("drive-on-right".equals(option)) {
            opt = new CommandOption(new Option("drive-on=right"));
            legacyOptionDetected = true;
        }
        if (legacyOptionDetected) {
            System.err.println("Option " + option + " is deprecated. Will use " + opt.getOption() + "=" + opt.getValue() + " as replacement for " + optval);
        }
        this.addOption(opt);
    }

    private void addOption(CommandOption opt) {
        String option = opt.getOption();
        String value = opt.getValue();
        if (this.validOptions != null && !this.validOptions.contains(option) && !opt.isExperimental()) {
            throw new ExitException(String.format("Invalid option: '%s'", option));
        }
        log.debug("adding option", option, value);
        if (option.equals("mapname")) {
            this.mapnameWasSet = true;
        }
        switch (option) {
            case "input-file": {
                if (value == null) break;
                log.debug("adding filename", value);
                this.add(new Filename(value));
                break;
            }
            case "read-config": {
                this.readConfigFile(value);
                break;
            }
            case "latin1": {
                this.add(new CommandOption("code-page", "1252"));
                break;
            }
            case "unicode": {
                this.add(new CommandOption("code-page", "65001"));
                break;
            }
            default: {
                this.add(opt);
            }
        }
    }

    private void add(CommandOption option) {
        this.arglist.add(option);
    }

    private void add(Filename filename) {
        this.arglist.add(filename);
    }

    private void readConfigFile(String filename) {
        Options opts = new Options(new OptionProcessor(){

            @Override
            public void processOption(Option opt) {
                log.debug("incoming opt", opt.getOption(), opt.getValue());
                CommandArgsReader.this.addOption(new CommandOption(opt));
            }
        });
        try {
            opts.readOptionFile(filename);
        }
        catch (IOException e) {
            throw new ExitException("Failed to read option file", e);
        }
    }

    public void setValidOptions(Set<String> validOptions) {
        this.validOptions = validOptions;
    }

    class ArgList
    implements Iterable<ArgType> {
        private final List<ArgType> alist = new ArrayList<ArgType>();
        private int filenameCount;

        ArgList() {
        }

        protected void add(CommandOption option) {
            this.alist.add(option);
        }

        public void add(Filename name) {
            ++this.filenameCount;
            this.alist.add(name);
        }

        @Override
        public Iterator<ArgType> iterator() {
            return this.alist.iterator();
        }

        public int getFilenameCount() {
            return this.filenameCount;
        }
    }

    class CommandOption
    implements ArgType {
        private final Option option;

        private CommandOption(Option option) {
            this.option = option;
        }

        private CommandOption(String key, String val) {
            this.option = new Option(key, val);
        }

        @Override
        public void processArg() {
            if (this.option.isReset()) {
                CommandArgsReader.this.args.remove(this.option.getOption());
                CommandArgsReader.this.proc.removeOption(this.option.getOption());
            } else {
                CommandArgsReader.this.args.setProperty(this.option.getOption(), this.option.getValue());
                CommandArgsReader.this.proc.processOption(this.option.getOption(), this.option.getValue());
            }
        }

        public String getOption() {
            return this.option.getOption();
        }

        public String getValue() {
            return this.option.getValue();
        }

        public boolean isExperimental() {
            return this.option.isExperimental();
        }
    }

    class Filename
    implements ArgType {
        private final String name;
        private boolean useFilenameAsMapname = true;

        private Filename(String name) {
            this.name = name;
            if (CommandArgsReader.this.mapnameWasSet) {
                this.useFilenameAsMapname = false;
            }
        }

        @Override
        public void processArg() {
            String mapname;
            if (this.useFilenameAsMapname && (mapname = this.extractMapName(this.name)) != null) {
                CommandArgsReader.this.args.setProperty("mapname", mapname);
            }
            CommandArgsReader.this.proc.processFilename(new CommandArgs(CommandArgsReader.this.args), this.name);
            mapname = CommandArgsReader.this.args.getProperty("mapname");
            try {
                Formatter fmt = new Formatter();
                try {
                    int n = Integer.parseInt(mapname);
                    fmt.format("%08d", ++n);
                }
                catch (NumberFormatException e) {
                    fmt.format("%8.8s", mapname);
                }
                CommandArgsReader.this.args.setProperty("mapname", fmt.toString());
                fmt.close();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private String extractMapName(String path) {
            File file = new File(path);
            String fname = file.getName();
            Pattern pat = Pattern.compile("([0-9]{8})");
            Matcher matcher = pat.matcher(fname);
            boolean found = matcher.find();
            if (found) {
                return matcher.group(1);
            }
            return null;
        }
    }

    static interface ArgType {
        public void processArg();
    }
}

