/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.map.MapReader;
import uk.me.parabola.imgfmt.app.mdr.MDRFile;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.srt.SRTFile;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.imgfmt.sys.FileImgChannel;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.srt.SrtTextReader;

public class MdrBuilder
implements Combiner {
    private MDRFile mdrFile;
    private final Deque<Closeable> toClose = new ArrayDeque<Closeable>();
    private File tmpName;
    private String outputName;

    @Override
    public void init(CommandArgs args) {
        ImgChannel mdrChan;
        FileSystem fs;
        String name = args.get("overview-mapname", "osmmap");
        String outputDir = args.getOutputDir();
        this.outputName = Utils.joinPath(outputDir, name + "_mdr.img");
        try {
            FileSystemParam params = new FileSystemParam();
            params.setBlockSize(args.get("block-size", 16384));
            this.tmpName = File.createTempFile("mdr", null, new File(outputDir));
            this.tmpName.deleteOnExit();
            fs = ImgFS.createFs(this.tmpName.getPath(), params);
            this.toClose.push(fs);
            mdrChan = fs.create(name.toUpperCase(Locale.ENGLISH) + ".MDR");
            this.toClose.push(mdrChan);
        }
        catch (IOException e) {
            throw new ExitException("Could not create global index file");
        }
        Sort sort = SrtTextReader.sortForCodepage(args.getCodePage());
        MdrConfig config = new MdrConfig();
        config.setHeaderLen(568);
        config.setWritable(true);
        config.setForDevice(false);
        config.setOutputDir(outputDir);
        config.setSort(sort);
        config.setSplitName(args.get("split-name-index", false));
        this.mdrFile = new MDRFile(mdrChan, config);
        this.toClose.push(this.mdrFile);
        try {
            ImgChannel srtChan = fs.create(name.toUpperCase(Locale.ENGLISH) + ".SRT");
            SRTFile srtFile = new SRTFile(srtChan);
            srtFile.setSort(sort);
            srtFile.write();
            srtFile.close();
        }
        catch (FileExistsException e) {
            throw new ExitException("Could not create SRT file within index file");
        }
    }

    void initForDevice(Sort sort, String outputDir, boolean splitName) {
        MdrConfig config = new MdrConfig();
        config.setHeaderLen(568);
        config.setWritable(true);
        config.setForDevice(true);
        config.setSort(sort);
        config.setSplitName(splitName);
        try {
            this.tmpName = File.createTempFile("mdr", null, new File(outputDir));
            this.tmpName.deleteOnExit();
            FileImgChannel channel = new FileImgChannel(this.tmpName.getPath(), "rw");
            this.mdrFile = new MDRFile(channel, config);
            this.toClose.push(this.mdrFile);
        }
        catch (IOException e) {
            throw new ExitException("Could not create temporary index file");
        }
    }

    @Override
    public void onMapEnd(FileInfo info) {
        if (!info.isImg()) {
            return;
        }
        this.mdrFile.addMap(info.getHexname(), info.getCodePage());
        String filename = info.getFilename();
        MapReader mr = null;
        try {
            mr = new MapReader(filename);
            AreaMaps maps = new AreaMaps();
            maps.countries = this.addCountries(mr);
            maps.regions = this.addRegions(mr, maps);
            List<Mdr5Record> mdrCityList = this.fetchCities(mr, maps);
            maps.cityList = mdrCityList;
            this.addPoints(mr, maps);
            this.addCities(mdrCityList);
            this.addStreets(mr, mdrCityList);
            this.addZips(mr);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ExitException("Could not open " + filename + " when creating mdr file");
            }
            catch (Throwable throwable) {
                Utils.closeFile(mr);
                throw throwable;
            }
        }
        Utils.closeFile(mr);
    }

    private Map<Integer, Mdr14Record> addCountries(MapReader mr) {
        HashMap<Integer, Mdr14Record> countryMap = new HashMap<Integer, Mdr14Record>();
        List<Country> countries = mr.getCountries();
        for (Country c : countries) {
            if (c == null) continue;
            Mdr14Record record = this.mdrFile.addCountry(c);
            countryMap.put(Integer.valueOf(c.getIndex()), record);
        }
        return countryMap;
    }

    private Map<Integer, Mdr13Record> addRegions(MapReader mr, AreaMaps maps) {
        HashMap<Integer, Mdr13Record> regionMap = new HashMap<Integer, Mdr13Record>();
        List<Region> regions = mr.getRegions();
        for (Region region : regions) {
            if (region == null) continue;
            Mdr14Record mdr14 = (Mdr14Record)maps.countries.get(region.getCountry().getIndex());
            Mdr13Record record = this.mdrFile.addRegion(region, mdr14);
            regionMap.put(Integer.valueOf(region.getIndex()), record);
        }
        return regionMap;
    }

    private List<Mdr5Record> fetchCities(MapReader mr, AreaMaps maps) {
        Map cityMap = maps.cities;
        ArrayList<Mdr5Record> cityList = new ArrayList<Mdr5Record>();
        List<City> cities = mr.getCities();
        for (City c : cities) {
            Mdr14Record mdrCountry;
            int regionCountryNumber = c.getRegionCountryNumber();
            Mdr13Record mdrRegion = null;
            if ((regionCountryNumber & 0x4000) == 0) {
                mdrRegion = (Mdr13Record)maps.regions.get(regionCountryNumber);
                mdrCountry = mdrRegion.getMdr14();
            } else {
                mdrCountry = (Mdr14Record)maps.countries.get(regionCountryNumber & 0x3FFF);
            }
            Mdr5Record mdrCity = new Mdr5Record();
            mdrCity.setCityIndex(c.getIndex());
            mdrCity.setRegionIndex(c.getRegionCountryNumber());
            mdrCity.setMdrRegion(mdrRegion);
            mdrCity.setMdrCountry(mdrCountry);
            mdrCity.setLblOffset(c.getLblOffset());
            mdrCity.setName(c.getName());
            int key = (c.getSubdivNumber() << 8) + (c.getPointIndex() & 0xFF);
            assert (key < 0xFFFFFF);
            cityMap.put(key, mdrCity);
            cityList.add(mdrCity);
        }
        return cityList;
    }

    private void addCities(List<Mdr5Record> cityList) {
        for (Mdr5Record c : cityList) {
            this.mdrFile.addCity(c);
        }
    }

    private void addZips(MapReader mr) {
        List<Zip> zips = mr.getZips();
        for (Zip zip : zips) {
            this.mdrFile.addZip(zip);
        }
    }

    private void addPoints(MapReader mr, AreaMaps maps) {
        List<Point> list = mr.pointsForLevel(0, false);
        for (Point p : list) {
            boolean isCity;
            Label label = p.getLabel();
            if (p.getNumber() > 256) continue;
            Mdr5Record mdrCity = null;
            if (p.getType() >= 1 && p.getType() <= 17) {
                mdrCity = (Mdr5Record)maps.cities.get((p.getSubdiv().getNumber() << 8) + p.getNumber());
                if (mdrCity != null) {
                    mdrCity.setLblOffset(label.getOffset());
                    mdrCity.setName(label.getText());
                }
                isCity = true;
            } else {
                POIRecord poi = p.getPOIRecord();
                City c = poi.getCity();
                if (c != null) {
                    mdrCity = this.getMdr5FromCity(maps, c);
                }
                isCity = false;
            }
            if (label == null || label.getText().trim().isEmpty()) continue;
            this.mdrFile.addPoint(p, mdrCity, isCity);
        }
    }

    private void addStreets(MapReader mr, List<Mdr5Record> cityList) {
        List<RoadDef> roads = mr.getRoads();
        for (RoadDef road : roads) {
            String name = road.getName();
            if (name == null || name.isEmpty()) continue;
            Mdr5Record mdrCity = null;
            List<City> cities = road.getCities();
            if (cities.isEmpty()) {
                this.mdrFile.addStreet(road, mdrCity);
                continue;
            }
            for (City city : cities) {
                mdrCity = cityList.get(city.getIndex() - 1);
                if (mdrCity.getMapIndex() == 0) {
                    mdrCity = null;
                }
                this.mdrFile.addStreet(road, mdrCity);
            }
        }
    }

    private Mdr5Record getMdr5FromCity(AreaMaps cityMap, City c) {
        if (c == null) {
            return null;
        }
        if (c.getPointIndex() > 0) {
            return (Mdr5Record)cityMap.cities.get((c.getSubdivNumber() << 8) + (c.getPointIndex() & 0xFF));
        }
        return (Mdr5Record)cityMap.cityList.get(c.getIndex() - 1);
    }

    @Override
    public void onFinish() {
        this.mdrFile.write();
        for (Closeable file : this.toClose) {
            Utils.closeFile(file);
        }
        File outputName = new File(this.outputName);
        outputName.delete();
        boolean ok = this.tmpName.renameTo(outputName);
        if (!ok) {
            throw new MapFailedException("Could not create mdr.img file");
        }
    }

    void onFinishForDevice() {
        this.mdrFile.write();
        for (Closeable file : this.toClose) {
            Utils.closeFile(file);
        }
    }

    public int getSize() {
        return (int)this.tmpName.length();
    }

    public String getFileName() {
        return this.tmpName.getPath();
    }

    class AreaMaps {
        private final Map<Integer, Mdr5Record> cities = new HashMap<Integer, Mdr5Record>();
        private Map<Integer, Mdr13Record> regions;
        private Map<Integer, Mdr14Record> countries;
        private List<Mdr5Record> cityList;

        AreaMaps() {
        }
    }
}

