/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.util.MultiHashMap;

public class LineMergeFilter {
    private static final Logger log = Logger.getLogger(LineMergeFilter.class);
    private List<MapLine> linesMerged;
    private final MultiHashMap<Coord, MapLine> startPoints = new MultiHashMap();
    private final MultiHashMap<Coord, MapLine> endPoints = new MultiHashMap();

    private void addLine(MapLine line) {
        this.linesMerged.add(line);
        List<Coord> points = line.getPoints();
        this.startPoints.add(points.get(0), line);
        this.endPoints.add(points.get(points.size() - 1), line);
    }

    private void mergeLines(MapLine line1, MapLine line2) {
        List<Coord> points1 = line1.getPoints();
        List<Coord> points2 = line2.getPoints();
        this.startPoints.removeMapping(points1.get(0), line1);
        this.endPoints.removeMapping(points1.get(points1.size() - 1), line1);
        this.startPoints.removeMapping(points2.get(0), line2);
        this.startPoints.add(points1.get(0), line2);
        line2.insertPointsAtStart(points1);
        this.linesMerged.remove(line1);
    }

    private void addPointsAtStart(MapLine line, List<Coord> additionalPoints) {
        log.info((Object)("merged lines before " + line.getName()));
        List<Coord> points = line.getPoints();
        this.startPoints.removeMapping(points.get(0), line);
        line.insertPointsAtStart(additionalPoints);
        this.startPoints.add(points.get(0), line);
    }

    private void addPointsAtEnd(MapLine line, List<Coord> additionalPoints) {
        log.info((Object)("merged lines after " + line.getName()));
        List<Coord> points = line.getPoints();
        this.endPoints.removeMapping(points.get(points.size() - 1), line);
        line.insertPointsAtEnd(additionalPoints);
        this.endPoints.add(points.get(points.size() - 1), line);
    }

    public List<MapLine> merge(List<MapLine> lines, int res) {
        this.linesMerged = new ArrayList<MapLine>(lines.size());
        for (MapLine line : lines) {
            MapLine line2;
            if (line.getMinResolution() > res || line.getMaxResolution() < res) continue;
            if (line.isRoad()) {
                this.linesMerged.add(line);
                continue;
            }
            boolean isMerged = false;
            List<Coord> points = line.getPoints();
            Coord start = points.get(0);
            Coord end = points.get(points.size() - 1);
            Iterator i$ = this.startPoints.get(end).iterator();
            while (i$.hasNext()) {
                line2 = (MapLine)i$.next();
                if (!line.isSimilar(line2)) continue;
                this.addPointsAtStart(line2, points);
                Iterator i$2 = this.endPoints.get(start).iterator();
                while (i$2.hasNext()) {
                    MapLine line1 = (MapLine)i$2.next();
                    if (!line2.isSimilar(line1) || line2.equals(line1)) continue;
                    this.mergeLines(line1, line2);
                    break;
                }
                isMerged = true;
                break;
            }
            if (isMerged) continue;
            i$ = this.endPoints.get(start).iterator();
            while (i$.hasNext()) {
                line2 = (MapLine)i$.next();
                if (!line.isSimilar(line2)) continue;
                this.addPointsAtEnd(line2, points);
                isMerged = true;
                break;
            }
            if (isMerged) continue;
            MapLine l = line.copy();
            ArrayList<Coord> p = new ArrayList<Coord>(line.getPoints());
            l.setPoints(p);
            this.addLine(l);
        }
        return this.linesMerged;
    }
}

