/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.main;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.ArgumentProcessor;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.CommandArgsReader;
import uk.me.parabola.mkgmap.Version;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.combiners.GmapsuppBuilder;
import uk.me.parabola.mkgmap.combiners.MdrBuilder;
import uk.me.parabola.mkgmap.combiners.MdxBuilder;
import uk.me.parabola.mkgmap.combiners.NsisBuilder;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.mkgmap.combiners.TdbBuilder;
import uk.me.parabola.mkgmap.main.MapMaker;
import uk.me.parabola.mkgmap.main.MapProcessor;
import uk.me.parabola.mkgmap.main.TypCompiler;
import uk.me.parabola.mkgmap.main.TypSaver;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;
import uk.me.parabola.mkgmap.osmstyle.StyleImpl;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.StyleInfo;
import uk.me.parabola.mkgmap.reader.overview.OverviewMapDataSource;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.srt.SrtTextReader;
import uk.me.parabola.util.EnhancedProperties;

public class Main
implements ArgumentProcessor {
    private static final Logger log = Logger.getLogger(Main.class);
    private final List<Combiner> combiners = new ArrayList<Combiner>();
    private final Map<String, MapProcessor> processMap = new HashMap<String, MapProcessor>();
    private String styleFile = "classpath:styles";
    private String styleOption;
    private boolean verbose;
    private final List<FilenameTask> futures = new LinkedList<FilenameTask>();
    private ExecutorService threadPool;
    private int maxJobs = 1;
    private boolean createTdbFiles = false;
    private boolean tdbBuilderAdded = false;
    private String searchedStyleName;
    private volatile int programRC = 0;

    public static void mainNoSystemExit(String[] args) {
        Main.mainStart(args);
    }

    public static void main(String[] args) {
        int rc = Main.mainStart(args);
        if (rc != 0) {
            System.exit(1);
        }
    }

    private static int mainStart(String[] args) {
        long start = System.currentTimeMillis();
        System.out.println("Time started: " + new Date());
        if (args.length < 1) {
            Main.printUsage();
            Main.printHelp(System.err, Main.getLang(), "options");
            return 0;
        }
        Main mm = new Main();
        int numExitExceptions = 0;
        try {
            CommandArgsReader commandArgs = new CommandArgsReader(mm);
            commandArgs.setValidOptions(Main.getValidOptions(System.err));
            commandArgs.readArgs(args);
        }
        catch (MapFailedException e) {
            e.printStackTrace();
            ++numExitExceptions;
        }
        catch (ExitException e) {
            ++numExitExceptions;
            System.err.println(e.getMessage());
        }
        System.out.println("Number of ExitExceptions: " + numExitExceptions);
        System.out.println("Time finished: " + new Date());
        System.out.println("Total time taken: " + (System.currentTimeMillis() - start) + "ms");
        if (numExitExceptions > 0 || mm.getProgramRC() != 0) {
            return 1;
        }
        return 0;
    }

    private static void printUsage() {
        System.err.println("Usage: mkgmap [options...] <file.osm>");
    }

    private void setProgramRC(int rc) {
        this.programRC = rc;
    }

    private int getProgramRC() {
        return this.programRC;
    }

    private static void printHelp(PrintStream err, String lang, String file) {
        String path = "/help/" + lang + '/' + file;
        InputStream stream = Main.class.getResourceAsStream(path);
        if (stream == null) {
            err.println("Could not find the help topic: " + file + ", sorry");
            return;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(stream));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                err.println(line);
            }
        }
        catch (IOException e) {
            err.println("Could not read the help topic: " + file + ", sorry");
        }
    }

    private static Set<String> getValidOptions(PrintStream err) {
        String path = "/help/en/options";
        InputStream stream = Main.class.getResourceAsStream(path);
        if (stream == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(stream, "utf-8"));
            Pattern p = Pattern.compile("^--?([a-zA-Z0-9-]*).*$");
            while ((line = r.readLine()) != null) {
                Matcher matcher = p.matcher(line);
                if (!matcher.matches()) continue;
                String opt = matcher.group(1);
                result.add(opt);
            }
        }
        catch (IOException e) {
            err.println("Could not read valid optoins");
            return null;
        }
        return result;
    }

    @Override
    public void startOptions() {
        NameSaver saver = new NameSaver();
        this.processMap.put("img", saver);
        this.processMap.put("mdx", saver);
        this.processMap.put("typ", new TypSaver());
        this.processMap.put("rgn", saver);
        this.processMap.put("tre", saver);
        this.processMap.put("lbl", saver);
        this.processMap.put("net", saver);
        this.processMap.put("nod", saver);
        this.processMap.put("txt", new TypCompiler());
    }

    @Override
    public void processFilename(final CommandArgs args, final String filename) {
        String ext = Main.extractExtension(filename);
        log.debug("file", filename, ", extension is", ext);
        if (OverviewBuilder.isOverviewImg(filename)) {
            return;
        }
        final MapProcessor mp = this.mapMaker(ext);
        args.setSort(this.getSort(args));
        log.info((Object)("Submitting job " + filename));
        FilenameTask task = new FilenameTask(new Callable<String>(){

            @Override
            public String call() {
                log.threadTag(filename);
                if (filename.startsWith("test-map:") || new File(filename).exists()) {
                    String output = mp.makeMap(args, filename);
                    log.debug("adding output name", output);
                    log.threadTag(null);
                    return output;
                }
                log.error((Object)("file " + filename + " doesn't exist"));
                return null;
            }
        });
        task.setArgs(args);
        this.futures.add(task);
    }

    private MapProcessor mapMaker(String ext) {
        MapProcessor mp = this.processMap.get(ext);
        if (mp == null) {
            mp = new MapMaker(this.createTdbFiles);
        }
        return mp;
    }

    @Override
    public void processOption(String opt, String val) {
        log.debug("option:", opt, val);
        if (opt.equals("number-of-files")) {
            int n = Integer.valueOf(val);
            if (n > 0) {
                this.createTdbFiles = true;
            }
        } else if (opt.equals("help")) {
            Main.printHelp(System.out, Main.getLang(), !val.isEmpty() ? val : "help");
        } else if (opt.equals("style-file") || opt.equals("map-features")) {
            this.styleFile = val;
        } else if (opt.equals("style")) {
            this.styleOption = val;
        } else if (opt.equals("verbose")) {
            this.verbose = true;
        } else if (opt.equals("list-styles")) {
            this.listStyles();
        } else if (opt.equals("check-styles")) {
            this.checkStyles();
        } else if (opt.equals("max-jobs")) {
            this.maxJobs = val.isEmpty() ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(val);
            if (this.maxJobs < 1) {
                log.warn((Object)"max-jobs has to be at least 1");
                this.maxJobs = 1;
            }
        } else if (opt.equals("version")) {
            System.err.println(Version.VERSION);
            System.exit(0);
        }
    }

    @Override
    public void removeOption(String opt) {
        if ("tdbfile".equals(opt)) {
            this.createTdbFiles = false;
        }
    }

    private void addTdbBuilder() {
        if (!this.tdbBuilderAdded) {
            OverviewMapDataSource overviewSource = new OverviewMapDataSource();
            OverviewBuilder overviewBuilder = new OverviewBuilder(overviewSource);
            this.addCombiner(overviewBuilder);
            TdbBuilder tdbBuilder = new TdbBuilder(overviewBuilder);
            this.addCombiner(tdbBuilder);
            this.tdbBuilderAdded = true;
        }
    }

    private void listStyles() {
        Object[] names;
        try {
            StyleFileLoader loader = StyleFileLoader.createStyleLoader(this.styleFile, null);
            names = loader.list();
            loader.close();
        }
        catch (FileNotFoundException e) {
            log.debug("didn't find style file", e);
            throw new ExitException("Could not list style file " + this.styleFile);
        }
        Arrays.sort(names);
        System.out.println("The following styles are available:");
        for (Object name : names) {
            Style style = this.readOneStyle((String)name, false);
            if (style == null) continue;
            StyleInfo info = style.getInfo();
            System.out.format("%-15s %6s: %s\n", this.searchedStyleName, info.getVersion(), info.getSummary());
            if (!this.verbose) continue;
            for (String s : info.getLongDescription().split("\n")) {
                System.out.printf("\t%s\n", s.trim());
            }
        }
    }

    private void checkStyles() {
        Object[] names;
        int checked = 0;
        try {
            StyleFileLoader loader = StyleFileLoader.createStyleLoader(this.styleFile, null);
            names = loader.list();
            loader.close();
        }
        catch (FileNotFoundException e) {
            log.debug("didn't find style file", e);
            throw new ExitException("Could not check style file " + this.styleFile);
        }
        Arrays.sort(names);
        if (this.styleOption == null) {
            if (names.length > 1) {
                System.out.println("The following styles are available:");
            } else {
                System.out.println("Found one style in " + this.styleFile);
            }
        }
        for (Object name : names) {
            Style style;
            if (this.styleOption != null && !((String)name).equals(this.styleOption)) continue;
            if (names.length > 1) {
                System.out.println("checking style: " + (String)name);
            }
            ++checked;
            boolean performChecks = true;
            if ("classpath:styles".equals(this.styleFile) && !"default".equals(name)) {
                performChecks = false;
            }
            if ((style = this.readOneStyle((String)name, performChecks)) != null) continue;
            System.out.println("could not open style " + (String)name);
        }
        if (checked == 0) {
            System.out.println("could not open style " + this.styleOption + " in " + this.styleFile);
        }
        System.out.println("finished check-styles");
    }

    private Style readOneStyle(String name, boolean performChecks) {
        StyleImpl style = null;
        this.searchedStyleName = name;
        try {
            style = new StyleImpl(this.styleFile, name, new EnhancedProperties(), performChecks);
        }
        catch (SyntaxException e) {
            System.err.println("Error in style: " + e.getMessage());
        }
        catch (FileNotFoundException e) {
            log.debug("could not find style", name);
            try {
                this.searchedStyleName = new File(this.styleFile).getName();
                style = new StyleImpl(this.styleFile, null, new EnhancedProperties(), performChecks);
            }
            catch (SyntaxException e1) {
                System.err.println("Error in style: " + e1.getMessage());
            }
            catch (FileNotFoundException e1) {
                log.debug("could not find style", this.styleFile);
            }
        }
        return style;
    }

    private static String getLang() {
        return "en";
    }

    private void addCombiner(Combiner combiner) {
        this.combiners.add(combiner);
    }

    @Override
    public void endOptions(CommandArgs args) {
        this.fileOptions(args);
        log.info((Object)"Start tile processors");
        if (this.threadPool == null) {
            log.info((Object)("Creating thread pool with " + this.maxJobs + " threads"));
            this.threadPool = Executors.newFixedThreadPool(this.maxJobs);
        }
        for (FilenameTask task : this.futures) {
            this.threadPool.execute(task);
        }
        ArrayList<FilenameTask> filenames = new ArrayList<FilenameTask>();
        int numMapFailedExceptions = 0;
        if (this.threadPool != null) {
            this.threadPool.shutdown();
            while (!this.futures.isEmpty()) {
                try {
                    try {
                        if (this.futures.get(0).isDone()) {
                            FilenameTask future = this.futures.remove(0);
                            future.setFilename((String)future.get());
                            filenames.add(future);
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Exception) {
                            throw (Exception)cause;
                        }
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        throw e;
                    }
                }
                catch (ExitException ee) {
                    throw ee;
                }
                catch (MapFailedException mfe) {
                    ++numMapFailedExceptions;
                    this.setProgramRC(-1);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (args.getProperties().getProperty("keep-going", false)) continue;
                    throw new ExitException("Exiting - if you want to carry on regardless, use the --keep-going option");
                }
            }
        }
        System.out.println("Number of MapFailedExceptions: " + numMapFailedExceptions);
        if (this.combiners.isEmpty()) {
            return;
        }
        boolean hasFiles = false;
        for (FilenameTask file : filenames) {
            if (file == null || file.isCancelled() || file.getFilename() == null) {
                if (args.getProperties().getProperty("keep-going", false)) continue;
                throw new ExitException("Exiting - if you want to carry on regardless, use the --keep-going option");
            }
            hasFiles = true;
        }
        if (!hasFiles) {
            log.warn((Object)"nothing to do for combiners.");
            return;
        }
        log.info((Object)"Combining maps");
        args.setSort(this.getSort(args));
        for (Combiner c : this.combiners) {
            c.init(args);
        }
        HashSet<String> foundOvmFiles = new HashSet<String>();
        if (this.tdbBuilderAdded) {
            for (FilenameTask file : filenames) {
                if (file == null || file.isCancelled()) continue;
                try {
                    String fileName = file.getFilename();
                    if (!fileName.endsWith(".img")) continue;
                    fileName = OverviewBuilder.getOverviewImgName(fileName);
                    log.info((Object)("  " + fileName));
                    FileInfo fileInfo = FileInfo.getFileInfo(fileName);
                    fileInfo.setArgs(file.getArgs());
                    foundOvmFiles.add(file.getFilename());
                    for (Combiner c : this.combiners) {
                        if (!(c instanceof OverviewBuilder)) continue;
                        c.onMapEnd(fileInfo);
                    }
                }
                catch (FileNotFoundException e) {
                }
            }
        }
        for (FilenameTask file : filenames) {
            if (file == null || file.isCancelled()) continue;
            try {
                log.info((Object)("  " + file));
                FileInfo fileInfo = FileInfo.getFileInfo(file.getFilename());
                fileInfo.setArgs(file.getArgs());
                for (Combiner c : this.combiners) {
                    if (c instanceof OverviewBuilder && foundOvmFiles.contains(file.getFilename())) continue;
                    c.onMapEnd(fileInfo);
                }
            }
            catch (FileNotFoundException e) {
                throw new MapFailedException("could not open file " + e.getMessage());
            }
        }
        for (Combiner c : this.combiners) {
            c.onFinish();
        }
        if (this.tdbBuilderAdded && args.getProperties().getProperty("remove-ovm-work-files", false)) {
            for (String fName : foundOvmFiles) {
                String ovmFile = OverviewBuilder.getOverviewImgName(fName);
                log.info((Object)("removing " + ovmFile));
                new File(ovmFile).delete();
            }
        }
    }

    private void fileOptions(CommandArgs args) {
        boolean indexOpt = args.exists("index");
        boolean gmapOpt = args.exists("gmapsupp");
        boolean tdbOpt = args.exists("tdbfile");
        if (tdbOpt || this.createTdbFiles) {
            this.addTdbBuilder();
        }
        if (args.exists("nsis")) {
            this.addCombiner(new NsisBuilder());
        }
        if (gmapOpt) {
            GmapsuppBuilder gmapBuilder = new GmapsuppBuilder();
            gmapBuilder.setCreateIndex(indexOpt);
            this.addCombiner(gmapBuilder);
        }
        if (indexOpt && (tdbOpt || !gmapOpt)) {
            this.addCombiner(new MdrBuilder());
            this.addCombiner(new MdxBuilder());
        }
    }

    private static String extractExtension(String filename) {
        String[] parts = filename.toLowerCase(Locale.ENGLISH).split("\\.");
        List<String> ignore = Arrays.asList("gz", "bz2", "bz");
        for (int i = parts.length - 1; i > 0; --i) {
            String ext = parts[i];
            if (ignore.contains(ext)) continue;
            return ext;
        }
        return "";
    }

    public Sort getSort(CommandArgs args) {
        return SrtTextReader.sortForCodepage(args.getCodePage());
    }

    private static class FilenameTask
    extends FutureTask<String> {
        private CommandArgs args;
        private String filename;

        private FilenameTask(Callable<String> callable) {
            super(callable);
        }

        public void setArgs(CommandArgs args) {
            this.args = args;
        }

        public CommandArgs getArgs() {
            return this.args;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFilename() {
            return this.filename;
        }

        @Override
        public String toString() {
            return this.filename;
        }
    }

    private static class NameSaver
    implements MapProcessor {
        private NameSaver() {
        }

        @Override
        public String makeMap(CommandArgs args, String filename) {
            return filename;
        }
    }
}

