/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.StyleFileLoader;

public class CombinedStyleFileLoader
extends StyleFileLoader {
    private static final Logger log = Logger.getLogger(CombinedStyleFileLoader.class);
    private final Map<String, String> files = new HashMap<String, String>();
    private final String styleName;
    private static final Pattern STYLE_SUFFIX = Pattern.compile("\\.style$");
    private static final Pattern FILENAME_START_MARK = Pattern.compile("<<<");
    private static final Pattern FILENAME_END_MARK = Pattern.compile(">>>.*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedStyleFileLoader(String filename) throws FileNotFoundException {
        this.styleName = STYLE_SUFFIX.matcher(filename).replaceFirst("");
        FileReader in = new FileReader(filename);
        try {
            this.loadFiles(in);
        }
        finally {
            Utils.closeFile(in);
        }
    }

    private void loadFiles(Reader in) {
        BufferedReader r = new BufferedReader(in);
        StringBuffer currentFile = new StringBuffer();
        try {
            String line;
            String currentName = null;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("<<<")) {
                    if (currentName != null) {
                        this.files.put(currentName, currentFile.toString());
                    }
                    line = FILENAME_START_MARK.matcher(line).replaceFirst("");
                    line = FILENAME_END_MARK.matcher(line).replaceFirst("");
                    log.debug("reading file", line);
                    currentName = line;
                    currentFile = new StringBuffer();
                    continue;
                }
                currentFile.append(line);
                currentFile.append('\n');
            }
            if (currentName == null) {
                log.error((Object)"failed to read style file");
            } else {
                this.files.put(currentName, currentFile.toString());
            }
        }
        catch (IOException e) {
            log.error((Object)"failed to read style file");
        }
    }

    @Override
    public Reader open(String filename) throws FileNotFoundException {
        log.info("opening", filename);
        String contents = this.files.get(filename);
        if (contents == null) {
            throw new FileNotFoundException(filename);
        }
        log.debug("file", filename, "found");
        return new StringReader(contents);
    }

    @Override
    public void close() {
        this.files.clear();
    }

    @Override
    public String[] list() {
        String basename = this.styleName.replaceFirst(".*[/\\\\]", "");
        basename = basename.replaceFirst("\\.[^.]+$", "");
        return new String[]{basename};
    }

    public static void main(String[] args) {
        String name = args[0];
        File file = new File(name);
        PrintStream out = System.out;
        try {
            if (file.isDirectory()) {
                CombinedStyleFileLoader.convertToFile(file, out);
            } else {
                int ind = name.lastIndexOf(46);
                String dirname = ind > 0 ? name.substring(0, ind) : name + ".d";
                CombinedStyleFileLoader.convertToDirectory(name, dirname);
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open file " + e);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Could not read file " + e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convertToDirectory(String name, String dirname) throws IOException {
        CombinedStyleFileLoader loader = new CombinedStyleFileLoader(name);
        File dir = new File(dirname);
        dir.mkdir();
        for (String s : loader.files.keySet()) {
            File ent = new File(dir, s);
            ent.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(ent);
            BufferedReader r = null;
            try {
                String line;
                r = new BufferedReader(loader.open(s));
                while ((line = r.readLine()) != null) {
                    writer.write(line);
                    writer.write(10);
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
                writer.close();
            }
        }
        loader.close();
    }

    private static void convertToFile(File file, PrintStream out) throws IOException {
        File[] list = file.listFiles(new NoHiddenFilter());
        CombinedStyleFileLoader.convertToFile(out, list, null);
    }

    private static void convertToFile(PrintStream out, File[] list, String prefix) throws IOException {
        for (File entry : list) {
            if (entry.isFile()) {
                String line;
                out.print("<<<");
                if (prefix != null) {
                    out.print(prefix);
                    out.print('/');
                }
                out.print(entry.getName());
                out.println(">>>");
                BufferedReader r = new BufferedReader(new FileReader(entry));
                while ((line = r.readLine()) != null) {
                    out.println(line);
                }
                r.close();
                continue;
            }
            CombinedStyleFileLoader.convertToFile(out, entry.listFiles(new NoHiddenFilter()), entry.getName());
        }
    }

    private static class NoHiddenFilter
    implements FilenameFilter {
        private NoHiddenFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return !name.isEmpty() && name.charAt(0) != '.';
        }
    }
}

