/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.actions.ConvertFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.CountryISOFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.DefaultFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.HeightFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.HighwaySymbolFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.NotContainedFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.NotEqualFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.PartFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.PrependFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.SubstitutionFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.SubstringFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.TransliterateFilter;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueItem;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.scan.SyntaxException;

public class ValueBuilder {
    private static final Pattern[] FILTER_ARG_PATTERNS = new Pattern[]{Pattern.compile("[ \t]*([^: \\t|]+:\"[^\"]+\")[ \t]*"), Pattern.compile("[ \t]*([^: \\t|]+:'[^']+')[ \t]*"), Pattern.compile("[ \t]*([^: \\t|]+:[^|]*)"), Pattern.compile("[ \t]*([^: \\t|]+)")};
    private static final Pattern NAME_ARG_SPLIT = Pattern.compile("([^:]+)(?::[\"']?(.*?)[\"']?)?", 32);
    private final List<ValueItem> items = new ArrayList<ValueItem>();
    private final boolean completeCheck;

    public ValueBuilder(String pattern) {
        this(pattern, true);
    }

    public ValueBuilder(String pattern, boolean completeCheck) {
        this.completeCheck = completeCheck;
        this.compile(pattern);
    }

    public String build(Element el, Element lel) {
        if (this.completeCheck) {
            for (ValueItem item : this.items) {
                if (item.getValue(el, lel) != null) continue;
                return null;
            }
        }
        if (this.items.size() == 1) {
            return this.items.get(0).getValue(el, lel);
        }
        StringBuilder sb = new StringBuilder();
        for (ValueItem item : this.items) {
            sb.append(item.getValue(el, lel));
        }
        return sb.toString();
    }

    private void compile(String in) {
        if (!in.contains("$")) {
            this.items.add(new ValueItem(in));
            return;
        }
        int state = 0;
        StringBuilder text = new StringBuilder();
        StringBuilder tagname = null;
        block8: for (int n : in.toCharArray()) {
            switch (state) {
                case 0: {
                    if (n == 36) {
                        state = 36;
                        continue block8;
                    }
                    text.append((char)n);
                    continue block8;
                }
                case 36: {
                    switch (n) {
                        case 40: 
                        case 123: {
                            if (text.length() > 0) {
                                this.items.add(new ValueItem(text.toString()));
                                text.setLength(0);
                            }
                            tagname = new StringBuilder();
                            state = n == 123 ? 125 : 41;
                            continue block8;
                        }
                    }
                    state = 0;
                    text.append('$');
                    text.append((char)n);
                    continue block8;
                }
                case 41: 
                case 125: {
                    if (n == state) {
                        assert (tagname != null);
                        this.addTagValue(tagname.toString(), n == 41);
                        state = 0;
                        tagname = null;
                        continue block8;
                    }
                    tagname.append((char)n);
                    continue block8;
                }
                default: {
                    assert (false);
                    continue block8;
                }
            }
        }
        if (text.length() > 0) {
            this.items.add(new ValueItem(text.toString()));
        }
    }

    private void addTagValue(String tagname, boolean is_local) {
        ValueItem item = new ValueItem();
        if (tagname.contains("|")) {
            String[] parts = tagname.split("[ \t]*\\|", 2);
            assert (parts.length > 1);
            item.setTagname(parts[0], is_local);
            String s = parts[1];
            int start = 0;
            int end = s.length();
            while (start < end) {
                Matcher matcher = null;
                for (Pattern p : FILTER_ARG_PATTERNS) {
                    matcher = p.matcher(s);
                    matcher.region(start, end);
                    if (matcher.lookingAt()) break;
                }
                if (matcher != null && matcher.lookingAt()) {
                    start = matcher.end() + 1;
                    this.addFilter(item, matcher.group(1));
                    continue;
                }
                assert (false);
                start = end;
            }
        } else {
            item.setTagname(tagname, is_local);
        }
        this.items.add(item);
    }

    private void addFilter(ValueItem item, String expr) {
        Matcher matcher = NAME_ARG_SPLIT.matcher(expr);
        matcher.matches();
        String cmd = matcher.group(1);
        String arg = matcher.group(2);
        switch (cmd) {
            case "def": {
                item.addFilter(new DefaultFilter(arg));
                break;
            }
            case "conv": {
                item.addFilter(new ConvertFilter(arg));
                break;
            }
            case "subst": {
                item.addFilter(new SubstitutionFilter(arg));
                break;
            }
            case "prefix": {
                item.addFilter(new PrependFilter(arg));
                break;
            }
            case "highway-symbol": {
                item.addFilter(new HighwaySymbolFilter(arg));
                break;
            }
            case "height": {
                item.addFilter(new HeightFilter(arg));
                break;
            }
            case "not-equal": {
                item.addFilter(new NotEqualFilter(arg));
                break;
            }
            case "substring": {
                item.addFilter(new SubstringFilter(arg));
                break;
            }
            case "part": {
                item.addFilter(new PartFilter(arg));
                break;
            }
            case "ascii": {
                item.addFilter(new TransliterateFilter("ascii"));
                break;
            }
            case "latin1": {
                item.addFilter(new TransliterateFilter("latin1"));
                break;
            }
            case "country-ISO": {
                item.addFilter(new CountryISOFilter());
                break;
            }
            case "not-contained": {
                item.addFilter(new NotContainedFilter(arg));
                break;
            }
            default: {
                throw new SyntaxException(String.format("Unknown filter '%s'", cmd));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("'");
        for (ValueItem v : this.items) {
            sb.append(v);
        }
        sb.append("'");
        return sb.toString();
    }

    public Set<String> getUsedTags() {
        HashSet<String> set = new HashSet<String>();
        for (ValueItem v : this.items) {
            String tagname = v.getTagname();
            if (tagname == null) continue;
            set.add(tagname);
        }
        return set;
    }
}

