/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.housenumber;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.CityInfo;
import uk.me.parabola.mkgmap.general.LineAdder;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.ZipCodeInfo;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberElem;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberIvl;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberMatch;
import uk.me.parabola.mkgmap.osmstyle.housenumber.HousenumberRoad;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.HousenumberHooks;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.POIGeneratorHook;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;
import uk.me.parabola.util.KdTree;
import uk.me.parabola.util.Locatable;
import uk.me.parabola.util.MultiHashMap;

public class HousenumberGenerator {
    private static final Logger log = Logger.getLogger(HousenumberGenerator.class);
    public static final double MAX_DISTANCE_TO_ROAD = 150.0;
    public static final double MAX_DISTANCE_SAME_NUM = 100.0;
    private boolean numbersEnabled;
    private int nameSearchDepth = 3;
    private MultiHashMap<String, HousenumberIvl> interpolationWays;
    private List<MapRoad> allRoads;
    private Map<Long, Integer> interpolationNodes;
    private List<HousenumberElem> houseElems;
    private HashMap<CityInfo, CityInfo> cityInfos = new HashMap();
    private HashMap<ZipCodeInfo, ZipCodeInfo> zipInfos = new HashMap();
    private static final short housenumberTagKey1 = TagDict.getInstance().xlate("mkgmap:housenumber");
    private static final short housenumberTagKey2 = TagDict.getInstance().xlate("addr:housenumber");
    private static final short streetTagKey = TagDict.getInstance().xlate("mkgmap:street");
    private static final short addrStreetTagKey = TagDict.getInstance().xlate("addr:street");
    private static final short addrInterpolationTagKey = TagDict.getInstance().xlate("addr:interpolation");
    private static final short addrPlaceTagKey = TagDict.getInstance().xlate("addr:place");
    private static final short cityTagKey = TagDict.getInstance().xlate("mkgmap:city");
    private static final short regionTagKey = TagDict.getInstance().xlate("mkgmap:region");
    private static final short countryTagKey = TagDict.getInstance().xlate("mkgmap:country");
    private static final short postalCodeTagKey = TagDict.getInstance().xlate("mkgmap:postal_code");
    private static final short numbersTagKey = TagDict.getInstance().xlate("mkgmap:numbers");
    private MapRoad firstRoadSameOSMWay = null;

    public HousenumberGenerator(EnhancedProperties props) {
        this.interpolationWays = new MultiHashMap();
        this.allRoads = new ArrayList<MapRoad>();
        this.interpolationNodes = new HashMap<Long, Integer>();
        this.houseElems = new ArrayList<HousenumberElem>();
        this.numbersEnabled = props.containsKey("housenumbers");
        int n = props.getProperty("name-service-roads", 3);
        if (n != this.nameSearchDepth) {
            this.nameSearchDepth = Math.min(25, Math.max(0, n));
            if (this.nameSearchDepth != n) {
                System.err.println("name-service-roads=" + n + " was changed to name-service-roads=" + this.nameSearchDepth);
            }
        }
    }

    private static String getStreetname(Element e) {
        String streetname = e.getTag(streetTagKey);
        if (streetname == null) {
            streetname = e.getTag(addrStreetTagKey);
        }
        return streetname;
    }

    public static String getHousenumber(Element e) {
        String res = e.getTag(housenumberTagKey1);
        if (res != null) {
            return res;
        }
        return e.getTag(housenumberTagKey2);
    }

    private static Integer parseHousenumber(String housenumberString) {
        int housenumber;
        if (housenumberString == null) {
            return null;
        }
        Pattern p = Pattern.compile("\\D*(\\d+)\\D?.*");
        Matcher m = p.matcher(housenumberString);
        if (!m.matches()) {
            return null;
        }
        try {
            housenumber = Integer.parseInt(m.group(1));
        }
        catch (NumberFormatException exp) {
            return null;
        }
        return housenumber;
    }

    private HousenumberElem parseElement(Element el, String sign) {
        String country;
        String region;
        String city = el.getTag(cityTagKey);
        CityInfo ci = this.getCityInfos(city, region = el.getTag(regionTagKey), country = el.getTag(countryTagKey));
        HousenumberElem house = new HousenumberElem(el, ci);
        if (house.getLocation() == null) {
            log.error((Object)"OSM element seems to have no point.");
            log.error((Object)("Element: " + el.toBrowseURL() + " " + el));
            log.error((Object)"Please report on the mkgmap mailing list.");
            log.error((Object)"Continue creating the map. This should be possible without a problem.");
            return null;
        }
        house.setSign(sign);
        Integer hn = HousenumberGenerator.parseHousenumber(sign);
        if (hn == null) {
            if (log.isDebugEnabled()) {
                log.debug("No housenumber (", el.toBrowseURL(), "): ", sign);
            }
            return null;
        }
        if (hn < 0 || hn > 1000000) {
            log.warn("Number looks wrong, is ignored", house.getSign(), hn, "element", el.toBrowseURL());
            return null;
        }
        house.setHousenumber(hn);
        house.setStreet(HousenumberGenerator.getStreetname(el));
        house.setPlace(el.getTag(addrPlaceTagKey));
        String zipStr = el.getTag(postalCodeTagKey);
        ZipCodeInfo zip = this.getZipInfos(zipStr);
        house.setZipCode(zip);
        return house;
    }

    private CityInfo getCityInfos(String city, String region, String country) {
        CityInfo ci = new CityInfo(city, region, country);
        CityInfo ciOld = this.cityInfos.get(ci);
        if (ciOld != null) {
            return ciOld;
        }
        this.cityInfos.put(ci, ci);
        return ci;
    }

    private ZipCodeInfo getZipInfos(String zipStr) {
        ZipCodeInfo zip = new ZipCodeInfo(zipStr);
        ZipCodeInfo zipOld = this.zipInfos.get(zip);
        if (zipOld != null) {
            return zipOld;
        }
        this.zipInfos.put(zip, zip);
        return zip;
    }

    private HousenumberElem handleElement(Element el) {
        String sign = HousenumberGenerator.getHousenumber(el);
        if (sign == null) {
            return null;
        }
        HousenumberElem he = this.parseElement(el, sign);
        if (he == null) {
            return null;
        }
        this.houseElems.add(he);
        return he;
    }

    public void addNode(Node n) {
        if (!this.numbersEnabled) {
            return;
        }
        if ("false".equals(n.getTag(numbersTagKey))) {
            return;
        }
        if ("true".equals(n.getTag(POIGeneratorHook.AREA2POI_TAG))) {
            return;
        }
        HousenumberElem houseElem = this.handleElement(n);
        if (houseElem == null) {
            return;
        }
        if (n.getTag(HousenumberHooks.partOfInterpolationTagKey) != null) {
            this.interpolationNodes.put(n.getId(), this.houseElems.size() - 1);
        }
    }

    public void addWay(Way w) {
        if (!this.numbersEnabled) {
            return;
        }
        if ("false".equals(w.getTag(numbersTagKey))) {
            return;
        }
        String ai = w.getTag(addrInterpolationTagKey);
        if (ai != null) {
            ArrayList<HousenumberElem> nodes = new ArrayList<HousenumberElem>();
            String nodeIds = w.getTag(HousenumberHooks.mkgmapNodeIdsTagKey);
            if (nodeIds != null) {
                String[] ids;
                for (String idString : ids = nodeIds.split(",")) {
                    HousenumberElem node;
                    Long id = Long.decode(idString);
                    Integer elemPos = this.interpolationNodes.get(id);
                    if (elemPos == null || (node = this.houseElems.get(elemPos)) == null) continue;
                    assert (node.getElement().getId() == id.longValue());
                    nodes.add(node);
                }
                this.interpretInterpolationWay(w, nodes);
            }
            return;
        }
        if (w.hasIdenticalEndPoints()) {
            this.handleElement(w);
        }
    }

    private void interpretInterpolationWay(Way w, List<HousenumberElem> nodes) {
        int numNodes = nodes.size();
        String addrInterpolationMethod = w.getTag(addrInterpolationTagKey);
        int step = 0;
        switch (addrInterpolationMethod) {
            case "all": 
            case "1": {
                step = 1;
                break;
            }
            case "even": 
            case "odd": 
            case "2": {
                step = 2;
                break;
            }
        }
        if (step == 0) {
            return;
        }
        int pos = 0;
        ArrayList<HousenumberIvl> hivls = new ArrayList<HousenumberIvl>();
        String streetName = null;
        int i = 0;
        while (i + 1 < numNodes) {
            int k;
            HousenumberElem he1 = nodes.get(i);
            HousenumberElem he2 = nodes.get(i + 1);
            int pos1 = -1;
            int pos2 = -1;
            for (k = pos; k < w.getPoints().size(); ++k) {
                if (w.getPoints().get(k) != he1.getLocation()) continue;
                pos1 = k;
                break;
            }
            if (pos1 < 0) {
                log.error("addr:interpolation node not found in way", w);
                return;
            }
            for (k = pos1 + 1; k < w.getPoints().size(); ++k) {
                if (w.getPoints().get(k) != he2.getLocation()) continue;
                pos2 = k;
                break;
            }
            if (pos2 < 0) {
                log.error("addr:interpolation node not found in way", w);
                return;
            }
            pos = pos2;
            String street = he1.getStreet();
            if (street != null && street.equals(he2.getStreet())) {
                if (streetName == null) {
                    streetName = street;
                } else if (!streetName.equals(street)) {
                    log.warn(w.toBrowseURL(), "addr:interpolation=even is used with different street names", streetName, street);
                    return;
                }
                int start = he1.getHousenumber();
                int end = he2.getHousenumber();
                HousenumberIvl hivl = new HousenumberIvl(street, w, (Node)he1.element, (Node)he2.element);
                hivl.setStart(start);
                hivl.setEnd(end);
                hivl.setStep(step);
                hivl.calcSteps();
                hivl.setPoints(w.getPoints().subList(pos1, pos2 + 1));
                hivls.add(hivl);
                if ("even".equals(addrInterpolationMethod) && (start % 2 != 0 || end % 2 != 0)) {
                    log.warn(w.toBrowseURL(), "addr:interpolation=even is used with odd housenumber(s)", start, end);
                    return;
                }
                if ("odd".equals(addrInterpolationMethod) && (start % 2 == 0 || end % 2 == 0)) {
                    log.warn(w.toBrowseURL(), "addr:interpolation=odd is used with even housenumber(s)", start, end);
                    return;
                }
                if (start == end && he1.getSign().equals(he2.getSign()) && pos1 == 0 && pos2 + 1 == w.getPoints().size()) {
                    hivl.setEqualEnds();
                    log.warn(w.toBrowseURL(), "addr:interpolation way connects two points with equal numbers, numbers are ignored");
                }
            }
            ++i;
        }
        for (HousenumberIvl hivl : hivls) {
            this.interpolationWays.add(streetName, hivl);
        }
    }

    public void addRoad(Way osmRoad, MapRoad road) {
        this.allRoads.add(road);
        if (this.numbersEnabled) {
            if ("false".equals(osmRoad.getTag(numbersTagKey))) {
                road.setSkipHousenumberProcessing(true);
            }
            if (!road.isSkipHousenumberProcessing()) {
                if (this.firstRoadSameOSMWay != null && this.firstRoadSameOSMWay.getRoadDef().getId() == road.getRoadDef().getId() && this.firstRoadSameOSMWay.getPoints().equals(road.getPoints())) {
                    road.setSkipHousenumberProcessing(true);
                    return;
                }
                this.firstRoadSameOSMWay = road;
                String name = road.getStreet();
                if (name != null && log.isDebugEnabled()) {
                    log.debug("Housenumber - Streetname:", name, "Way:", osmRoad.getId(), osmRoad.toTagString());
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addRelation(Relation r) {
        String relType = r.getTag("type");
        if (!"associatedStreet".equals(relType)) {
            if (!"street".equals(relType)) return;
        }
        ArrayList<Element> houses = new ArrayList<Element>();
        ArrayList<Way> streets = new ArrayList<Way>();
        block12: for (Map.Entry<String, Element> member : r.getElements()) {
            String role;
            if (member.getValue() instanceof Node) {
                Node node = (Node)member.getValue();
                houses.add(node);
                continue;
            }
            if (!(member.getValue() instanceof Way)) continue;
            Way w = (Way)member.getValue();
            switch (role = member.getKey()) {
                case "house": 
                case "addr:houselink": 
                case "address": {
                    houses.add(w);
                    continue block12;
                }
                case "street": {
                    streets.add(w);
                    continue block12;
                }
                case "": {
                    if (w.getTag("highway") != null) {
                        streets.add(w);
                        continue block12;
                    }
                    String buildingTag = w.getTag("building");
                    if (buildingTag != null) {
                        houses.add(w);
                        continue block12;
                    }
                    log.warn("Relation", r.toBrowseURL(), ": role of member", w.toBrowseURL(), "unclear");
                    continue block12;
                }
            }
            if (!"associatedStreet".equals(relType)) continue;
            log.warn("Relation", r.toBrowseURL(), ": don't know how to handle member with role", role);
        }
        String streetName = r.getTag("name");
        String streetNameFromRoads = null;
        ArrayList<Element> unnamedStreetElems = new ArrayList<Element>();
        boolean nameFromStreetsIsUnclear = false;
        if (!streets.isEmpty()) {
            for (Element element : streets) {
                String roadName = element.getTag(streetTagKey);
                if (roadName == null) {
                    roadName = element.getTag("name");
                }
                if (roadName == null) {
                    unnamedStreetElems.add(element);
                    continue;
                }
                if (streetNameFromRoads == null) {
                    streetNameFromRoads = roadName;
                    continue;
                }
                if (streetNameFromRoads.equals(roadName)) continue;
                nameFromStreetsIsUnclear = true;
            }
        }
        if (streetName == null) {
            if (nameFromStreetsIsUnclear) {
                log.warn("Relation", r.toBrowseURL(), ": ignored, street name is not clear.");
                return;
            }
            streetName = streetNameFromRoads;
        } else if (streetNameFromRoads != null) {
            if (!nameFromStreetsIsUnclear && !streetName.equals(streetNameFromRoads)) {
                if (!unnamedStreetElems.isEmpty()) {
                    log.warn("Relation", r.toBrowseURL(), ": ignored, street name is not clear.");
                    return;
                }
                log.warn("Relation", r.toBrowseURL(), ": street name is not clear, using the name from the way, not that of the relation.");
                streetName = streetNameFromRoads;
            } else if (nameFromStreetsIsUnclear) {
                log.warn("Relation", r.toBrowseURL(), ": street name is not clear, using the name from the relation.");
            }
        }
        int countModHouses = 0;
        if (streetName != null && !streetName.isEmpty()) {
            for (Element house : houses) {
                if (!HousenumberGenerator.addStreetTagFromRel(r, house, streetName)) continue;
                ++countModHouses;
            }
            for (Element street : unnamedStreetElems) {
                street.addTag(streetTagKey, streetName);
                street.addTag("name", streetName);
            }
        }
        if (!log.isInfoEnabled()) return;
        if (countModHouses <= 0 && unnamedStreetElems.isEmpty()) {
            log.info("Relation", r.toBrowseURL(), ": ignored, no house or street member was changed");
            return;
        }
        if (countModHouses > 0) {
            log.info("Relation", r.toBrowseURL(), ": added tag mkgmap:street=", streetName, "to", countModHouses, "of", houses.size(), "house members");
        }
        if (unnamedStreetElems.isEmpty()) return;
        log.info("Relation", r.toBrowseURL(), ": added tag mkgmap:street=", streetName, "to", unnamedStreetElems.size(), "of", streets.size(), "street members");
    }

    private static boolean addStreetTagFromRel(Relation r, Element house, String streetName) {
        String addrStreet = HousenumberGenerator.getStreetname(house);
        if (addrStreet == null) {
            house.addTag(streetTagKey, streetName);
            if (log.isDebugEnabled()) {
                log.debug("Relation", r.toBrowseURL(), ": adding tag mkgmap:street=" + streetName, "to house", house.toBrowseURL());
            }
            return true;
        }
        if (!addrStreet.equals(streetName)) {
            if (house.getTag(streetTagKey) != null) {
                log.warn("Relation", r.toBrowseURL(), ": street name from relation doesn't match existing mkgmap:street tag for house", house.toBrowseURL(), "the house seems to be member of another type=associatedStreet relation");
                house.deleteTag(streetTagKey);
            } else {
                log.warn("Relation", r.toBrowseURL(), ": street name from relation doesn't match existing name for house", house.toBrowseURL());
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void generate(LineAdder adder, int naxNodeId) {
        if (this.numbersEnabled) {
            MultiHashMap<MapRoad, HousenumberMatch> initialHousesForRoads = this.findClosestRoadsToHouse();
            this.identifyServiceRoads();
            this.handleInterpolationWays(initialHousesForRoads);
            List<HousenumberRoad> hnrList = this.createHousenumberRoads(initialHousesForRoads);
            initialHousesForRoads = null;
            log.info("found", hnrList.size(), "road candidates for address search");
            this.useAddrPlaceTag(hnrList);
            HashMap<MapRoad, HousenumberRoad> road2HousenumberRoadMap = new HashMap<MapRoad, HousenumberRoad>();
            for (HousenumberRoad hnr : hnrList) {
                road2HousenumberRoadMap.put(hnr.getRoad(), hnr);
            }
            Int2ObjectOpenHashMap<HashSet<MapRoad>> nodeId2RoadLists = new Int2ObjectOpenHashMap<HashSet<MapRoad>>();
            for (MapRoad road : this.allRoads) {
                for (Coord co : road.getPoints()) {
                    void var11_11;
                    if (co.getId() == 0) continue;
                    HashSet<MapRoad> hashSet = nodeId2RoadLists.get(co.getId());
                    if (hashSet == null) {
                        HashSet hashSet2 = new HashSet();
                        nodeId2RoadLists.put(co.getId(), (HashSet<MapRoad>)hashSet2);
                    }
                    var11_11.add(road);
                }
            }
            ArrayList<HousenumberRoad> addedRoads = new ArrayList<HousenumberRoad>();
            Iterator<HousenumberRoad> iter = hnrList.iterator();
            while (iter.hasNext()) {
                HousenumberRoad hnr = iter.next();
                List<HousenumberMatch> lostHouses = hnr.checkStreetName(road2HousenumberRoadMap, nodeId2RoadLists);
                for (HousenumberMatch house : lostHouses) {
                    MapRoad r = house.getRoad();
                    if (r == null) continue;
                    HousenumberRoad hnr2 = (HousenumberRoad)road2HousenumberRoadMap.get(r);
                    if (hnr2 == null) {
                        CityInfo ci = this.getCityInfos(r.getCity(), r.getRegion(), r.getCountry());
                        hnr2 = new HousenumberRoad(r, ci, Arrays.asList(house));
                        if (r.getZip() != null) {
                            hnr2.setZipCodeInfo(this.getZipInfos(r.getZip()));
                        }
                        road2HousenumberRoadMap.put(r, hnr2);
                        addedRoads.add(hnr2);
                        continue;
                    }
                    hnr2.addHouse(house);
                }
                if (hnr.getName() != null) continue;
                iter.remove();
                for (HousenumberMatch house : hnr.getHouses()) {
                    log.warn("found no plausible road name for address", house.toBrowseURL(), ", closest road id:", house.getRoad());
                }
            }
            hnrList.addAll(addedRoads);
            this.removeDupsGroupedByCityAndName(hnrList);
            TreeMap streetnameCityRoadMap = new TreeMap();
            for (HousenumberRoad housenumberRoad : hnrList) {
                ArrayList<HousenumberRoad> roadsInCluster;
                TreeMap<CityInfo, ArrayList<HousenumberRoad>> cluster = (TreeMap<CityInfo, ArrayList<HousenumberRoad>>)streetnameCityRoadMap.get(housenumberRoad.getName());
                if (cluster == null) {
                    cluster = new TreeMap<CityInfo, ArrayList<HousenumberRoad>>();
                    streetnameCityRoadMap.put(housenumberRoad.getName(), cluster);
                }
                if ((roadsInCluster = (ArrayList<HousenumberRoad>)cluster.get(housenumberRoad.getRoadCityInfo())) == null) {
                    roadsInCluster = new ArrayList<HousenumberRoad>();
                    cluster.put(housenumberRoad.getRoadCityInfo(), roadsInCluster);
                }
                roadsInCluster.add(housenumberRoad);
            }
            for (Map.Entry entry : streetnameCityRoadMap.entrySet()) {
                String streetName = (String)entry.getKey();
                for (Map.Entry clusterEntry : ((TreeMap)entry.getValue()).entrySet()) {
                    this.useInterpolationInfo(streetName, (List)clusterEntry.getValue(), road2HousenumberRoadMap);
                }
                for (Map.Entry clusterEntry : ((TreeMap)entry.getValue()).entrySet()) {
                    List roadsInCluster = (List)clusterEntry.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug("processing road(s) with name", streetName, "in", clusterEntry.getKey());
                    }
                    for (HousenumberRoad hnr : roadsInCluster) {
                        hnr.buildIntervals();
                    }
                    boolean optimized = false;
                    for (int loop = 0; loop < 10; ++loop) {
                        for (HousenumberRoad hnr : roadsInCluster) {
                            hnr.checkIntervals();
                        }
                        HousenumberGenerator.checkWrongRoadAssignmments(roadsInCluster);
                        boolean changed = HousenumberGenerator.hasChanges(roadsInCluster);
                        if (!optimized && !changed) {
                            for (HousenumberRoad hnr : roadsInCluster) {
                                hnr.improveSearchResults();
                            }
                            changed = HousenumberGenerator.hasChanges(roadsInCluster);
                            optimized = true;
                        }
                        if (!changed) break;
                    }
                    for (HousenumberRoad hnr : roadsInCluster) {
                        hnr.setNumbers();
                    }
                }
            }
        }
        if (log.isInfoEnabled()) {
            for (HousenumberElem house : this.houseElems) {
                if (house.getRoad() != null) continue;
                if (house.getStreet() != null) {
                    log.info("found no plausible road for house number element", house.toBrowseURL(), house.getStreet(), house.getSign());
                    continue;
                }
                log.info("found no plausible road for house number element", house.toBrowseURL());
            }
        }
        for (MapRoad r : this.allRoads) {
            List<Numbers> finalNumbers;
            if (log.isDebugEnabled() && (finalNumbers = r.getRoadDef().getNumbersList()) != null) {
                log.info("id:" + r.getRoadDef().getId(), ", final numbers,", r, "in", r.getCity());
                for (Numbers cn : finalNumbers) {
                    if (cn.isEmpty()) continue;
                    log.info(new Object[]{"id:" + r.getRoadDef().getId(), ", Left: ", cn.getLeftNumberStyle(), cn.getIndex(), "Start:", cn.getLeftStart(), "End:", cn.getLeftEnd()});
                    log.info(new Object[]{"id:" + r.getRoadDef().getId(), ", Right:", cn.getRightNumberStyle(), cn.getIndex(), "Start:", cn.getRightStart(), "End:", cn.getRightEnd()});
                }
            }
            adder.add(r);
        }
    }

    private List<HousenumberRoad> createHousenumberRoads(MultiHashMap<MapRoad, HousenumberMatch> initialHousesForRoads) {
        ArrayList<HousenumberRoad> hnrList = new ArrayList<HousenumberRoad>();
        for (MapRoad road : this.allRoads) {
            Object houses;
            if (road.isSkipHousenumberProcessing() || (houses = initialHousesForRoads.get(road)) == null || houses.isEmpty()) continue;
            CityInfo ci = this.getCityInfos(road.getCity(), road.getRegion(), road.getCountry());
            HousenumberRoad hnr = new HousenumberRoad(road, ci, (List<HousenumberMatch>)houses);
            if (road.getZip() != null) {
                hnr.setZipCodeInfo(this.getZipInfos(road.getZip()));
            }
            hnrList.add(hnr);
        }
        return hnrList;
    }

    private MultiHashMap<MapRoad, HousenumberMatch> findClosestRoadsToHouse() {
        long t1 = System.currentTimeMillis();
        RoadSegmentIndex roadSegmentIndex = new RoadSegmentIndex(this.allRoads, 150.0);
        long t2 = System.currentTimeMillis();
        log.debug("creation of road index took", t2 - t1, "ms");
        long t3 = System.currentTimeMillis();
        MultiHashMap<MapRoad, HousenumberMatch> initialHousesForRoads = new MultiHashMap<MapRoad, HousenumberMatch>();
        for (int i = 0; i < this.houseElems.size(); ++i) {
            HousenumberElem house = this.houseElems.get(i);
            HousenumberMatch bestMatch = roadSegmentIndex.createHousenumberMatch(house);
            this.houseElems.set(i, bestMatch);
            if (bestMatch.getRoad() == null) {
                bestMatch.setIgnored(true);
                continue;
            }
            initialHousesForRoads.add(bestMatch.getRoad(), bestMatch);
        }
        long t4 = System.currentTimeMillis();
        log.debug("identification of closest road for each house took", t4 - t3, "ms");
        return initialHousesForRoads;
    }

    private void useAddrPlaceTag(List<HousenumberRoad> hnrList) {
        LinkedHashMap<CityInfo, MultiHashMap<String, HousenumberMatch>> cityPlaceHouseMap = new LinkedHashMap<CityInfo, MultiHashMap<String, HousenumberMatch>>();
        for (int i = 0; i < this.houseElems.size(); ++i) {
            HousenumberElem house = this.houseElems.get(i);
            if (house.getRoad() == null || house.getPlace() == null) continue;
            MultiHashMap<String, HousenumberMatch> subMap = (MultiHashMap<String, HousenumberMatch>)((HashMap)cityPlaceHouseMap).get(house.getCityInfo());
            if (subMap == null) {
                subMap = new MultiHashMap<String, HousenumberMatch>();
                cityPlaceHouseMap.put(house.getCityInfo(), subMap);
            }
            subMap.add(house.getPlace(), (HousenumberMatch)house);
        }
        log.info("analysing", cityPlaceHouseMap.size(), "cities with addr:place=* houses");
        for (Map.Entry topEntry : ((HashMap)cityPlaceHouseMap).entrySet()) {
            CityInfo cityInfo = (CityInfo)topEntry.getKey();
            ArrayList placeNames = new ArrayList(((MultiHashMap)topEntry.getValue()).keySet());
            Collections.sort(placeNames);
            for (String placeName : placeNames) {
                Object placeHouses = ((MultiHashMap)topEntry.getValue()).get(placeName);
                LinkedHashSet<HousenumberRoad> roads = new LinkedHashSet<HousenumberRoad>();
                Int2IntOpenHashMap usedNumbers = new Int2IntOpenHashMap();
                HashMap<String, Integer> usedSigns = new HashMap<String, Integer>();
                int dupSigns = 0;
                int dupNumbers = 0;
                int housesWithStreet = 0;
                int housesWithMatchingStreet = 0;
                int roadsWithNames = 0;
                int unnamedCloseRoads = 0;
                Iterator i$ = placeHouses.iterator();
                while (i$.hasNext()) {
                    Integer oldSignCount;
                    int oldCount;
                    boolean added;
                    HousenumberMatch house = (HousenumberMatch)i$.next();
                    if (house.getStreet() != null) {
                        ++housesWithStreet;
                        if (house.getStreet().equalsIgnoreCase(house.getRoad().getStreet())) {
                            ++housesWithMatchingStreet;
                        }
                    } else if (house.getRoad().getStreet() == null) {
                        ++unnamedCloseRoads;
                    }
                    if ((added = roads.add(house.getHousenumberRoad())) && house.getRoad().getStreet() != null) {
                        ++roadsWithNames;
                    }
                    if ((oldCount = usedNumbers.put(house.getHousenumber(), 1)) != 0) {
                        usedNumbers.put(house.getHousenumber(), oldCount + 1);
                        ++dupNumbers;
                    }
                    if ((oldSignCount = usedSigns.put(house.getSign(), 1)) == null) continue;
                    usedSigns.put(house.getSign(), oldSignCount + 1);
                    ++dupSigns;
                }
                if (log.isDebugEnabled()) {
                    log.debug("place", placeName, "in city", cityInfo, ":", "houses:", placeHouses.size(), ",duplicate numbers/signs:", dupNumbers + "/" + dupSigns, ",roads (named/unnamed):", roads.size(), "(" + roadsWithNames + "/" + (roads.size() - roadsWithNames) + ")", ",houses without addr:street:", placeHouses.size() - housesWithStreet, ",street = name of closest road:", housesWithMatchingStreet, ",houses without addr:street near named road:", unnamedCloseRoads);
                }
                if ((double)((float)dupSigns / (float)placeHouses.size()) < 0.25) {
                    if (log.isDebugEnabled()) {
                        log.debug("will not use gaps in intervals for roads in", placeName);
                    }
                    for (HousenumberRoad hnr : roads) {
                        hnr.setRemoveGaps(true);
                    }
                }
                if (placeHouses.size() > housesWithStreet) {
                    LongArrayList ids = new LongArrayList();
                    for (HousenumberRoad hnr : roads) {
                        ids.add(hnr.getRoad().getRoadDef().getId());
                        hnr.addPlaceName(placeName);
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug("detected", placeName, "as potential address name for roads", ids);
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("will ignore addr:place for address search in", placeName, "in city", cityInfo);
            }
        }
    }

    private void handleInterpolationWays(MultiHashMap<MapRoad, HousenumberMatch> initialHousesForRoads) {
        for (Map.Entry entry : this.interpolationWays.entrySet()) {
            List infos = (List)entry.getValue();
            for (HousenumberIvl info : infos) {
                int i;
                boolean isOK;
                if (info.isBad() || !(isOK = info.setNodeRefs(this.interpolationNodes, this.houseElems))) continue;
                HousenumberMatch[] houses = info.getHouseNodes();
                MapRoad[] uncheckedRoads = new MapRoad[houses.length];
                for (i = 0; i < houses.length; ++i) {
                    uncheckedRoads[i] = houses[i].getRoad();
                }
                isOK = info.checkRoads();
                houses = info.getHouseNodes();
                for (i = 0; i < houses.length; ++i) {
                    if (houses[i].getRoad() == uncheckedRoads[i]) continue;
                    initialHousesForRoads.removeMapping(uncheckedRoads[i], houses[i]);
                    if (!houses[i].isIgnored()) {
                        initialHousesForRoads.add(houses[i].getRoad(), houses[i]);
                        continue;
                    }
                    if (isOK) continue;
                    log.info("housenumber is assigned to different road after checking addr:interpolation way which turned out to be invalid", houses[i], info);
                }
            }
        }
    }

    private void removeDupsGroupedByCityAndName(List<HousenumberRoad> hnrList) {
        LinkedHashMap<CityInfo, MultiHashMap<String, HousenumberMatch>> cityNameHouseMap = new LinkedHashMap<CityInfo, MultiHashMap<String, HousenumberMatch>>();
        for (int i = 0; i < this.houseElems.size(); ++i) {
            HousenumberRoad hnr;
            HousenumberMatch hm;
            HousenumberElem house = this.houseElems.get(i);
            if (house.getRoad() == null || !(house instanceof HousenumberMatch) || (hm = (HousenumberMatch)house).isIgnored() || (hnr = hm.getHousenumberRoad()) == null || hnr.getName() == null) continue;
            MultiHashMap<String, HousenumberMatch> subMap = (MultiHashMap<String, HousenumberMatch>)((HashMap)cityNameHouseMap).get(hm.getCityInfo());
            if (subMap == null) {
                subMap = new MultiHashMap<String, HousenumberMatch>();
                cityNameHouseMap.put(hm.getCityInfo(), subMap);
            }
            subMap.add(hnr.getName(), hm);
        }
        for (Map.Entry topEntry : ((HashMap)cityNameHouseMap).entrySet()) {
            for (Map.Entry entry : ((MultiHashMap)topEntry.getValue()).entrySet()) {
                HousenumberGenerator.markSimpleDuplicates((String)entry.getKey(), (List)entry.getValue());
            }
        }
    }

    private static void checkSegment(HousenumberMatch house, MapRoad road, int seg) {
        double frac;
        Coord c1;
        Coord cx = house.getLocation();
        Coord c0 = road.getPoints().get(seg);
        double dist = HousenumberGenerator.distanceToSegment(c0, c1 = road.getPoints().get(seg + 1), cx, frac = HousenumberGenerator.getFrac(c0, c1, cx));
        if (dist < house.getDistance()) {
            house.setDistance(dist);
            house.setRoad(road);
            house.setSegment(seg);
            house.setSegmentFrac(frac);
        }
    }

    private void identifyServiceRoads() {
        Int2ObjectOpenHashMap<String> roadNamesByNodeIds = new Int2ObjectOpenHashMap<String>();
        HashMap coordNodesUnnamedRoads = new HashMap();
        HashSet<Integer> unclearNodeIds = new HashSet<Integer>();
        long t1 = System.currentTimeMillis();
        ArrayList<MapRoad> unnamedRoads = new ArrayList<MapRoad>();
        for (MapRoad road : this.allRoads) {
            if (road.isSkipHousenumberProcessing()) continue;
            if (road.getStreet() == null) {
                if (road.getName() != null) continue;
                unnamedRoads.add(road);
                ArrayList<Coord> nodes = new ArrayList<Coord>();
                for (Coord co : road.getPoints()) {
                    if (co.getId() == 0) continue;
                    nodes.add(co);
                }
                coordNodesUnnamedRoads.put(road, nodes);
                continue;
            }
            this.identifyNodes(road.getPoints(), road.getStreet(), roadNamesByNodeIds, unclearNodeIds);
        }
        int numUnnamedRoads = unnamedRoads.size();
        long t2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("identifyServiceRoad step 1 took", t2 - t1, "ms, found", roadNamesByNodeIds.size(), "nodes to check and", numUnnamedRoads, "unnamed roads");
        }
        long t3 = System.currentTimeMillis();
        int named = 0;
        for (int pass = 1; pass <= this.nameSearchDepth; ++pass) {
            int unnamed = 0;
            ArrayList<MapRoad> namedRoads = new ArrayList<MapRoad>();
            for (int j = 0; j < unnamedRoads.size(); ++j) {
                MapRoad road = (MapRoad)unnamedRoads.get(j);
                if (road == null) continue;
                ++unnamed;
                List coordNodes = (List)coordNodesUnnamedRoads.get(road);
                String name = null;
                for (Coord co : coordNodes) {
                    if (unclearNodeIds.contains(co.getId())) {
                        name = null;
                        unnamedRoads.set(j, null);
                        break;
                    }
                    String possibleName = roadNamesByNodeIds.get(co.getId());
                    if (possibleName == null) continue;
                    if (name == null) {
                        name = possibleName;
                        continue;
                    }
                    if (name.equals(possibleName)) continue;
                    name = null;
                    unnamedRoads.set(j, null);
                    break;
                }
                if (name == null) continue;
                ++named;
                road.setStreet(name);
                namedRoads.add(road);
                unnamedRoads.set(j, null);
            }
            for (MapRoad road : namedRoads) {
                road.setNamedByHousenumberProcessing(true);
                String name = road.getStreet();
                if (log.isDebugEnabled()) {
                    log.debug("pass", pass, "using unnamed road for housenumber processing,id=", road.getRoadDef().getId(), ":", name);
                }
                List coordNodes = (List)coordNodesUnnamedRoads.get(road);
                this.identifyNodes(coordNodes, name, roadNamesByNodeIds, unclearNodeIds);
            }
            if (namedRoads.isEmpty()) break;
            if (!log.isDebugEnabled()) continue;
            log.debug("pass", pass, unnamed, named);
        }
        long t4 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("indentifyServiceRoad step 2 took", t4 - t3, "ms, found a name for", named, "of", numUnnamedRoads, "roads");
        }
    }

    private void identifyNodes(List<Coord> roadPoints, String streetName, Int2ObjectOpenHashMap<String> roadNamesByNodeIds, HashSet<Integer> unclearNodes) {
        for (Coord co : roadPoints) {
            String prevName;
            if (co.getId() == 0 || (prevName = roadNamesByNodeIds.put(co.getId(), streetName)) == null || prevName.equals(streetName)) continue;
            unclearNodes.add(co.getId());
        }
    }

    private void useInterpolationInfo(String streetName, List<HousenumberRoad> roadsInCluster, Map<MapRoad, HousenumberRoad> road2HousenumberRoadMap) {
        Object interpolationInfos = this.interpolationWays.get(streetName);
        if (interpolationInfos.isEmpty()) {
            return;
        }
        ArrayList<HousenumberMatch> housesWithIvlInfo = new ArrayList<HousenumberMatch>();
        for (HousenumberRoad hnr : roadsInCluster) {
            for (HousenumberMatch house : hnr.getHouses()) {
                if (house.getIntervalInfoRefs() <= 0) continue;
                housesWithIvlInfo.add(house);
            }
        }
        if (housesWithIvlInfo.isEmpty()) {
            return;
        }
        HashMap<String, HousenumberIvl> simpleDupCheckSet = new HashMap<String, HousenumberIvl>();
        HashSet<HousenumberIvl> badIvls = new HashSet<HousenumberIvl>();
        Long2ObjectOpenHashMap<HousenumberIvl> id2IvlMap = new Long2ObjectOpenHashMap<HousenumberIvl>();
        Int2ObjectOpenHashMap<HousenumberMatch> interpolatedNumbers = new Int2ObjectOpenHashMap<HousenumberMatch>();
        Int2ObjectOpenHashMap<HousenumberMatch> existingNumbers = new Int2ObjectOpenHashMap<HousenumberMatch>();
        LinkedHashMap<HousenumberIvl, List<HousenumberMatch>> housesToAdd = new LinkedHashMap<HousenumberIvl, List<HousenumberMatch>>();
        for (HousenumberRoad hnr : roadsInCluster) {
            for (HousenumberMatch house : hnr.getHouses()) {
                existingNumbers.put(house.getHousenumber(), house);
            }
        }
        int inCluster = 0;
        boolean allOK = true;
        for (int i = 0; i < interpolationInfos.size(); ++i) {
            HousenumberIvl hivl = (HousenumberIvl)interpolationInfos.get(i);
            if (!hivl.inCluster(housesWithIvlInfo) || hivl.ignoreForInterpolation()) continue;
            ++inCluster;
            String hivlDesc = hivl.getDesc();
            HousenumberIvl hivlTest = (HousenumberIvl)simpleDupCheckSet.get(hivlDesc);
            if (hivlTest != null) {
                log.warn("found additional addr:interpolation way with same meaning, is ignored:", streetName, hivl, hivlTest);
                badIvls.add(hivl);
                allOK = false;
                continue;
            }
            simpleDupCheckSet.put(hivlDesc, hivl);
            id2IvlMap.put(hivl.getId(), hivl);
            List<HousenumberMatch> interpolatedHouses = hivl.getInterpolatedHouses();
            if (interpolatedHouses.isEmpty()) continue;
            if (interpolatedHouses.get(0).getRoad() == null) {
                HousenumberGenerator.findRoadForInterpolatedHouses(streetName, interpolatedHouses, roadsInCluster);
            }
            int dupCount = 0;
            for (HousenumberMatch house : interpolatedHouses) {
                if (house.getRoad() == null || house.getDistance() > 75.0) continue;
                boolean ignoreGenOnly = false;
                HousenumberMatch old = (HousenumberMatch)interpolatedNumbers.get(house.getHousenumber());
                if (old == null) {
                    ignoreGenOnly = true;
                    old = (HousenumberMatch)existingNumbers.get(house.getHousenumber());
                }
                if (old == null) continue;
                Object[] splitIvls = hivl.trySplitAt(old);
                if (splitIvls != null) {
                    log.info("adding address", streetName, old, old.toBrowseURL(), "to addr:interpolation way, replacing", hivl, "by", Arrays.deepToString(splitIvls));
                    interpolationInfos.add(splitIvls[0]);
                    interpolationInfos.add(splitIvls[1]);
                    hivl.setIgnoreForInterpolation(true);
                    break;
                }
                house.setIgnored(true);
                double distToOld = old.getLocation().distance(house.getLocation());
                if (!(distToOld > 100.0)) continue;
                if (old.isInterpolated()) {
                    log.info("conflict caused by addr:interpolation way", streetName, hivl, "and interpolated address", old, "at", old.getLocation().toDegreeString());
                } else {
                    log.info("conflict caused by addr:interpolation way", streetName, hivl, "and address element", old, "at", old.getLocation().toDegreeString());
                }
                ++dupCount;
                if (ignoreGenOnly) continue;
                old.setIgnored(true);
                long ivlId = old.getElement().getOriginalId();
                HousenumberIvl bad = (HousenumberIvl)id2IvlMap.get(ivlId);
                if (bad == null) continue;
                badIvls.add(bad);
            }
            if (hivl.ignoreForInterpolation()) continue;
            if (dupCount > 0) {
                log.warn("addr:interpolation way", streetName, hivl, "is ignored, it produces", dupCount, "duplicate number(s) too far from existing nodes");
                badIvls.add(hivl);
                continue;
            }
            housesToAdd.put(hivl, interpolatedHouses);
            for (HousenumberMatch hnm : interpolatedHouses) {
                interpolatedNumbers.put(hnm.getHousenumber(), hnm);
            }
        }
        if (inCluster == 0) {
            return;
        }
        for (HousenumberIvl badIvl : badIvls) {
            allOK = false;
            badIvl.ignoreNodes();
            housesToAdd.remove(badIvl);
        }
        for (Map.Entry entry : ((HashMap)housesToAdd).entrySet()) {
            if (log.isInfoEnabled()) {
                log.info("using generated house numbers from addr:interpolation way", entry.getKey());
            }
            for (HousenumberMatch house : (List)entry.getValue()) {
                if (house.getRoad() == null || house.isIgnored()) continue;
                HousenumberRoad hnr = road2HousenumberRoadMap.get(house.getRoad());
                if (hnr == null) {
                    log.error("internal error: found no housenumber road for interpolated house", house.toBrowseURL());
                    continue;
                }
                hnr.addHouse(house);
            }
        }
        if (log.isDebugEnabled()) {
            if (allOK) {
                log.debug("found no problems with interpolated numbers from addr:interpolations ways for roads with name", streetName);
            } else {
                log.debug("found problems with interpolated numbers from addr:interpolations ways for roads with name", streetName);
            }
        }
    }

    private static void findRoadForInterpolatedHouses(String streetName, List<HousenumberMatch> houses, List<HousenumberRoad> roadsInCluster) {
        if (houses.isEmpty()) {
            return;
        }
        Collections.sort(houses, new HousenumberMatchByNumComparator());
        HousenumberMatch prev = null;
        for (HousenumberMatch house : houses) {
            HousenumberMatch closest;
            if (house.isIgnored()) continue;
            house.setDistance(Double.POSITIVE_INFINITY);
            house.setRoad(null);
            ArrayList<HousenumberMatch> matches = new ArrayList<HousenumberMatch>();
            for (HousenumberRoad hnr : roadsInCluster) {
                MapRoad r = hnr.getRoad();
                if (house.getPlace() != null && house.getStreet() != null && r.getStreet() != null && !house.getStreet().equals(r.getStreet())) continue;
                HousenumberMatch test = new HousenumberMatch(house);
                HousenumberGenerator.findClosestRoadSegment(test, r);
                if ((test.getRoad() == null || test.getGroup() == null) && !(test.getDistance() < 150.0)) continue;
                matches.add(test);
            }
            if (matches.isEmpty()) {
                house.setIgnored(true);
                continue;
            }
            HousenumberMatch best = closest = (HousenumberMatch)matches.get(0);
            if (matches.size() > 1) {
                Collections.sort(matches, new HousenumberMatchByDistComparator());
                closest = (HousenumberMatch)matches.get(0);
                best = HousenumberGenerator.checkAngle(closest, matches);
            }
            house.setDistance(best.getDistance());
            house.setSegmentFrac(best.getSegmentFrac());
            house.setRoad(best.getRoad());
            house.setSegment(best.getSegment());
            for (HousenumberMatch altHouse : matches) {
                if (altHouse.getRoad() == best.getRoad() || !(altHouse.getDistance() < 150.0)) continue;
                house.addAlternativeRoad(altHouse.getRoad());
            }
            if (house.getRoad() == null) {
                house.setIgnored(true);
            } else {
                house.calcRoadSide();
            }
            if (prev != null && prev.getHousenumber() == house.getHousenumber() && prev.getSign().equals(house.getSign())) {
                prev.setDuplicate(true);
                house.setDuplicate(true);
            }
            if (house.getRoad() == null && !house.isIgnored()) {
                log.warn("found no plausible road for house number element", house.toBrowseURL(), "(", streetName, house.getSign(), ")");
            }
            if (house.isIgnored()) continue;
            prev = house;
        }
    }

    private static void markSimpleDuplicates(String streetName, List<HousenumberMatch> housesNearCluster) {
        ArrayList<HousenumberMatch> sortedHouses = new ArrayList<HousenumberMatch>(housesNearCluster);
        Collections.sort(sortedHouses, new HousenumberMatchByNumComparator());
        int n = sortedHouses.size();
        for (int i = 1; i < n; ++i) {
            HousenumberMatch house2;
            HousenumberMatch house1 = (HousenumberMatch)sortedHouses.get(i - 1);
            if (house1.isIgnored() || (house2 = (HousenumberMatch)sortedHouses.get(i)).isIgnored() || house1.getHousenumber() != house2.getHousenumber()) continue;
            if (house1.getRoad() == house2.getRoad()) {
                if (!house1.isFarDuplicate()) continue;
                house2.setFarDuplicate(true);
                continue;
            }
            boolean markFarDup = false;
            double dist = house1.getLocation().distance(house2.getLocation());
            if (dist > 100.0) {
                markFarDup = true;
            } else {
                CityInfo city1 = house1.getCityInfo();
                CityInfo city2 = house2.getCityInfo();
                if (city1 != null && !city1.equals(city2)) {
                    markFarDup = true;
                }
            }
            if (markFarDup) {
                if (log.isDebugEnabled()) {
                    log.debug("keeping duplicate numbers assigned to different roads in cluster ", streetName, house1, house2);
                }
                house1.setFarDuplicate(true);
                house2.setFarDuplicate(true);
                continue;
            }
            boolean ignore2nd = false;
            if (dist < 30.0) {
                ignore2nd = true;
            } else {
                Coord c1s = house1.getRoad().getPoints().get(house1.getSegment());
                Coord c1e = house1.getRoad().getPoints().get(house1.getSegment() + 1);
                Coord c2s = house2.getRoad().getPoints().get(house2.getSegment());
                Coord c2e = house2.getRoad().getPoints().get(house2.getSegment() + 1);
                if (c1s == c2s || c1s == c2e || c1e == c2s || c1e == c2e) {
                    ignore2nd = true;
                }
            }
            if (ignore2nd) {
                house2.setIgnored(true);
                if (!log.isDebugEnabled()) continue;
                if (house1.getSign().equals(house2.getSign())) {
                    log.debug("duplicate number is ignored", streetName, house2.getSign(), house2.toBrowseURL());
                    continue;
                }
                log.info("using", streetName, house1.getSign(), "in favor of", house2.getSign(), "as target for address search");
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug("keeping duplicate numbers assigned to different roads in cluster ", streetName, house1, house2);
            }
            house1.setFarDuplicate(true);
            house2.setFarDuplicate(true);
        }
    }

    public static void findClosestRoadSegment(HousenumberMatch house, MapRoad r) {
        HousenumberGenerator.findClosestRoadSegment(house, r, 0, r.getPoints().size());
    }

    public static void findClosestRoadSegment(HousenumberMatch house, MapRoad r, int firstSeg, int stopSeg) {
        Coord cx = house.getLocation();
        double oldDist = house.getDistance();
        MapRoad oldRoad = house.getRoad();
        house.setRoad(null);
        house.setDistance(Double.POSITIVE_INFINITY);
        boolean foundGroupLink = false;
        int end = Math.min(r.getPoints().size(), stopSeg + 1);
        int node = firstSeg;
        while (node + 1 < end) {
            Coord c1 = r.getPoints().get(node);
            Coord c2 = r.getPoints().get(node + 1);
            double frac = HousenumberGenerator.getFrac(c1, c2, cx);
            double dist = HousenumberGenerator.distanceToSegment(c1, c2, cx, frac);
            if (house.getGroup() != null && house.getGroup().linkNode == c1) {
                if (!c1.highPrecEquals(c2)) {
                    log.debug("block doesn't have zero length segment! Road:", r, house);
                }
                foundGroupLink = true;
                house.setDistance(dist);
                house.setSegmentFrac(frac);
                house.setRoad(r);
                house.setSegment(node);
                break;
            }
            if (dist < house.getDistance()) {
                house.setDistance(dist);
                house.setSegmentFrac(frac);
                house.setRoad(r);
                house.setSegment(node);
            }
            ++node;
        }
        if (house.getGroup() != null && house.getGroup().linkNode != null && !foundGroupLink) {
            log.debug(r, house, "has a group but the link was not found, should only happen after split of zero-length-segment");
        }
        if (oldRoad == r && house.getDistance() > 152.5 && oldDist <= 150.0) {
            log.warn("line distorted? Road segment was moved by more than", String.format("%.2f m", 2.5), ", from address", r, house.getSign());
        }
    }

    private static boolean hasChanges(List<HousenumberRoad> housenumberRoads) {
        for (HousenumberRoad hnr : housenumberRoads) {
            if (!hnr.isChanged()) continue;
            return true;
        }
        return false;
    }

    private static void checkWrongRoadAssignmments(List<HousenumberRoad> housenumberRoads) {
        if (housenumberRoads.size() < 2) {
            return;
        }
        for (int loop = 0; loop < 10; ++loop) {
            boolean changed = false;
            int i = 0;
            while (i + 1 < housenumberRoads.size()) {
                HousenumberRoad hnr1 = housenumberRoads.get(i);
                hnr1.setChanged(false);
                for (int j = i + 1; j < housenumberRoads.size(); ++j) {
                    HousenumberRoad hnr2 = housenumberRoads.get(j);
                    hnr2.setChanged(false);
                    hnr1.checkWrongRoadAssignmments(hnr2);
                    if (hnr1.isChanged()) {
                        changed = true;
                        hnr1.checkIntervals();
                    }
                    if (!hnr2.isChanged()) continue;
                    changed = true;
                    hnr2.checkIntervals();
                }
                ++i;
            }
            if (changed) continue;
            return;
        }
    }

    private static HousenumberMatch checkAngle(HousenumberMatch closestMatch, List<HousenumberMatch> otherMatches) {
        if (otherMatches.isEmpty()) {
            return closestMatch;
        }
        HousenumberMatch bestMatch = closestMatch;
        for (HousenumberMatch alternative : otherMatches) {
            double deltaAlt;
            if (alternative == closestMatch) continue;
            if (closestMatch.getDistance() < alternative.getDistance()) break;
            Coord c1 = closestMatch.getRoad().getPoints().get(closestMatch.getSegment());
            Coord c2 = closestMatch.getRoad().getPoints().get(closestMatch.getSegment() + 1);
            Coord cx = closestMatch.getLocation();
            double dist = closestMatch.getDistance();
            double dist1 = cx.distance(c1);
            double angle = dist1 == dist ? Utils.getAngle(c2, c1, cx) : Utils.getAngle(c1, c2, cx);
            Coord c3 = alternative.getRoad().getPoints().get(alternative.getSegment());
            Coord c4 = alternative.getRoad().getPoints().get(alternative.getSegment() + 1);
            double dist3 = cx.distance(c3);
            double altAngle = dist3 == dist ? Utils.getAngle(c4, c3, cx) : Utils.getAngle(c3, c4, cx);
            double delta = 90.0 - Math.abs(angle);
            if (!(delta > (deltaAlt = 90.0 - Math.abs(altAngle)))) continue;
            bestMatch = alternative;
            c1 = c3;
            c2 = c4;
        }
        if (log.isDebugEnabled()) {
            if (closestMatch.getRoad() != bestMatch.getRoad()) {
                log.debug("check angle: using road", bestMatch.getRoad().getRoadDef().getId(), "instead of", closestMatch.getRoad().getRoadDef().getId(), "for house number", bestMatch.getSign(), bestMatch.toBrowseURL());
            } else if (closestMatch != bestMatch) {
                log.debug("check angle: using road segment", bestMatch.getSegment(), "instead of", closestMatch.getSegment(), "for house number element", bestMatch.toBrowseURL());
            }
        }
        return bestMatch;
    }

    public static boolean isLeft(Coord spoint1, Coord spoint2, Coord point) {
        if (spoint1.distance(spoint2) == 0.0) {
            log.warn((Object)"road segment length is 0 in left/right evaluation");
        }
        return (spoint2.getHighPrecLon() - spoint1.getHighPrecLon()) * (point.getHighPrecLat() - spoint1.getHighPrecLat()) - (spoint2.getHighPrecLat() - spoint1.getHighPrecLat()) * (point.getHighPrecLon() - spoint1.getHighPrecLon()) > 0;
    }

    public static double distanceToSegment(Coord spoint1, Coord spoint2, Coord point, double frac) {
        if (frac <= 0.0) {
            return spoint1.distance(point);
        }
        if (frac >= 1.0) {
            return spoint2.distance(point);
        }
        return point.distToLineSegment(spoint1, spoint2);
    }

    public static double getFrac(Coord spoint1, Coord spoint2, Coord point) {
        int aLon = spoint1.getHighPrecLon();
        int bLon = spoint2.getHighPrecLon();
        int pLon = point.getHighPrecLon();
        int aLat = spoint1.getHighPrecLat();
        int bLat = spoint2.getHighPrecLat();
        int pLat = point.getHighPrecLat();
        double deltaLon = bLon - aLon;
        double deltaLat = bLat - aLat;
        if (deltaLon == 0.0 && deltaLat == 0.0) {
            return 0.0;
        }
        double scale = Math.cos(Coord.int30ToRadians((aLat + bLat + pLat) / 3));
        double deltaLonAP = scale * (double)(pLon - aLon);
        if ((deltaLon = scale * deltaLon) == 0.0 && deltaLat == 0.0) {
            return 0.0;
        }
        return (deltaLonAP * deltaLon + (double)(pLat - aLat) * deltaLat) / (deltaLon * deltaLon + deltaLat * deltaLat);
    }

    public static String formatLen(double length) {
        return String.format("%.2f m", length);
    }

    class RoadSegmentIndex {
        private final KdTree<RoadPoint> kdTree = new KdTree();
        private final Int2ObjectOpenHashMap<Set<RoadPoint>> nodeId2RoadPointMap = new Int2ObjectOpenHashMap();
        private final double range;
        private final double maxSegmentLength;
        private final double kdSearchRange;

        public RoadSegmentIndex(List<MapRoad> roads, double rangeInMeter) {
            this.range = rangeInMeter;
            this.maxSegmentLength = this.range * 2.0 / 3.0;
            this.kdSearchRange = Math.sqrt(Math.pow(rangeInMeter, 2.0) + Math.pow(this.maxSegmentLength / 2.0, 2.0));
            this.build(roads);
        }

        public void build(List<MapRoad> roads) {
            for (MapRoad road : roads) {
                RoadPoint rp;
                List<Coord> points;
                if (road.isSkipHousenumberProcessing() || (points = road.getPoints()).size() < 2) continue;
                ArrayList<RoadPoint> roadPoints = new ArrayList<RoadPoint>();
                int i = 0;
                while (i + 1 < points.size()) {
                    double segLen;
                    double frac;
                    Coord c1 = points.get(i);
                    Coord c2 = points.get(i + 1);
                    int part = 0;
                    rp = new RoadPoint(road, c1, i, part++);
                    roadPoints.add(rp);
                    while (!((frac = this.maxSegmentLength / (segLen = c1.distance(c2))) >= 1.0)) {
                        c1 = c1.makeBetweenPoint(c2, frac);
                        rp = new RoadPoint(road, c1, i, part++);
                        roadPoints.add(rp);
                        segLen -= this.maxSegmentLength;
                    }
                    ++i;
                }
                int last = points.size() - 1;
                rp = new RoadPoint(road, points.get(last), last, -1);
                roadPoints.add(rp);
                Collections.shuffle(roadPoints);
                for (RoadPoint toAdd : roadPoints) {
                    int id = toAdd.p.getId();
                    if (id == 0) {
                        this.kdTree.add(toAdd);
                        continue;
                    }
                    Set<RoadPoint> set = this.nodeId2RoadPointMap.get(id);
                    if (set == null) {
                        set = new LinkedHashSet<RoadPoint>();
                        this.nodeId2RoadPointMap.put(id, set);
                        this.kdTree.add(toAdd);
                    }
                    set.add(toAdd);
                }
            }
        }

        public List<RoadPoint> getCLoseRoadPoints(HousenumberElem house) {
            Set<RoadPoint> closeRoadPoints = this.kdTree.findNextPoint(house, this.kdSearchRange);
            ArrayList<RoadPoint> result = new ArrayList<RoadPoint>();
            for (RoadPoint rp : closeRoadPoints) {
                int id = rp.p.getId();
                if (id != 0) {
                    result.addAll((Collection<RoadPoint>)this.nodeId2RoadPointMap.get(id));
                    continue;
                }
                result.add(rp);
            }
            return result;
        }

        public HousenumberMatch createHousenumberMatch(HousenumberElem house) {
            HousenumberMatch altHouse;
            HousenumberMatch closest = new HousenumberMatch(house);
            List<RoadPoint> closeRoadPoints = this.getCLoseRoadPoints(house);
            if (closeRoadPoints.isEmpty()) {
                return closest;
            }
            Collections.sort(closeRoadPoints, new Comparator<RoadPoint>(){

                @Override
                public int compare(RoadPoint o1, RoadPoint o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int d = Integer.compare(o1.r.getRoadId(), o2.r.getRoadId());
                    if (d != 0) {
                        return d;
                    }
                    d = Integer.compare(o1.segment, o2.segment);
                    if (d != 0) {
                        return d;
                    }
                    return Integer.compare(o1.partOfSeg, o2.partOfSeg);
                }
            });
            ArrayList<HousenumberMatch> matches = new ArrayList<HousenumberMatch>(40);
            BitSet testedSegments = new BitSet();
            MapRoad lastRoad = null;
            HousenumberMatch hnm = null;
            for (RoadPoint rp : closeRoadPoints) {
                if (house.getStreet() != null && rp.r.getStreet() != null && !house.getStreet().equalsIgnoreCase(rp.r.getStreet())) continue;
                if (rp.r != lastRoad) {
                    hnm = new HousenumberMatch(house);
                    testedSegments.clear();
                    matches.add(hnm);
                    lastRoad = rp.r;
                }
                double oldDist = hnm.getDistance();
                if (rp.partOfSeg >= 0 && !testedSegments.get(rp.segment)) {
                    testedSegments.set(rp.segment);
                    HousenumberGenerator.checkSegment(hnm, rp.r, rp.segment);
                }
                if (rp.partOfSeg < 0) {
                    if (rp.segment < 1) {
                        log.error("internal error: trying to use invalid roadPoint", rp);
                    } else if (!testedSegments.get(rp.segment - 1)) {
                        testedSegments.set(rp.segment - 1);
                        HousenumberGenerator.checkSegment(hnm, rp.r, rp.segment - 1);
                    }
                }
                if (oldDist != hnm.getDistance()) continue;
            }
            if (matches.isEmpty()) {
                return closest;
            }
            Collections.sort(matches, new HousenumberMatchByDistComparator());
            closest = (HousenumberMatch)matches.get(0);
            closest = HousenumberGenerator.checkAngle(closest, matches);
            closest.calcRoadSide();
            HousenumberMatch bestMatchingName = null;
            if (closest.getStreet() != null && closest.getStreet().equalsIgnoreCase(closest.getRoad().getStreet())) {
                bestMatchingName = closest;
            }
            Iterator i$ = matches.iterator();
            while (i$.hasNext() && !((altHouse = (HousenumberMatch)i$.next()).getDistance() >= 150.0)) {
                if (altHouse.getRoad() == closest.getRoad()) continue;
                if (house.getStreet() != null && altHouse.getDistance() > closest.getDistance()) {
                    if (house.getStreet().equalsIgnoreCase(altHouse.getRoad().getStreet())) {
                        if (bestMatchingName == null || bestMatchingName.getDistance() > altHouse.getDistance()) {
                            bestMatchingName = altHouse;
                        }
                    } else if (bestMatchingName != null && altHouse.getDistance() > bestMatchingName.getDistance()) continue;
                }
                closest.addAlternativeRoad(altHouse.getRoad());
            }
            if (bestMatchingName != null && !house.getStreet().equals(bestMatchingName.getRoad().getStreet())) {
                log.warn("accepting match in spite of different capitalisation", house.getStreet(), house.getSign(), bestMatchingName.getRoad().getRoadDef(), "house:", house.toBrowseURL());
                bestMatchingName.setStreet(bestMatchingName.getRoad().getStreet());
                closest.setStreet(bestMatchingName.getStreet());
            }
            if (closest == bestMatchingName || bestMatchingName == null || bestMatchingName.getDistance() > 150.0) {
                return closest;
            }
            double ratio = closest.getDistance() / bestMatchingName.getDistance();
            if (ratio < 0.25) {
                return closest;
            }
            HousenumberMatch best = closest;
            if (ratio > 0.75) {
                for (MapRoad r : closest.getAlternativeRoads()) {
                    if (!house.getStreet().equalsIgnoreCase(r.getStreet())) continue;
                    bestMatchingName.addAlternativeRoad(r);
                }
                best = bestMatchingName;
                best.calcRoadSide();
            } else if (log.isDebugEnabled()) {
                log.debug("further checks needed for address", closest.getStreet(), closest.getSign(), closest.toBrowseURL(), HousenumberGenerator.formatLen(closest.getDistance()), HousenumberGenerator.formatLen(bestMatchingName.getDistance()));
            }
            return best;
        }
    }

    private static class RoadPoint
    implements Locatable {
        final Coord p;
        final MapRoad r;
        final int segment;
        final int partOfSeg;

        public RoadPoint(MapRoad road, Coord co, int s, int part) {
            this.p = co;
            this.r = road;
            this.segment = s;
            this.partOfSeg = part;
        }

        @Override
        public Coord getLocation() {
            return this.p;
        }

        public String toString() {
            return this.r + " " + this.segment + " " + this.partOfSeg;
        }
    }

    public static class HousenumberMatchByDistComparator
    implements Comparator<HousenumberMatch> {
        @Override
        public int compare(HousenumberMatch o1, HousenumberMatch o2) {
            if (o1 == o2) {
                return 0;
            }
            int d = Double.compare(o1.getDistance(), o2.getDistance());
            if (d != 0) {
                return d;
            }
            d = Integer.compare(o1.getSegment(), o2.getSegment());
            if (d != 0) {
                return d;
            }
            d = Integer.compare(o1.getRoad().getRoadId(), o2.getRoad().getRoadId());
            if (d != 0) {
                return d;
            }
            return 0;
        }
    }

    public static class HousenumberMatchByNumComparator
    implements Comparator<HousenumberMatch> {
        @Override
        public int compare(HousenumberMatch o1, HousenumberMatch o2) {
            if (o1 == o2) {
                return 0;
            }
            int d = o1.getHousenumber() - o2.getHousenumber();
            if (d != 0) {
                return d;
            }
            d = o1.getSign().compareTo(o2.getSign());
            if (d != 0) {
                return d;
            }
            d = o1.getSegment() - o2.getSegment();
            if (d != 0) {
                return d;
            }
            double dDist = o1.getDistance() - o2.getDistance();
            if (dDist != 0.0) {
                return (int)Math.signum(dDist);
            }
            if (d != 0) {
                return d;
            }
            d = Long.compare(o1.getElement().getId(), o2.getElement().getId());
            return d;
        }
    }

    public static class HousenumberMatchByPosComparator
    implements Comparator<HousenumberMatch> {
        @Override
        public int compare(HousenumberMatch o1, HousenumberMatch o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getRoad() == null || o2.getRoad() == null) {
                log.error("road is null in sort comparator", o1, o2);
                throw new MapFailedException("internal error in housenumber processing");
            }
            if (o1.getRoad() != o2.getRoad()) {
                return o1.getRoad().getRoadId() - o2.getRoad().getRoadId();
            }
            int dSegment = o1.getSegment() - o2.getSegment();
            if (dSegment != 0) {
                return dSegment;
            }
            double dFrac = o1.getSegmentFrac() - o2.getSegmentFrac();
            if (dFrac != 0.0) {
                return (int)Math.signum(dFrac);
            }
            int d = o1.getHousenumber() - o2.getHousenumber();
            if (d != 0) {
                return d;
            }
            d = o1.getSign().compareTo(o2.getSign());
            if (d != 0) {
                return d;
            }
            return 0;
        }
    }
}

