/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.Locator;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmConverter;
import uk.me.parabola.mkgmap.reader.osm.Relation;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryRelation;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundarySaver;
import uk.me.parabola.util.EnhancedProperties;

public class BoundaryElementSaver
extends ElementSaver {
    private static final Logger log = Logger.getLogger(BoundaryElementSaver.class);
    private static final Locator locator = new Locator();
    private final BoundarySaver saver;

    public BoundaryElementSaver(EnhancedProperties args, BoundarySaver saver) {
        super(args);
        this.saver = saver;
    }

    public static boolean isBoundary(Element element) {
        if (element instanceof Relation) {
            String type = element.getTag("type");
            if ("boundary".equals(type) || "multipolygon".equals(type)) {
                String boundaryVal = element.getTag("boundary");
                if ("administrative".equals(boundaryVal)) {
                    if (element.getTag("admin_level") == null) {
                        return false;
                    }
                    if (element.getTag("admin_level").equals("2")) {
                        Tags copyTags = new Tags();
                        for (Map.Entry<String, String> tag : element.getTagEntryIterator()) {
                            copyTags.put(tag.getKey(), tag.getValue());
                        }
                        String iso = locator.getCountryISOCode(copyTags);
                        if (iso == null) {
                            log.warn("Ignore admin_level 2 element:", element.toBrowseURL(), element.toTagString());
                            return false;
                        }
                    }
                    for (Map.Entry<String, String> tag : element.getTagEntryIterator()) {
                        if (!tag.getKey().contains("name")) continue;
                        return true;
                    }
                    return false;
                }
                if ("postal_code".equals(boundaryVal)) {
                    if (element.getTag("postal_code") != null) {
                        return true;
                    }
                    for (Map.Entry<String, String> tag : element.getTagEntryIterator()) {
                        if (!tag.getKey().contains("name")) continue;
                        return true;
                    }
                    return false;
                }
                return element.getTag("postal_code") != null;
            }
            return false;
        }
        if (element instanceof Way) {
            Way w = (Way)element;
            if (!w.isClosedInOSM()) {
                return false;
            }
            String boundaryVal = element.getTag("boundary");
            if ("administrative".equals(boundaryVal)) {
                if (element.getTag("admin_level") == null) {
                    return false;
                }
                if (element.getTag("admin_level").equals("2")) {
                    Tags copyTags = new Tags();
                    for (Map.Entry<String, String> tag : element.getTagEntryIterator()) {
                        copyTags.put(tag.getKey(), tag.getValue());
                    }
                    String iso = locator.getCountryISOCode(copyTags);
                    if (iso == null) {
                        log.warn("Ignore admin_level 2 element:", element.toBrowseURL(), element.toTagString());
                        return false;
                    }
                }
                for (Map.Entry<String, String> tag : element.getTagEntryIterator()) {
                    if (!tag.getKey().contains("name")) continue;
                    return true;
                }
                return false;
            }
            if ("postal_code".equals(boundaryVal)) {
                return element.getTag("name") != null;
            }
            return element.getTag("postal_code") != null;
        }
        return false;
    }

    @Override
    public void addRelation(Relation rel) {
        if (BoundaryElementSaver.isBoundary(rel)) {
            BoundaryRelation bRel = (BoundaryRelation)this.createMultiPolyRelation(rel);
            bRel.processElements();
            Boundary b = bRel.getBoundary();
            if (b != null) {
                this.saver.addBoundary(b);
            }
        } else {
            log.warn("Relation is not processed due to missing tags:", rel.getId(), rel.toTagString());
        }
    }

    @Override
    public void deferRelation(long id, Relation rel, String role) {
    }

    @Override
    public Relation createMultiPolyRelation(Relation rel) {
        return new BoundaryRelation(rel, this.wayMap, this.getBoundingBox());
    }

    @Override
    public void addNode(Node node) {
    }

    @Override
    public void convert(OsmConverter converter) {
        this.nodeMap = null;
        converter.setBoundingBox(this.getBoundingBox());
        ArrayList relations = new ArrayList(this.relationMap.values());
        this.relationMap = null;
        Collections.reverse(relations);
        for (int i = relations.size() - 1; i >= 0; --i) {
            converter.convertRelation((Relation)relations.get(i));
            relations.remove(i);
        }
        for (Way w : this.wayMap.values()) {
            converter.convertWay(w);
        }
        this.wayMap = null;
        converter.end();
        this.relationMap = null;
    }
}

