/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.me.parabola.imgfmt.FormatException;
import uk.me.parabola.mkgmap.reader.osm.OsmMapDataSource;
import uk.me.parabola.mkgmap.reader.osm.xml.Osm5XmlHandler;

public class Osm5MapDataSource
extends OsmMapDataSource {
    @Override
    public boolean isFileSupported(String name) {
        return true;
    }

    @Override
    public void load(InputStream is) throws FormatException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setXIncludeAware(true);
            parserFactory.setNamespaceAware(true);
            SAXParser parser = parserFactory.newSAXParser();
            try {
                Osm5XmlHandler handler = new Osm5XmlHandler(this.getConfig());
                Osm5XmlHandler.SaxHandler saxHandler = new Osm5XmlHandler.SaxHandler(handler);
                this.setupHandler(handler);
                handler = null;
                parser.parse(is, (DefaultHandler)saxHandler);
                this.elementSaver.finishLoading();
                this.osmReadingHooks.end();
                this.osmReadingHooks = null;
                this.elementSaver.convert(this.getConverter());
                this.addBackground();
            }
            catch (IOException e) {
                throw new FormatException("Error reading file", e);
            }
        }
        catch (SAXException e) {
            throw new FormatException("Error parsing file", e);
        }
        catch (ParserConfigurationException e) {
            throw new FormatException("Internal error configuring xml parser", e);
        }
    }
}

