/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.test;

import java.util.ArrayList;
import java.util.Properties;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.mkgmap.general.MapCollector;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;

class TestPoints {
    private static final double ELEMENT_SPACING = 0.02;
    private Properties props;
    private static final double ELEMENT_SIZE = 0.002;

    TestPoints() {
    }

    public void load(MapCollector mapper, Properties in) {
        this.props = in;
        double baseLat = 51.7;
        String sBaseLat = System.getenv("BASE_LAT");
        String sBaseLong = System.getenv("BASE_LONG");
        if (sBaseLat != null) {
            baseLat = Double.valueOf(sBaseLat);
        }
        double baseLong = 0.24;
        if (sBaseLong != null) {
            baseLong = Double.valueOf(sBaseLong);
        }
        this.drawTestMap(mapper, baseLat, baseLong);
    }

    private void drawTestMap(MapCollector mapper, double startLat, double startLong) {
        int y;
        int x;
        String s = this.props.getProperty("npoints");
        int npoints = 10;
        if (s != null) {
            npoints = Integer.valueOf(s);
        }
        for (x = 0; x < npoints; ++x) {
            for (y = 0; y < npoints; ++y) {
                MapPoint point = new MapPoint();
                double baseLat = startLat + (double)y * 0.02;
                double baseLong = startLong + (double)x * 0.02;
                point.setMinResolution(24 - (x & 7));
                point.setName("P " + (x * npoints + y));
                point.setLocation(new Coord(baseLat, baseLong));
                point.setType(11264 + (y & 0xF));
                mapper.addPoint(point);
                mapper.addToBounds(point.getLocation());
            }
        }
        for (x = 0; x < npoints; ++x) {
            for (y = 0; y < npoints; ++y) {
                int type = x * 16 + y;
                MapLine line = new MapLine();
                line.setMinResolution(10);
                line.setName("0x" + Integer.toHexString(type &= 0xF));
                double baseLat = startLat + (double)y * 0.02;
                double baseLong = startLong + (double)x * 0.02;
                ArrayList<Coord> coords = new ArrayList<Coord>();
                for (int i = 0; i < 5; ++i) {
                    Coord co = new Coord(baseLat + (double)i * 0.002, baseLong + (double)i * 0.002);
                    coords.add(co);
                    mapper.addToBounds(co);
                }
                line.setType(type);
                line.setPoints(coords);
                mapper.addLine(line);
            }
        }
    }
}

