/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.labelenc;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Locale;
import uk.me.parabola.imgfmt.app.labelenc.BaseEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;
import uk.me.parabola.imgfmt.app.labelenc.Transliterator;

public class AnyCharsetEncoder
extends BaseEncoder
implements CharacterEncoder {
    private final CharsetEncoder encoder;
    private final Transliterator transliterator;

    public AnyCharsetEncoder(String cs, Transliterator transliterator) {
        this.transliterator = transliterator;
        this.prepareForCharacterSet(cs);
        if (this.isCharsetSupported()) {
            this.encoder = Charset.forName(cs).newEncoder();
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        } else {
            this.encoder = null;
        }
    }

    @Override
    public EncodedText encodeText(String text) {
        int i;
        CoderResult result;
        if (text == null || text.isEmpty()) {
            return NO_TEXT;
        }
        if (!this.isCharsetSupported()) {
            return this.simpleEncode(text);
        }
        String ucText = this.isUpperCase() ? text.toUpperCase(Locale.ENGLISH) : text;
        ByteBuffer outBuf = ByteBuffer.allocate(ucText.length() + 20);
        CharBuffer charBuffer = CharBuffer.wrap(ucText);
        do {
            if ((result = this.encoder.encode(charBuffer, outBuf, true)).isUnmappable()) {
                String s;
                if (result.length() == 1) {
                    s = String.valueOf(charBuffer.get());
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (i = 0; i < result.length(); ++i) {
                        sb.append(charBuffer.get());
                    }
                    s = sb.toString();
                }
                s = this.transliterator.transliterate(s);
                while (outBuf.limit() < outBuf.position() + s.length()) {
                    outBuf = this.reallocBuf(outBuf);
                }
                for (int i2 = 0; i2 < s.length(); ++i2) {
                    outBuf.put((byte)s.charAt(i2));
                }
            } else {
                if (result != CoderResult.OVERFLOW) continue;
                outBuf = this.reallocBuf(outBuf);
            }
        } while (result != CoderResult.UNDERFLOW);
        byte[] res = Arrays.copyOf(outBuf.array(), outBuf.position() + 1);
        char[] cres = new char[res.length];
        for (i = 0; i < res.length; ++i) {
            cres[i] = (char)(res[i] & 0xFF);
        }
        return new EncodedText(res, res.length, cres);
    }

    private ByteBuffer reallocBuf(ByteBuffer bb) {
        byte[] newbuf = Arrays.copyOf(bb.array(), bb.capacity() * 2);
        return ByteBuffer.wrap(newbuf, bb.position(), newbuf.length - bb.position());
    }

    @Override
    public void setUpperCase(boolean upperCase) {
        super.setUpperCase(upperCase);
        this.transliterator.forceUppercase(upperCase);
    }
}

