/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.lbl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import uk.me.parabola.imgfmt.app.Exit;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.ExitFacility;
import uk.me.parabola.imgfmt.app.lbl.Highway;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.lbl.POIIndex;
import uk.me.parabola.imgfmt.app.lbl.POIRecord;
import uk.me.parabola.imgfmt.app.lbl.PlacesHeader;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.srt.CombinedSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;

public class PlacesFile {
    private final Map<String, Country> countries = new LinkedHashMap<String, Country>();
    private final List<Country> countryList = new ArrayList<Country>();
    private final Map<String, Region> regions = new LinkedHashMap<String, Region>();
    private final List<Region> regionList = new ArrayList<Region>();
    private final Map<String, City> cities = new LinkedHashMap<String, City>();
    private final List<City> cityList = new ArrayList<City>();
    private final Map<String, Zip> postalCodes = new LinkedHashMap<String, Zip>();
    private final List<Zip> zipList = new ArrayList<Zip>();
    private final List<Highway> highways = new ArrayList<Highway>();
    private final List<ExitFacility> exitFacilities = new ArrayList<ExitFacility>();
    private final List<POIRecord> pois = new ArrayList<POIRecord>();
    private final List[] poiIndex = new ArrayList[256];
    private LBLFile lblFile;
    private PlacesHeader placeHeader;
    private boolean poisClosed;
    private Sort sort;
    private final Random random = new Random();

    void init(LBLFile file, PlacesHeader pheader) {
        this.lblFile = file;
        this.placeHeader = pheader;
    }

    void write(ImgFileWriter writer) {
        for (Country c : this.countryList) {
            c.write(writer);
        }
        this.placeHeader.endCountries(writer.position());
        for (Region region : this.regionList) {
            region.write(writer);
        }
        this.placeHeader.endRegions(writer.position());
        for (City sc : this.cityList) {
            sc.write(writer);
        }
        this.placeHeader.endCity(writer.position());
        for (List pil : this.poiIndex) {
            if (pil == null) continue;
            ArrayList<SortKey<POIIndex>> sorted = new ArrayList<SortKey<POIIndex>>();
            for (POIIndex pOIIndex : pil) {
                SortKey<POIIndex> sortKey = this.sort.createSortKey(pOIIndex, pOIIndex.getName());
                sorted.add(sortKey);
            }
            Collections.sort(sorted);
            for (SortKey sortKey : sorted) {
                ((POIIndex)sortKey.getObject()).write(writer);
            }
        }
        this.placeHeader.endPOIIndex(writer.position());
        int poistart = writer.position();
        byte poiglobalflags = this.placeHeader.getPOIGlobalFlags();
        for (POIRecord p : this.pois) {
            p.write(writer, poiglobalflags, writer.position() - poistart, this.cityList.size(), this.postalCodes.size(), this.highways.size(), this.exitFacilities.size());
        }
        this.placeHeader.endPOI(writer.position());
        int numPoiIndexEntries = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.poiIndex[i] == null) continue;
            writer.put((byte)i);
            writer.put3(numPoiIndexEntries + 1);
            numPoiIndexEntries += this.poiIndex[i].size();
        }
        this.placeHeader.endPOITypeIndex(writer.position());
        for (Zip z : this.zipList) {
            z.write(writer);
        }
        this.placeHeader.endZip(writer.position());
        int extraHighwayDataOffset = 0;
        for (Highway h : this.highways) {
            h.setExtraDataOffset(extraHighwayDataOffset);
            extraHighwayDataOffset += h.getExtraDataSize();
            h.write(writer, false);
        }
        this.placeHeader.endHighway(writer.position());
        for (ExitFacility ef : this.exitFacilities) {
            ef.write(writer);
        }
        this.placeHeader.endExitFacility(writer.position());
        for (Highway h : this.highways) {
            h.write(writer, true);
        }
        this.placeHeader.endHighwayData(writer.position());
    }

    Country createCountry(String name, String abbr) {
        String s = abbr != null ? name + '\u001d' + abbr : name;
        Country c = this.countries.get(s);
        if (c == null) {
            c = new Country(this.countries.size() + 1);
            Label l = this.lblFile.newLabel(s);
            c.setLabel(l);
            this.countries.put(s, c);
        }
        return c;
    }

    Region createRegion(Country country, String name, String abbr) {
        String s = abbr != null ? name + '\u001d' + abbr : name;
        String uniqueRegionName = s.toUpperCase() + "_C" + country.getLabel().getOffset();
        Region r = this.regions.get(uniqueRegionName);
        if (r == null) {
            r = new Region(country);
            Label l = this.lblFile.newLabel(s);
            r.setLabel(l);
            this.regionList.add(r);
            this.regions.put(uniqueRegionName, r);
        }
        return r;
    }

    City createCity(Country country, String name, boolean unique) {
        String uniqueCityName = name.toUpperCase() + "_C" + country.getLabel().getOffset();
        if (unique && this.cities.get(uniqueCityName) != null) {
            while (this.cities.get(uniqueCityName = uniqueCityName + "_" + new Random().nextInt(65536)) != null) {
            }
        }
        City c = null;
        if (!unique) {
            c = this.cities.get(uniqueCityName);
        }
        if (c == null) {
            c = new City(country);
            Label l = this.lblFile.newLabel(name);
            c.setLabel(l);
            this.cityList.add(c);
            this.cities.put(uniqueCityName, c);
            assert (this.cityList.size() == this.cities.size()) : " cityList and cities are different lengths after inserting " + name + " and " + uniqueCityName;
        }
        return c;
    }

    City createCity(Region region, String name, boolean unique) {
        String uniqueCityName = name.toUpperCase() + "_R" + region.getLabel().getOffset();
        if (unique && this.cities.get(uniqueCityName) != null) {
            while (this.cities.get(uniqueCityName = uniqueCityName + "_" + this.random.nextInt(65536)) != null) {
            }
        }
        City c = null;
        if (!unique) {
            c = this.cities.get(uniqueCityName);
        }
        if (c == null) {
            c = new City(region);
            Label l = this.lblFile.newLabel(name);
            c.setLabel(l);
            this.cityList.add(c);
            this.cities.put(uniqueCityName, c);
            assert (this.cityList.size() == this.cities.size()) : " cityList and cities are different lengths after inserting " + name + " and " + uniqueCityName;
        }
        return c;
    }

    Zip createZip(String code) {
        Zip z = this.postalCodes.get(code);
        if (z == null) {
            z = new Zip();
            Label l = this.lblFile.newLabel(code);
            z.setLabel(l);
            this.zipList.add(z);
            this.postalCodes.put(code, z);
        }
        return z;
    }

    Highway createHighway(Region region, String name) {
        Highway h = new Highway(region, this.highways.size() + 1);
        Label l = this.lblFile.newLabel(name);
        h.setLabel(l);
        this.highways.add(h);
        return h;
    }

    public ExitFacility createExitFacility(int type, char direction, int facilities, String description, boolean last) {
        Label d = this.lblFile.newLabel(description);
        ExitFacility ef = new ExitFacility(type, direction, facilities, d, last, this.exitFacilities.size() + 1);
        this.exitFacilities.add(ef);
        return ef;
    }

    POIRecord createPOI(String name) {
        assert (!this.poisClosed);
        POIRecord p = new POIRecord();
        Label l = this.lblFile.newLabel(name);
        p.setLabel(l);
        this.pois.add(p);
        return p;
    }

    POIRecord createExitPOI(String name, Exit exit) {
        assert (!this.poisClosed);
        POIRecord p = new POIRecord();
        Label l = this.lblFile.newLabel(name);
        p.setLabel(l);
        p.setExit(exit);
        this.pois.add(p);
        return p;
    }

    POIIndex createPOIIndex(String name, int index, Subdivision group, int type) {
        assert (index < 256) : "Too many POIS in division";
        POIIndex pi = new POIIndex(name, (byte)index, group, (byte)type);
        int t = type >> 8;
        if (this.poiIndex[t] == null) {
            this.poiIndex[t] = new ArrayList();
        }
        this.poiIndex[t].add(pi);
        return pi;
    }

    void allPOIsDone() {
        this.sortCountries();
        this.sortRegions();
        this.sortCities();
        this.sortZips();
        this.poisClosed = true;
        byte poiFlags = 0;
        for (POIRecord p : this.pois) {
            poiFlags = (byte)(poiFlags | p.getPOIFlags());
        }
        this.placeHeader.setPOIGlobalFlags(poiFlags);
        int ofs = 0;
        for (POIRecord p : this.pois) {
            ofs += p.calcOffset(ofs, poiFlags, this.cityList.size(), this.postalCodes.size(), this.highways.size(), this.exitFacilities.size());
        }
    }

    private void sortCountries() {
        ArrayList<SortKey> keys = new ArrayList<SortKey>();
        for (Country c : this.countries.values()) {
            SortKey key = this.sort.createSortKey(c, c.getLabel());
            keys.add(key);
        }
        Collections.sort(keys);
        this.countryList.clear();
        int index = 1;
        for (SortKey key : keys) {
            Country c = (Country)key.getObject();
            c.setIndex(index++);
            this.countryList.add(c);
        }
    }

    private void sortRegions() {
        ArrayList<SortKey> keys = new ArrayList<SortKey>();
        for (Region r : this.regionList) {
            SortKey key = this.sort.createSortKey(r, r.getLabel(), (int)r.getCountry().getIndex());
            keys.add(key);
        }
        Collections.sort(keys);
        this.regionList.clear();
        int index = 1;
        for (SortKey key : keys) {
            Region r = (Region)key.getObject();
            r.setIndex(index++);
            this.regionList.add(r);
        }
    }

    private void sortCities() {
        ArrayList<CombinedSortKey<City>> keys = new ArrayList<CombinedSortKey<City>>();
        for (City c : this.cityList) {
            SortKey<City> sortKey = this.sort.createSortKey(c, c.getLabel());
            CombinedSortKey<City> combinedSortKey = new CombinedSortKey<City>(sortKey, c.getRegionNumber(), c.getCountryNumber());
            keys.add(combinedSortKey);
        }
        Collections.sort(keys);
        this.cityList.clear();
        int index = 1;
        for (SortKey sortKey : keys) {
            City city = (City)sortKey.getObject();
            city.setIndex(index++);
            this.cityList.add(city);
        }
    }

    private void sortZips() {
        ArrayList<SortKey<Zip>> keys = new ArrayList<SortKey<Zip>>();
        for (Zip c : this.postalCodes.values()) {
            SortKey<Zip> sortKey = this.sort.createSortKey(c, c.getLabel());
            keys.add(sortKey);
        }
        Collections.sort(keys);
        this.zipList.clear();
        int index = 1;
        for (SortKey sortKey : keys) {
            Zip zip = (Zip)sortKey.getObject();
            zip.setIndex(index++);
            this.zipList.add(zip);
        }
    }

    public int numCities() {
        return this.cityList.size();
    }

    public int numZips() {
        return this.postalCodes.size();
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }
}

