/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.map;

import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.net.NETFile;
import uk.me.parabola.imgfmt.app.net.NODFile;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.InternalFiles;
import uk.me.parabola.imgfmt.app.trergn.MapObject;
import uk.me.parabola.imgfmt.app.trergn.PointOverview;
import uk.me.parabola.imgfmt.app.trergn.PolygonOverview;
import uk.me.parabola.imgfmt.app.trergn.PolylineOverview;
import uk.me.parabola.imgfmt.app.trergn.RGNFile;
import uk.me.parabola.imgfmt.app.trergn.Subdivision;
import uk.me.parabola.imgfmt.app.trergn.TREFile;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.imgfmt.fs.FileSystem;
import uk.me.parabola.imgfmt.sys.ImgFS;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.combiners.OverviewBuilder;
import uk.me.parabola.util.Configurable;
import uk.me.parabola.util.EnhancedProperties;

public class Map
implements InternalFiles,
Configurable {
    private static final Logger log = Logger.getLogger(Map.class);
    private String filename;
    private String mapName;
    private FileSystem fileSystem;
    private TREFile treFile;
    private RGNFile rgnFile;
    private LBLFile lblFile;
    private NETFile netFile;
    private NODFile nodFile;

    private Map() {
    }

    public static Map createMap(String mapname, String outputdir, FileSystemParam params, String mapnumber, Sort sort) throws FileExistsException, FileNotWritableException {
        int mapid;
        Map m = new Map();
        m.mapName = mapname;
        String outFilename = Utils.joinPath(outputdir, mapname, "img");
        FileSystem fs = ImgFS.createFs(outFilename, params);
        m.filename = outFilename;
        m.fileSystem = fs;
        m.rgnFile = new RGNFile(m.fileSystem.create(mapnumber + ".RGN"));
        m.treFile = new TREFile(m.fileSystem.create(mapnumber + ".TRE"));
        m.lblFile = new LBLFile(m.fileSystem.create(mapnumber + ".LBL"), sort);
        try {
            mapid = Integer.parseInt(mapnumber);
        }
        catch (NumberFormatException e) {
            mapid = 0;
        }
        m.treFile.setMapId(mapid);
        m.fileSystem = fs;
        return m;
    }

    @Override
    public void config(EnhancedProperties props) {
        if (!OverviewBuilder.isOverviewImg(this.mapName)) {
            try {
                if (props.containsKey("route")) {
                    this.addNet();
                    this.addNod();
                } else if (props.containsKey("net")) {
                    this.addNet();
                }
            }
            catch (FileExistsException e) {
                log.warn((Object)"Could not add NET and/or NOD sections");
            }
        }
        this.treFile.config(props);
    }

    protected void addNet() throws FileExistsException {
        this.netFile = new NETFile(this.fileSystem.create(this.mapName + ".NET"));
    }

    protected void addNod() throws FileExistsException {
        this.nodFile = new NODFile(this.fileSystem.create(this.mapName + ".NOD"), true);
    }

    public void setBounds(Area area) {
        this.treFile.setBounds(area);
    }

    public void addCopyright(String str) {
        Label cpy = this.lblFile.newLabel(str);
        this.treFile.addCopyright(cpy);
    }

    public void addInfo(String info) {
        this.treFile.addInfo(info);
    }

    public Zoom createZoom(int level, int bits) {
        return this.treFile.createZoom(level, bits);
    }

    public Subdivision topLevelSubdivision(Area area, Zoom zoom) {
        zoom.setInherited(true);
        Map ifiles = this;
        Subdivision sub = Subdivision.topLevelSubdivision(ifiles, area, zoom);
        this.rgnFile.startDivision(sub);
        return sub;
    }

    public Subdivision createSubdivision(Subdivision parent, Area area, Zoom zoom) {
        log.debug((Object)"creating division");
        return parent.createSubdivision(this, area, zoom);
    }

    public void addPointOverview(PointOverview ov) {
        this.treFile.addPointOverview(ov);
    }

    public void addPolylineOverview(PolylineOverview ov) {
        this.treFile.addPolylineOverview(ov);
    }

    public void addPolygonOverview(PolygonOverview ov) {
        this.treFile.addPolygonOverview(ov);
    }

    public void addPoiDisplayFlags(int flags) {
        this.treFile.addPoiDisplayFlags((byte)flags);
    }

    public void addMapObject(MapObject item) {
        this.rgnFile.addMapObject(item);
    }

    public void setSort(Sort sort) {
        this.lblFile.setSort(sort);
        if (this.netFile != null) {
            this.netFile.setSort(sort);
        }
    }

    public void setLabelCharset(String desc, boolean forceUpper) {
        this.lblFile.setCharacterType(desc, forceUpper);
    }

    public void close() {
        ImgFile[] files = new ImgFile[]{this.rgnFile, this.treFile, this.lblFile, this.netFile, this.nodFile};
        int headerSlotsRequired = 0;
        FileSystemParam param = this.fileSystem.fsparam();
        int blockSize = param.getBlockSize();
        for (ImgFile f : files) {
            if (f == null) continue;
            long len = f.getSize();
            log.debug("img file len=", len);
            int nBlocks = (int)((len + (long)blockSize - 1L) / (long)blockSize);
            headerSlotsRequired += (nBlocks + 240 - 1) / 240;
        }
        log.debug("header slots required", headerSlotsRequired);
        int blocksRequired = 2 + headerSlotsRequired * 512 / blockSize;
        param.setReservedDirectoryBlocks(blocksRequired);
        this.fileSystem.fsparam(param);
        for (ImgFile f : files) {
            Utils.closeFile(f);
        }
        this.fileSystem.close();
    }

    public String getFilename() {
        return this.filename;
    }

    @Override
    public RGNFile getRgnFile() {
        return this.rgnFile;
    }

    @Override
    public LBLFile getLblFile() {
        return this.lblFile;
    }

    @Override
    public TREFile getTreFile() {
        return this.treFile;
    }

    @Override
    public NETFile getNetFile() {
        return this.netFile;
    }

    @Override
    public NODFile getNodFile() {
        return this.nodFile;
    }
}

