/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.Mdr10;
import uk.me.parabola.imgfmt.app.mdr.Mdr11Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr12Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr8Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;
import uk.me.parabola.imgfmt.app.srt.SortKey;
import uk.me.parabola.imgfmt.app.trergn.Point;

public class Mdr11
extends MdrMapSection {
    private List<Mdr11Record> pois = new ArrayList<Mdr11Record>();
    private Mdr10 mdr10;

    public Mdr11(MdrConfig config) {
        this.setConfig(config);
    }

    public Mdr11Record addPoi(int mapIndex, Point point, String name, int strOff) {
        Mdr11Record poi = new Mdr11Record();
        poi.setMapIndex(mapIndex);
        poi.setPointIndex(point.getNumber());
        poi.setSubdiv(point.getSubdiv().getNumber());
        poi.setLblOffset(point.getLabel().getOffset());
        poi.setName(name);
        poi.setStrOffset(strOff);
        this.pois.add(poi);
        return poi;
    }

    @Override
    protected void preWriteImpl() {
        List<SortKey<Mdr11Record>> keys = MdrUtils.sortList(this.getConfig().getSort(), this.pois);
        this.pois.clear();
        for (SortKey<Mdr11Record> sk : keys) {
            Mdr11Record poi = sk.getObject();
            this.mdr10.addPoiType(poi);
            this.pois.add(poi);
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int count = 1;
        boolean hasStrings = this.hasFlag(2);
        for (Mdr11Record poi : this.pois) {
            this.addIndexPointer(poi.getMapIndex(), count);
            poi.setRecordNumber(count++);
            this.putMapIndex(writer, poi.getMapIndex());
            writer.put((byte)poi.getPointIndex());
            writer.putChar((char)poi.getSubdiv());
            writer.put3(poi.getLblOffset());
            if (poi.isCity()) {
                this.putRegionIndex(writer, poi.getRegionIndex());
            } else {
                this.putCityIndex(writer, poi.getCityIndex(), true);
            }
            if (!hasStrings) continue;
            this.putStringOffset(writer, poi.getStrOffset());
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getMapSize() + 6 + sizes.getCitySizeFlagged();
        if (this.hasFlag(2)) {
            size += sizes.getStrOffSize();
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.pois.size();
    }

    public int getNumberOfPois() {
        return this.getNumberOfItems();
    }

    @Override
    public int getExtraValue() {
        int mdr11flags = 17;
        MdrSection.PointerSizes sizes = this.getSizes();
        int citySize = sizes.getCitySizeFlagged();
        if (citySize > 2) {
            mdr11flags |= citySize - 2 << 2;
        }
        mdr11flags = this.isForDevice() ? (mdr11flags |= 0x80) : (mdr11flags |= 2);
        return mdr11flags;
    }

    public List<Mdr8Record> getIndex() {
        ArrayList<Mdr8Record> list = new ArrayList<Mdr8Record>();
        for (int number = 1; number <= this.pois.size(); number += 10240) {
            int rec;
            String prefix = this.getPrefixForRecord(number);
            for (rec = number; rec > 1; --rec) {
                String p = this.getPrefixForRecord(rec);
                if (p.equals(prefix)) continue;
                ++rec;
                break;
            }
            Mdr12Record indexRecord = new Mdr12Record();
            indexRecord.setPrefix(prefix);
            indexRecord.setRecordNumber(rec);
            list.add(indexRecord);
        }
        return list;
    }

    private String getPrefixForRecord(int number) {
        int endIndex = 4;
        Mdr11Record record = this.pois.get(number - 1);
        String name = record.getName();
        if (endIndex > name.length()) {
            StringBuilder sb = new StringBuilder(name);
            while (sb.length() < endIndex) {
                sb.append('\u0000');
            }
            name = sb.toString();
        }
        return name.substring(0, endIndex);
    }

    public void setMdr10(Mdr10 mdr10) {
        this.mdr10 = mdr10;
    }

    @Override
    public void releaseMemory() {
        this.pois = null;
        this.mdr10 = null;
    }

    public List<Mdr11Record> getPois() {
        return new ArrayList<Mdr11Record>(this.pois);
    }

    @Override
    public void relabelMaps(Mdr1 maps) {
        this.relabel(maps, this.pois);
    }
}

