/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.nio.ByteBuffer;
import uk.me.parabola.imgfmt.app.BufferedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr1SubHeader;

public class Mdr1MapIndex {
    private final Mdr1SubHeader subHeader = new Mdr1SubHeader();
    private final BufferedImgFileWriter subWriter = new BufferedImgFileWriter(null);
    private int pointerSize;

    public Mdr1MapIndex() {
        this.subWriter.position(this.subHeader.getHeaderLen());
    }

    public void startSection(int n) {
    }

    public void endSection(int n) {
        int sn = this.sectionToSubsection(n);
        if (sn != 0) {
            this.subHeader.setEndSubsection(sn, this.subWriter.position());
        }
    }

    public void addPointer(int recordNumber) {
        switch (this.pointerSize) {
            case 4: {
                this.subWriter.putInt(recordNumber);
                break;
            }
            case 3: {
                this.subWriter.put3(recordNumber);
                break;
            }
            case 2: {
                this.subWriter.putChar((char)recordNumber);
                break;
            }
            case 1: {
                this.subWriter.put((byte)recordNumber);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private int sectionToSubsection(int n) {
        int sn;
        switch (n) {
            case 11: {
                sn = 1;
                break;
            }
            case 10: {
                sn = 2;
                break;
            }
            case 7: {
                sn = 3;
                break;
            }
            case 5: {
                sn = 4;
                break;
            }
            case 6: {
                sn = 5;
                break;
            }
            case 20: {
                sn = 6;
                break;
            }
            case 21: {
                sn = 7;
                break;
            }
            case 22: {
                sn = 8;
                break;
            }
            default: {
                sn = 0;
            }
        }
        return sn;
    }

    public void writeSubSection(ImgFileWriter writer) {
        this.subHeader.writeFileHeader(writer);
        ByteBuffer buffer = this.subWriter.getBuffer();
        byte[] bytes = buffer.array();
        int hl = (int)this.subHeader.getHeaderLen();
        writer.put(bytes, hl, buffer.position() - hl);
    }

    public void setPointerSize(int sectionNumber, int pointerSize) {
        this.pointerSize = pointerSize;
        int sn = this.sectionToSubsection(sectionNumber);
        if (sn != 0) {
            this.subHeader.setItemSize(sn, pointerSize);
        }
    }
}

