/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr29Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr2x;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr22
extends Mdr2x {
    public Mdr22(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromStreets(List<Mdr7Record> inStreets) {
        Sort sort = this.getConfig().getSort();
        ArrayList<SortKey<Mdr7Record>> keys = new ArrayList<SortKey<Mdr7Record>>();
        HashMap<String, byte[]> cache = new HashMap<String, byte[]>();
        for (Mdr7Record s : inStreets) {
            Mdr5Record city = s.getCity();
            if (city == null) continue;
            String name = city.getMdrCountry().getName();
            assert (name != null);
            keys.add(sort.createSortKey(s, name, s.getIndex(), cache));
        }
        Collections.sort(keys);
        int record = 0;
        String lastName = null;
        int lastMapid = 0;
        for (SortKey sortKey : keys) {
            Mdr7Record street = (Mdr7Record)sortKey.getObject();
            String name = street.getName();
            int mapid = street.getMapIndex();
            if (mapid == lastMapid && name.equals(lastName)) continue;
            ++record;
            this.streets.add(street);
            Mdr14Record mdrCountry = street.getCity().getMdrCountry();
            if (mdrCountry != null) {
                Mdr29Record mdr29 = mdrCountry.getMdr29();
                mdr29.setMdr22(record);
            }
            lastMapid = mapid;
            lastName = name;
        }
    }

    @Override
    protected boolean sameGroup(Mdr7Record street1, Mdr7Record street2) {
        return true;
    }

    public List<Mdr7Record> getStreets() {
        return Collections.unmodifiableList(this.streets);
    }

    @Override
    public int getExtraValue() {
        if (this.isForDevice()) {
            return 24590;
        }
        return 69632;
    }
}

