/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr29Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr29
extends MdrSection
implements HasHeaderFlags {
    private final List<Mdr29Record> index = new ArrayList<Mdr29Record>();
    private int max17;

    public Mdr29(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromCountries(List<Mdr14Record> countries) {
        Sort sort = this.getConfig().getSort();
        List<SortKey<Mdr14Record>> keys = MdrUtils.sortList(sort, countries);
        String lastName = null;
        Mdr29Record mdr29 = null;
        for (SortKey<Mdr14Record> key : keys) {
            Mdr14Record country = key.getObject();
            String name = country.getName();
            if (!name.equals(lastName)) {
                mdr29 = new Mdr29Record();
                mdr29.setName(name);
                mdr29.setStrOffset(country.getStrOff());
                this.index.add(mdr29);
                lastName = name;
            }
            assert (mdr29 != null);
            country.setMdr29(mdr29);
        }
    }

    @Override
    protected void preWriteImpl() {
        if (!this.index.isEmpty()) {
            Mdr29Record r = this.index.get(this.index.size() - 1);
            this.max17 = r.getMdr17();
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int magic = this.getExtraValue();
        boolean hasString = (magic & 1) != 0;
        boolean has26 = (magic & 8) != 0;
        boolean has17 = (magic & 0x30) != 0;
        MdrSection.PointerSizes sizes = this.getSizes();
        int size24 = sizes.getSize(24);
        int size22 = sizes.getSize(22);
        int size25 = sizes.getSize(5);
        int size26 = has26 ? sizes.getSize(26) : 0;
        int size17 = Mdr29.numberToPointerSize(this.max17);
        for (Mdr29Record record : this.index) {
            this.putN(writer, size24, record.getMdr24());
            if (hasString) {
                this.putStringOffset(writer, record.getStrOffset());
            }
            this.putN(writer, size22, record.getMdr22());
            this.putN(writer, size25, record.getMdr25());
            if (has26) {
                this.putN(writer, size26, record.getMdr26());
            }
            if (!has17) continue;
            this.putN(writer, size17, record.getMdr17());
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getSize(24) + sizes.getSize(22) + sizes.getSize(5);
        if (this.isForDevice()) {
            size += Mdr29.numberToPointerSize(this.max17);
        } else {
            size += sizes.getStrOffSize();
            size += sizes.getSize(26);
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.index.size();
    }

    @Override
    public int getExtraValue() {
        if (this.isForDevice()) {
            int magic = 6;
            return magic |= Mdr29.numberToPointerSize(this.max17) << 4;
        }
        return 15;
    }
}

