/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.srt.MultiSortKey;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.srt.SortKey;

public class Mdr5
extends MdrMapSection {
    private List<Mdr5Record> allCities = new ArrayList<Mdr5Record>();
    private List<Mdr5Record> cities = new ArrayList<Mdr5Record>();
    private int maxCityIndex;
    private int localCitySize;

    public Mdr5(MdrConfig config) {
        this.setConfig(config);
    }

    public void addCity(Mdr5Record record) {
        assert (record.getMapIndex() != 0);
        this.allCities.add(record);
        if (record.getCityIndex() > this.maxCityIndex) {
            this.maxCityIndex = record.getCityIndex();
        }
    }

    @Override
    public void preWriteImpl() {
        this.localCitySize = Mdr5.numberToPointerSize(this.maxCityIndex + 1);
        ArrayList<SortKey<Mdr5Record>> sortKeys = new ArrayList<SortKey<Mdr5Record>>(this.allCities.size());
        Sort sort = this.getConfig().getSort();
        for (Mdr5Record m : this.allCities) {
            if (m.getName() == null) continue;
            SortKey<Mdr5Record> sortKey = sort.createSortKey(m, m.getName());
            SortKey<Object> regionKey = sort.createSortKey(null, m.getRegionName());
            SortKey<Object> countryKey = sort.createSortKey(null, m.getCountryName(), m.getMapIndex());
            sortKey = new MultiSortKey<Object>(sortKey, regionKey, countryKey);
            sortKeys.add(sortKey);
        }
        Collections.sort(sortKeys);
        Collator collator = this.getConfig().getSort().getCollator();
        int count = 0;
        Mdr5Record lastCity = null;
        int[] mdr20s = new int[sortKeys.size() + 1];
        int mdr20count = 0;
        for (SortKey sortKey : sortKeys) {
            Mdr5Record c = (Mdr5Record)sortKey.getObject();
            c.setMdr20set(mdr20s);
            if (!c.isSameByName(collator, lastCity)) {
                ++mdr20count;
            }
            c.setMdr20Index(mdr20count);
            if (c.isSameByMapAndName(collator, lastCity)) {
                c.setGlobalCityIndex(count);
                continue;
            }
            c.setGlobalCityIndex(++count);
            this.cities.add(c);
            lastCity = c;
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        int size20 = this.getSizes().getMdr20Size();
        Mdr5Record lastCity = null;
        boolean hasString = this.hasFlag(8);
        boolean hasRegion = this.hasFlag(4);
        Collator collator = this.getConfig().getSort().getCollator();
        for (Mdr5Record city : this.cities) {
            int gci = city.getGlobalCityIndex();
            this.addIndexPointer(city.getMapIndex(), gci);
            int flag = 0;
            int mapIndex = city.getMapIndex();
            int region = city.getRegionIndex();
            if (!city.isSameByName(collator, lastCity)) {
                flag = 0x800000;
                lastCity = city;
            }
            this.putMapIndex(writer, mapIndex);
            this.putLocalCityIndex(writer, city.getCityIndex());
            writer.put3(flag | city.getLblOffset());
            if (hasRegion) {
                writer.putChar((char)region);
            }
            if (hasString) {
                this.putStringOffset(writer, city.getStringOffset());
            }
            this.putN(writer, size20, city.getMdr20());
        }
    }

    private void putLocalCityIndex(ImgFileWriter writer, int cityIndex) {
        if (this.localCitySize == 2) {
            writer.putChar((char)cityIndex);
        } else {
            writer.put((byte)cityIndex);
        }
    }

    @Override
    public int getItemSize() {
        MdrSection.PointerSizes sizes = this.getSizes();
        int size = sizes.getMapSize() + this.localCitySize + 3 + sizes.getMdr20Size();
        if (this.hasFlag(4)) {
            size += 2;
        }
        if (this.hasFlag(8)) {
            size += sizes.getStrOffSize();
        }
        return size;
    }

    @Override
    protected int numberOfItems() {
        return this.cities.size();
    }

    @Override
    public int getExtraValue() {
        int val = this.localCitySize - 1;
        if (this.isForDevice()) {
            val |= 0x40;
        } else {
            val |= 4;
            val |= 8;
        }
        val |= 0x10;
        return val |= 0x100;
    }

    @Override
    protected void releaseMemory() {
        this.allCities = null;
        this.cities = null;
    }

    public List<Mdr5Record> getCities() {
        return Collections.unmodifiableList(this.allCities);
    }

    public List<Mdr5Record> getSortedCities() {
        return Collections.unmodifiableList(this.cities);
    }

    @Override
    public void relabelMaps(Mdr1 maps) {
        this.relabel(maps, this.cities);
    }
}

