/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.RecordBase;

public abstract class MdrMapSection
extends MdrSection
implements HasHeaderFlags {
    private Mdr1 index;

    public void setMapIndex(Mdr1 index) {
        this.index = index;
    }

    public final void initIndex(int sectionNumber) {
        int n = this.getNumberOfItems();
        this.index.setPointerSize(sectionNumber, MdrMapSection.numberToPointerSize(n));
    }

    public void addIndexPointer(int mapNumber, int recordNumber) {
        if (!this.isForDevice()) {
            this.index.addPointer(mapNumber, recordNumber);
        }
    }

    protected void putCityIndex(ImgFileWriter writer, int cityIndex, boolean isNew) {
        int flag = isNew && cityIndex > 0 ? this.getSizes().getCityFlag() : 0;
        this.putN(writer, this.getSizes().getCitySizeFlagged(), cityIndex | flag);
    }

    protected void putRegionIndex(ImgFileWriter writer, int region) {
        this.putN(writer, this.getSizes().getCitySizeFlagged(), region);
    }

    protected void putPoiIndex(ImgFileWriter writer, int poiIndex, boolean isNew) {
        int flag = isNew ? this.getSizes().getPoiFlag() : 0;
        this.putN(writer, this.getSizes().getPoiSizeFlagged(), poiIndex | flag);
    }

    protected boolean hasFlag(int val) {
        return (this.getExtraValue() & val) != 0;
    }

    public abstract void relabelMaps(Mdr1 var1);

    protected <T extends RecordBase> void relabel(Mdr1 maps, List<T> records) {
        for (RecordBase r : records) {
            int n = r.getMapIndex();
            int newIndex = maps.sortedMapIndex(n);
            r.setMapIndex(newIndex);
        }
    }
}

