/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.ConfigBase;

public abstract class MdrSection
extends ConfigBase {
    private PointerSizes sizes;
    private boolean released;
    protected int nItems;
    private boolean sizeValid;

    public abstract void writeSectData(ImgFileWriter var1);

    public abstract int getItemSize();

    protected PointerSizes getSizes() {
        return this.sizes;
    }

    public void setSizes(PointerSizes sizes) {
        this.sizes = sizes;
    }

    protected void putMapIndex(ImgFileWriter writer, int mapIndex) {
        this.putN(writer, this.sizes.getMapSize(), mapIndex);
    }

    protected void putStringOffset(ImgFileWriter writer, int strOff) {
        this.putN(writer, this.sizes.getStrOffSize(), strOff);
    }

    protected void putN(ImgFileWriter writer, int n, int value) {
        switch (n) {
            case 1: {
                writer.put((byte)value);
                break;
            }
            case 2: {
                writer.putChar((char)value);
                break;
            }
            case 3: {
                writer.put3(value);
                break;
            }
            case 4: {
                writer.putInt(value);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    protected static int numberToPointerSize(int n) {
        if (n > 0xFFFFFF) {
            return 4;
        }
        if (n > 65535) {
            return 3;
        }
        if (n > 255) {
            return 2;
        }
        return 1;
    }

    public final int getNumberOfItems() {
        assert (this.sizeValid);
        if (this.released) {
            return this.nItems;
        }
        return this.numberOfItems();
    }

    protected abstract int numberOfItems();

    public int getSizeForRecord() {
        return MdrSection.numberToPointerSize(this.getNumberOfItems());
    }

    public final void preWrite() {
        if (!this.sizeValid) {
            this.preWriteImpl();
        }
        this.sizeValid = true;
    }

    protected void preWriteImpl() {
    }

    public final void release() {
        this.nItems = this.numberOfItems();
        this.releaseMemory();
        this.released = true;
    }

    protected void releaseMemory() {
        throw new UnsupportedOperationException();
    }

    static class PointerSizes {
        private final MdrSection[] sections;

        public PointerSizes(MdrSection[] sections) {
            this.sections = sections;
        }

        public int getMapSize() {
            return this.sections[1].getSizeForRecord();
        }

        public int getCitySize() {
            return this.sections[5].getSizeForRecord();
        }

        public int getCitySizeFlagged() {
            return Math.max(2, MdrSection.numberToPointerSize(this.sections[5].getNumberOfItems() << 1));
        }

        public int getCityFlag() {
            return this.flagForSize(this.getCitySizeFlagged());
        }

        public int getStreetSize() {
            return this.sections[7].getSizeForRecord();
        }

        public int getStreetSizeFlagged() {
            return MdrSection.numberToPointerSize(this.sections[7].getNumberOfItems() << 1);
        }

        public int getPoiSize() {
            return this.sections[11].getSizeForRecord();
        }

        public int getZipSize() {
            return this.sections[6].getSizeForRecord();
        }

        public int getPoiSizeFlagged() {
            return MdrSection.numberToPointerSize(this.sections[11].getNumberOfItems() << 1);
        }

        public int getPoiFlag() {
            return this.flagForSize(this.getPoiSizeFlagged());
        }

        public int getStrOffSize() {
            return Math.max(3, this.sections[15].getSizeForRecord());
        }

        public int getMdr20Size() {
            return this.sections[20].getSizeForRecord();
        }

        private int flagForSize(int size) {
            int flag = size == 1 ? 128 : (size == 2 ? 32768 : (size == 3 ? 0x800000 : (size == 4 ? Integer.MIN_VALUE : 0)));
            return flag;
        }

        public int getSize(int sect) {
            return this.sections[sect].getSizeForRecord();
        }
    }
}

