/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.trergn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.LBLFile;
import uk.me.parabola.imgfmt.app.trergn.InternalFiles;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.RGNFile;
import uk.me.parabola.imgfmt.app.trergn.SubdivData;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;

public class Subdivision {
    private static final Logger log = Logger.getLogger(Subdivision.class);
    private static final int MAP_POINT = 0;
    private static final int MAP_INDEXED_POINT = 1;
    private static final int MAP_LINE = 2;
    private static final int MAP_SHAPE = 3;
    private final LBLFile lblFile;
    private final RGNFile rgnFile;
    private int startRgnPointer;
    private int endRgnPointer;
    private int lastMapElement;
    private final Zoom zoomLevel;
    private boolean hasPoints;
    private boolean hasIndPoints;
    private boolean hasPolylines;
    private boolean hasPolygons;
    private int numPolylines;
    private final int longitude;
    private final int latitude;
    private final int width;
    private final int height;
    private int number;
    private boolean last;
    private final List<Subdivision> divisions = new ArrayList<Subdivision>();
    private int extTypeAreasOffset;
    private int extTypeLinesOffset;
    private int extTypePointsOffset;
    private int extTypeAreasSize;
    private int extTypeLinesSize;
    private int extTypePointsSize;

    private Subdivision(InternalFiles ifiles, Area area, Zoom z) {
        this.lblFile = ifiles.getLblFile();
        this.rgnFile = ifiles.getRgnFile();
        this.zoomLevel = z;
        int shift = this.getShift();
        int mask = this.getMask();
        this.latitude = Utils.roundUp((area.getMinLat() + area.getMaxLat()) / 2, shift);
        this.longitude = Utils.roundUp((area.getMinLong() + area.getMaxLong()) / 2, shift);
        int w = 2 * (this.longitude - area.getMinLong());
        int h = 2 * (this.latitude - area.getMinLat());
        w = (w + 1) / 2 + mask >> shift;
        h = (h + 1) / 2 + mask >> shift;
        if (w > Short.MAX_VALUE) {
            log.warn((Object)("Subdivision width is " + w + " at " + this.getCenter()));
            w = Short.MAX_VALUE;
        }
        if (h > 65535) {
            log.warn((Object)("Subdivision height is " + h + " at " + this.getCenter()));
            h = 65535;
        }
        this.width = w;
        this.height = h;
    }

    private Subdivision(Zoom z, SubdivData data) {
        this.lblFile = null;
        this.rgnFile = null;
        this.zoomLevel = z;
        this.latitude = data.getLat();
        this.longitude = data.getLon();
        this.width = data.getWidth();
        this.height = data.getHeight();
        this.startRgnPointer = data.getRgnPointer();
        this.endRgnPointer = data.getEndRgnOffset();
        int elem = data.getFlags();
        if ((elem & 0x10) != 0) {
            this.setHasPoints(true);
        }
        if ((elem & 0x20) != 0) {
            this.setHasIndPoints(true);
        }
        if ((elem & 0x40) != 0) {
            this.setHasPolylines(true);
        }
        if ((elem & 0x80) != 0) {
            this.setHasPolygons(true);
        }
    }

    public Subdivision createSubdivision(InternalFiles ifiles, Area area, Zoom zoom) {
        Subdivision div = new Subdivision(ifiles, area, zoom);
        zoom.addSubdivision(div);
        this.addSubdivision(div);
        return div;
    }

    public static Subdivision topLevelSubdivision(InternalFiles ifiles, Area area, Zoom zoom) {
        Subdivision div = new Subdivision(ifiles, area, zoom);
        zoom.addSubdivision(div);
        return div;
    }

    public static Subdivision createEmptySubdivision(int number) {
        Subdivision sd = new Subdivision(null, new SubdivData(0, 0, 0, 0, 0, 0, 0));
        sd.setNumber(number);
        return sd;
    }

    public static Subdivision readSubdivision(Zoom zoom, SubdivData subdivData) {
        return new Subdivision(zoom, subdivData);
    }

    public Zoom getZoom() {
        return this.zoomLevel;
    }

    public final int getShift() {
        return 24 - this.zoomLevel.getResolution();
    }

    protected int getMask() {
        return (1 << this.getShift()) - 1;
    }

    public final int getResolution() {
        return this.zoomLevel.getResolution();
    }

    public void write(ImgFileWriter file) {
        log.debug("write subdiv", this.latitude, this.longitude);
        file.put3(this.startRgnPointer);
        file.put(this.getType());
        file.put3(this.longitude);
        file.put3(this.latitude);
        assert (this.width <= Short.MAX_VALUE);
        assert (this.height <= 65535);
        file.putChar((char)(this.width | (this.last ? 32768 : 0)));
        file.putChar((char)this.height);
        if (!this.divisions.isEmpty()) {
            file.putChar((char)this.getNextLevel());
        }
    }

    public Point createPoint(String name) {
        Point p = new Point(this);
        Label label = this.lblFile.newLabel(name);
        p.setLabel(label);
        return p;
    }

    public Polyline createLine(String[] labels) {
        Label label = this.lblFile.newLabel(labels[0]);
        String nameSansGC = Label.stripGarminCodes(labels[0]);
        Polyline pl = new Polyline(this);
        pl.setLabel(label);
        if (labels[1] != null) {
            String[] refs;
            int maxSetIdx = 3;
            if (labels[3] == null) {
                maxSetIdx = labels[2] == null ? 1 : 2;
            }
            if ((refs = Arrays.copyOfRange(labels, 1, maxSetIdx + 1)).length == 1) {
                String tr = refs[0].trim();
                String trSansGC = Label.stripGarminCodes(tr);
                if (trSansGC.length() > 0 && !trSansGC.equalsIgnoreCase(nameSansGC)) {
                    pl.addRefLabel(this.lblFile.newLabel(tr));
                }
            } else if (refs.length > 1) {
                pl.addRefLabel(this.lblFile.newLabel(refs[0].trim()));
                for (int i = 1; i < refs.length; ++i) {
                    String tr = refs[i].trim();
                    String trSansGC = Label.stripGarminCodes(tr);
                    if (trSansGC.length() <= 0 || trSansGC.equalsIgnoreCase(nameSansGC)) continue;
                    pl.addRefLabel(this.lblFile.newLabel(tr));
                }
            }
        }
        return pl;
    }

    public void setPolylineNumber(Polyline pl) {
        pl.setNumber(++this.numPolylines);
    }

    public Polygon createPolygon(String name) {
        Label label = this.lblFile.newLabel(name);
        Polygon pg = new Polygon(this);
        pg.setLabel(label);
        return pg;
    }

    public void setNumber(int n) {
        this.number = n;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public void setStartRgnPointer(int startRgnPointer) {
        this.startRgnPointer = startRgnPointer;
    }

    public int getStartRgnPointer() {
        return this.startRgnPointer;
    }

    public int getEndRgnPointer() {
        return this.endRgnPointer;
    }

    public int getLongitude() {
        return this.longitude;
    }

    public int getLatitude() {
        return this.latitude;
    }

    public void setHasPoints(boolean hasPoints) {
        this.hasPoints = hasPoints;
    }

    public void setHasIndPoints(boolean hasIndPoints) {
        this.hasIndPoints = hasIndPoints;
    }

    public void setHasPolylines(boolean hasPolylines) {
        this.hasPolylines = hasPolylines;
    }

    public void setHasPolygons(boolean hasPolygons) {
        this.hasPolygons = hasPolygons;
    }

    public boolean hasPoints() {
        return this.hasPoints;
    }

    public boolean hasIndPoints() {
        return this.hasIndPoints;
    }

    public boolean hasPolylines() {
        return this.hasPolylines;
    }

    public boolean hasPolygons() {
        return this.hasPolygons;
    }

    public boolean needsIndPointPtr() {
        return this.hasIndPoints && this.hasPoints;
    }

    public boolean needsPolylinePtr() {
        return this.hasPolylines && (this.hasPoints || this.hasIndPoints);
    }

    public boolean needsPolygonPtr() {
        return this.hasPolygons && (this.hasPoints || this.hasIndPoints || this.hasPolylines);
    }

    public String toString() {
        return "Sub" + this.zoomLevel + '(' + this.getCenter().toOSMURL() + ')';
    }

    private byte getType() {
        byte b = 0;
        if (this.hasPoints) {
            b = (byte)(b | 0x10);
        }
        if (this.hasIndPoints) {
            b = (byte)(b | 0x20);
        }
        if (this.hasPolylines) {
            b = (byte)(b | 0x40);
        }
        if (this.hasPolygons) {
            b = (byte)(b | 0x80);
        }
        return b;
    }

    private int getNextLevel() {
        return this.divisions.get(0).getNumber();
    }

    public boolean hasNextLevel() {
        return !this.divisions.isEmpty();
    }

    public int getExtTypeAreasOffset() {
        return this.extTypeAreasOffset;
    }

    public int getExtTypeLinesOffset() {
        return this.extTypeLinesOffset;
    }

    public int getExtTypePointsOffset() {
        return this.extTypePointsOffset;
    }

    public int getExtTypeAreasSize() {
        return this.extTypeAreasSize;
    }

    public int getExtTypeLinesSize() {
        return this.extTypeLinesSize;
    }

    public int getExtTypePointsSize() {
        return this.extTypePointsSize;
    }

    public void startDivision() {
        this.rgnFile.startDivision(this);
        this.extTypeAreasOffset = this.rgnFile.getExtTypeAreasSize();
        this.extTypeLinesOffset = this.rgnFile.getExtTypeLinesSize();
        this.extTypePointsOffset = this.rgnFile.getExtTypePointsSize();
    }

    public void endDivision() {
        this.extTypeAreasSize = this.rgnFile.getExtTypeAreasSize() - this.extTypeAreasOffset;
        this.extTypeLinesSize = this.rgnFile.getExtTypeLinesSize() - this.extTypeLinesOffset;
        this.extTypePointsSize = this.rgnFile.getExtTypePointsSize() - this.extTypePointsOffset;
    }

    public void writeExtTypeOffsetsRecord(ImgFileWriter file) {
        file.putInt(this.extTypeAreasOffset);
        file.putInt(this.extTypeLinesOffset);
        file.putInt(this.extTypePointsOffset);
        int kinds = 0;
        if (this.extTypeAreasSize != 0) {
            ++kinds;
        }
        if (this.extTypeLinesSize != 0) {
            ++kinds;
        }
        if (this.extTypePointsSize != 0) {
            ++kinds;
        }
        file.put((byte)kinds);
    }

    public void writeLastExtTypeOffsetsRecord(ImgFileWriter file) {
        file.putInt(this.rgnFile.getExtTypeAreasSize());
        file.putInt(this.rgnFile.getExtTypeLinesSize());
        file.putInt(this.rgnFile.getExtTypePointsSize());
        file.put((byte)0);
    }

    public void readExtTypeOffsetsRecord(ImgFileReader reader, Subdivision sdPrev) {
        this.extTypeAreasOffset = reader.getInt();
        this.extTypeLinesOffset = reader.getInt();
        this.extTypePointsOffset = reader.getInt();
        reader.get();
        if (sdPrev != null) {
            sdPrev.extTypeAreasSize = this.extTypeAreasOffset - sdPrev.extTypeAreasOffset;
            sdPrev.extTypeLinesSize = this.extTypeLinesOffset - sdPrev.extTypeLinesOffset;
            sdPrev.extTypePointsSize = this.extTypePointsOffset - sdPrev.extTypePointsOffset;
        }
    }

    public void readLastExtTypeOffsetsRecord(ImgFileReader reader) {
        this.extTypeAreasSize = reader.getInt() - this.extTypeAreasOffset;
        this.extTypeLinesSize = reader.getInt() - this.extTypeLinesOffset;
        this.extTypePointsSize = reader.getInt() - this.extTypePointsOffset;
        byte test = reader.get();
        assert (test == 0);
    }

    private void addSubdivision(Subdivision sd) {
        this.divisions.add(sd);
    }

    public int getNumber() {
        return this.number;
    }

    public void startPoints() {
        if (this.lastMapElement > 0) {
            throw new IllegalStateException("Points must be drawn first");
        }
        this.lastMapElement = 0;
    }

    public void startIndPoints() {
        if (this.lastMapElement > 1) {
            throw new IllegalStateException("Indexed points must be done before lines and polygons");
        }
        this.lastMapElement = 1;
        this.rgnFile.setIndPointPtr();
    }

    public void startLines() {
        if (this.lastMapElement > 2) {
            throw new IllegalStateException("Lines must be done before polygons");
        }
        this.lastMapElement = 2;
        this.rgnFile.setPolylinePtr();
    }

    public void startShapes() {
        this.lastMapElement = 3;
        this.rgnFile.setPolygonPtr();
    }

    public int roundLatToLocalShifted(int absval) {
        int shift = this.getShift();
        int val = absval - this.getLatitude();
        return (val += (1 << shift) / 2) >> shift;
    }

    public int roundLonToLocalShifted(int absval) {
        int shift = this.getShift();
        int val = absval - this.getLongitude();
        return (val += (1 << shift) / 2) >> shift;
    }

    public Coord getCenter() {
        return new Coord(this.getLatitude(), this.getLongitude());
    }

    public int getWidth() {
        return this.width << this.getShift();
    }

    public int getHeight() {
        return this.height << this.getShift();
    }
}

