/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.sys;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.fs.ImgChannel;

public class FileImgChannel
implements ImgChannel {
    private final FileChannel channel;
    private long position;

    public FileImgChannel(String filename, String mode) {
        RandomAccessFile raf;
        try {
            raf = new RandomAccessFile(filename, mode);
        }
        catch (FileNotFoundException e) {
            throw new ReadFailedException("Could not open " + filename, e);
        }
        this.channel = raf.getChannel();
    }

    public FileImgChannel(FileChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int n = this.channel.read(dst);
        if (n > 0) {
            this.position += (long)n;
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int n = this.channel.write(src);
        this.position += (long)n;
        return n;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void position(long pos) {
        try {
            this.channel.position(pos);
            this.position = pos;
        }
        catch (IOException e) {
            throw new ReadFailedException("Could not seek", e);
        }
    }
}

